﻿using Mall.Common.Enum;
using Mall.Model.Entity.TradePavilion;
using Mall.Model.Extend.TradePavilion;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VT.FW.DB.Dapper;

namespace Mall.Repository.TradePavilion
{
    /// <summary>
    /// 【商载通】 品牌、企业服务仓储层
    /// </summary>
    public class RB_Brand_EnterpriseRepository : BaseRepository<RB_Brand_Enterprise>
    {
        /// <summary>
        /// 【商载通】品牌、企业服务仓储层
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Brand_Enterprise_Extend> GetBrandEnterprisePageRepository(int pageIndex, int pageSize, out long rowsCount, RB_Brand_Enterprise_Extend query)
        {
            DynamicParameters parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT A.*,IFNULL(B.ClassName,'') AS CategoryName 
FROM rb_brand_Enterprise AS A LEFT JOIN rb_brandclass AS B ON A.CategoryId=B.ID 
WHERE 1=1 ");
            builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Brand_Enterprise_Extend.Status), (int)DateStateEnum.Normal);
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Brand_Enterprise_Extend.TenantId), query.TenantId);
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Brand_Enterprise_Extend.MallBaseId), query.MallBaseId);
                }

                if (query.CategoryId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Brand_Enterprise_Extend.CategoryId), query.CategoryId);
                }
                if (query.UserId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Brand_Enterprise_Extend.UserId), query.UserId);
                }
                if (!string.IsNullOrEmpty(query.BrandName))
                {
                    builder.AppendFormat(" AND A.{0} LIKE @BrandName ", nameof(RB_Brand_Enterprise_Extend.BrandName));
                    parameters.Add("@BrandName", "%" + query.BrandName + "%");
                }
            }
            builder.AppendFormat(" ORDER BY A.{0} DESC ", nameof(RB_Brand_Enterprise_Extend.ID));
            return GetPage<RB_Brand_Enterprise_Extend>(pageIndex, pageSize, out rowsCount, builder.ToString(), parameters).ToList();
        }

        /// <summary>
        /// 【商载通】品牌、企业服务仓储层统计专用
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Brand_Enterprise_Extend> GetBrandEnterpriseBriefRepository(RB_Brand_Enterprise_Extend query, string startTime = "", string endTime = "")
        {
            DynamicParameters parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@" SELECT A.ID,A.CreateDate,A.BrandEnterpriseType FROM rb_brand_Enterprise AS A  WHERE 1=1 and A.Status=0 ");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Brand_Enterprise_Extend.TenantId), query.TenantId);
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Brand_Enterprise_Extend.MallBaseId), query.MallBaseId);
                }

                if (query.CategoryId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Brand_Enterprise_Extend.CategoryId), query.CategoryId);
                }
                if (query.UserId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Brand_Enterprise_Extend.UserId), query.UserId);
                }
                if (!string.IsNullOrEmpty(query.BrandName))
                {
                    builder.AppendFormat(" AND A.{0} LIKE @BrandName ", nameof(RB_Brand_Enterprise_Extend.BrandName));
                    parameters.Add("@BrandName", "%" + query.BrandName + "%");
                }

            }
            if (!string.IsNullOrWhiteSpace(startTime))
            {
                builder.Append($" and  DATE_FORMAT(A.{nameof(RB_Brand_Enterprise_Extend.CreateDate)},'%Y-%m-%d' )>=DATE_FORMAT('{startTime}','%Y-%m-%d' ) ");
            }
            if (!string.IsNullOrWhiteSpace(endTime))
            {
                builder.Append($" and  DATE_FORMAT(A.{nameof(RB_Brand_Enterprise_Extend.CreateDate)},'%Y-%m-%d' )<= DATE_FORMAT('{endTime}','%Y-%m-%d' ) ");
            }
            return Get<RB_Brand_Enterprise_Extend>(builder.ToString(), parameters).ToList();
        }

        /// <summary>
        /// 【商载通】品牌、企业服务仓储层
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Brand_Enterprise_Extend> GetBrandEnterpriseListRepository(RB_Brand_Enterprise_Extend query)
        {
            DynamicParameters parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT A.*,IFNULL(B.ClassName,'') AS CategoryName 
FROM rb_brand_Enterprise AS A LEFT JOIN rb_brandclass AS B ON A.CategoryId=B.ID
WHERE 1=1
");
            builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Brand_Enterprise_Extend.Status), (int)DateStateEnum.Normal);
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Brand_Enterprise_Extend.TenantId), query.TenantId);
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Brand_Enterprise_Extend.MallBaseId), query.MallBaseId);
                }

                if (query.CategoryId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Brand_Enterprise_Extend.CategoryId), query.CategoryId);
                }
                if (query.UserId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Brand_Enterprise_Extend.UserId), query.UserId);
                }
                if (!string.IsNullOrEmpty(query.BrandName))
                {
                    builder.AppendFormat(" AND A.{0} LIKE @BrandName ", nameof(RB_Brand_Enterprise_Extend.BrandName));
                    parameters.Add("@BrandName", "%" + query.BrandName + "%");
                }
                if (!string.IsNullOrEmpty(query.SelectIds))
                {
                    builder.AppendFormat(" AND A.{0} in ({1}) ", nameof(RB_Brand_Enterprise_Extend.ID), query.SelectIds);
                }
            }
            return Get<RB_Brand_Enterprise_Extend>(builder.ToString(), parameters).ToList();
        }


        /// <summary>
        /// 获取首店以及商品牌信息
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Brand_Enterprise_Extend> GetAllBrandEnterprisePageRepository(int pageIndex, int pageSize, out long rowsCount, RB_Brand_Enterprise_Extend query)
        {
            DynamicParameters parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@" SELECT A.*  FROM all_brand AS A  WHERE 1=1 ");

            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Brand_Enterprise_Extend.TenantId), query.TenantId);
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Brand_Enterprise_Extend.MallBaseId), query.MallBaseId);
                }
                if (query.CategoryId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Brand_Enterprise_Extend.CategoryId), query.CategoryId);
                }
                if (query.MixShopNum > 0)
                {
                    builder.AppendFormat(" AND A.{0}>={1} ", nameof(RB_Brand_Enterprise_Extend.ShopNum), query.MixShopNum);
                }
                if (query.MaxShopNum > 0)
                {
                    builder.AppendFormat(" AND A.{0} <={1} ", nameof(RB_Brand_Enterprise_Extend.ShopNum), query.MaxShopNum);
                }
                if (query.MixAreaRequirement > 0&& query.MaxAreaRequirement > 0)
                {
                    // AND((AreaRequirement>=500 AND AreaRequirement<=2000) OR (AreaRequirement<= 500 AND EndAreaRequirement>=2000) OR (EndAreaRequirement>=500 AND EndAreaRequirement<=2000)) ; 
                    builder.AppendFormat(" AND((A.{0}>={1} AND A.{0}<={2}) OR (A.{0}<= {1} AND A.{3}>={2}) OR (A.{3}>={1} AND A.{3}<={2})) ", nameof(RB_Brand_Enterprise_Extend.AreaRequirement), query.MixAreaRequirement,  query.MaxAreaRequirement,nameof(RB_Brand_Enterprise_Extend.EndAreaRequirement));
                }
                else if (query.MixAreaRequirement > 0)
                {
                    builder.AppendFormat(" AND A.{0} >={1} ", nameof(RB_Brand_Enterprise_Extend.AreaRequirement), query.MixAreaRequirement);
                }
                else if (query.MaxAreaRequirement > 0)
                {
                    builder.AppendFormat(" AND  A.{0} <={1}    ", nameof(RB_Brand_Enterprise_Extend.EndAreaRequirement), query.MaxAreaRequirement);
                }
                if (query.IsInChengdu > -1)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Brand_Enterprise_Extend.IsInChengdu), query.IsInChengdu);
                }
                if (!string.IsNullOrEmpty(query.BrandName))
                {
                    builder.AppendFormat(" AND A.{0} LIKE @BrandName ", nameof(RB_Brand_Enterprise_Extend.BrandName));
                    parameters.Add("@BrandName", "%" + query.BrandName + "%");
                }
            }
            builder.AppendFormat(" ORDER BY A.{0} DESC ", nameof(RB_Brand_Enterprise_Extend.ID));
            return GetPage<RB_Brand_Enterprise_Extend>(pageIndex, pageSize, out rowsCount, builder.ToString(), parameters).ToList();
        }

    }
}
