﻿using VT.FW.DB;
using Mall.Common.Enum.User;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.Property
{
    /// <summary>
    /// 电商库存系统日志表实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Property_Log
    {

        /// <summary>
        /// Id
        /// </summary>        
        public int Id
        {
            get;
            set;
        }

        /// <summary>
        /// 商户id
        /// </summary>
        public int TenantId { get; set; }

        /// <summary>
        /// 小程序id
        /// </summary>
        public int MallBaseId { get; set; }

        /// <summary>
        /// 来源id
        /// </summary>        
        public int? SourceId
        {
            get;
            set;
        }
        /// <summary>
        /// 来源类型  1仓库操作   2商品操作   3 采购,4集团授权，5用户授权,6-出库, 7重新入库
        /// </summary>        
        public int? Type
        {
            get;
            set;
        }
        /// <summary>
        /// 操作内容
        /// </summary>        
        public string Content
        {
            get;
            set;
        }
        /// <summary>
        /// 操作人
        /// </summary>        
        public int CreateBy
        {
            get;
            set;
        }
        /// <summary>
        /// CreateDate
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }
    }
}
