﻿using System;
using VT.FW.DB;
using Mall.Common.Plugin;

namespace Mall.Model.Entity.Property
{

    /// <summary>
    /// 耗材库存日志实体
    /// </summary> 
    [Serializable]
    [DB(ConnectionName = "PropertyConnection")]
    public class RB_Supplies_InventoryDetail
    {

        /// <summary>
        /// Id
        /// </summary>        
        public int Id
        {
            get;
            set;
        }
        /// <summary>
        /// 库存表id
        /// </summary>        
        public int? InventoryId
        {
            get;
            set;
        }
        /// <summary>
        /// 类型  增加还是减少  1增加  2减少
        /// </summary>        
        public int? Type
        {
            get;
            set;
        }
        /// <summary>
        /// 库存数量
        /// </summary>        
        public int? Number
        {
            get;
            set;
        }
        /// <summary>
        /// 变动的金额
        /// </summary>
        public decimal? Money { get; set; }
        /// <summary>
        /// 描述
        /// </summary>        
        public string Description
        {
            get;
            set;
        }
        /// <summary>
        /// 状态 0正常  1删除
        /// </summary>        
        public int? Status
        {
            get;
            set;
        }
        /// <summary>
        /// 公司
        /// </summary>        
        public int? RB_Branch_Id
        {
            get;
            set;
        }
        /// <summary>
        /// 集团
        /// </summary>        
        public int? RB_Group_Id
        {
            get;
            set;
        }
        /// <summary>
        /// CreateBy
        /// </summary>        
        public int? CreateBy
        {
            get;
            set;
        }
        /// <summary>
        /// CreateDate
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }
    }
}