﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Model.Entity.MarketingCenter;
using Mall.Model.Extend.MarketingCenter;

namespace Mall.Repository.MarketingCenter
{
    public class RB_ActivitySurveyRepository : BaseRepository<RB_ActivitySurvey>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_ActivitySurvey); } }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<RB_ActivitySurvey_Extend> GetList(RB_ActivitySurvey_Extend where)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append($@"SELECT * from RB_ActivitySurvey  where state=0");
            if (where != null)
            {
                if (where.TenantId > 0)
                {
                    sb.AppendFormat(" and TenantId={0}", where.TenantId);
                }
                if (where.MallBaseId > 0)
                {
                    sb.AppendFormat(" and MallBaseId={0}", where.MallBaseId);
                }
                if (where.ID > 0)
                {
                    sb.AppendFormat(" and ID={0}", where.ID);
                }

                if (string.IsNullOrWhiteSpace(where.Title))
                {
                    sb.AppendFormat(" and Title like'%{0}%'", where.Title);
                }
                if (where.PrizeType.HasValue && (int)where.PrizeType > 0)
                {
                    sb.AppendFormat(" and PrizeType={0}", (int)where.PrizeType);
                }
            }
            return Get<RB_ActivitySurvey_Extend>(sb.ToString()).ToList();
        }




        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<RB_ActivitySurvey_Extend> GetPageList(int pageIndex, int pageSize, out long rowsCount, RB_ActivitySurvey_Extend where)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append($@"SELECT * from RB_ActivitySurvey  where state=0");
            if (where != null)
            {
                if (where.TenantId > 0)
                {
                    sb.AppendFormat(" and TenantId={0}", where.TenantId);
                }
                if (where.MallBaseId > 0)
                {
                    sb.AppendFormat(" and MallBaseId={0}", where.MallBaseId);
                }
                if (where.PrizeType.HasValue && (int)where.PrizeType > 0)
                {
                    sb.AppendFormat(" and PrizeType={0}", (int)where.PrizeType);
                }
                if (!string.IsNullOrWhiteSpace(where.Title))
                {
                    sb.AppendFormat(" and Title like'%{0}%'", where.Title);
                }
            }
            return GetPage<RB_ActivitySurvey_Extend>(pageIndex, pageSize, out rowsCount, sb.ToString()).ToList();
        }
    }
}
