﻿using System;
using System.Collections.Generic;

namespace Mall.ThirdCore.Oss
{
    public interface IOssService
    {
        /// <summary>
        /// 文件上传
        /// </summary>
        /// <param name="fileName">目录+文件名</param>
        /// <param name="stream">文件流</param>
        /// <returns></returns>
        OssResult UploadFile(string fileName, System.IO.Stream stream);

        /// <summary>
        /// 文件删除
        /// </summary>
        /// <param name="fileName">文件名</param>
        /// <returns></returns>
        OssResult DeleteFile(string fileName);

        /// <summary>
        /// 文件批量删除
        /// </summary>
        /// <param name="fileName">文件名</param>
        /// <returns></returns>
        OssResult DeleteFile(List<string> fileName);

        /// <summary>
        /// 拷贝文件
        /// </summary>
        /// <param name="sourceFileName">原文件的名称</param>
        /// <param name="targetFileName">目标文件的名称</param>
        OssResult FileCopy(string sourceFileName,string targetFileName);

        /// <summary>
        /// 文件是否存在
        /// </summary>
        /// <param name="fileName">文件名</param>
        /// <returns></returns>
        Boolean FileIsExist(string fileName);
    }
}