﻿using VT.FW.DB;
using Mall.Common.Enum;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.BaseSetUp
{
    /// <summary>
    /// 地区
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Destination
    {

        /// <summary>
        /// 主键
        /// </summary>
        public int ID
        {
            get;
            set;
        }

        /// <summary>
        /// 名称
        /// </summary>        
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// 父级节点编号
        /// </summary>        
        public int? ParentID
        {
            get;
            set;
        }

        /// <summary>
        /// 等级 1-国家，2-省，3-市，4-区县
        /// </summary>        
        public AreaRegionEnum CodeLevel
        {
            get;
            set;
        }

        /// <summary>
        /// 三码
        /// </summary>
        public string ThreeCode { get; set; }

        /// <summary>
        /// 地区英文名
        /// </summary>
        public string EnName { get; set; }

        /// <summary>
        /// 四字码
        /// </summary>
        public string FourCode { get; set; }

        /// <summary>
        /// 自定义区域，如'1,2'
        /// </summary>
        public string Area { get; set; }

        /// <summary>
        /// 删除状态
        /// </summary>        
        public Common.Enum.DateStateEnum Status
        {
            get;
            set;
        }

        /// <summary>
        /// 经度
        /// </summary>        
        public string Lng
        {
            get;
            set;
        }

        /// <summary>
        /// 纬度
        /// </summary>        
        public string Lat
        {
            get;
            set;
        }
        /// <summary>
        /// 城市图片
        /// </summary>
        public string Images { get; set; }
    }
}
