﻿using VT.FW.DB;
using Mall.Common.Enum.User;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.User
{
    /// <summary>
    /// 微店价格表实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_SmallShops_Price
    {

        /// <summary>
        /// Id
        /// </summary>        
        public int Id
        {
            get;
            set;
        }
        /// <summary>
        /// 微店id
        /// </summary>        
        public int? SmallShopsId
        {
            get;
            set;
        }
        /// <summary>
        /// 商品id
        /// </summary>        
        public int? GoodsId
        {
            get;
            set;
        }
        /// <summary>
        /// 商品规格key
        /// </summary>
        public string SpecificationKey { get; set; }
        /// <summary>
        /// 上调价格
        /// </summary>        
        public decimal? UpPrice
        {
            get;
            set;
        }
        /// <summary>
        /// 类型  1百分比  2固定金额
        /// </summary>        
        public int? PriceType
        {
            get;
            set;
        }
        /// <summary>
        /// 删除状态
        /// </summary>        
        public int? Status
        {
            get;
            set;
        }
        /// <summary>
        /// 商户号
        /// </summary>        
        public int TenantId
        {
            get;
            set;
        }
        /// <summary>
        /// 小程序id
        /// </summary>        
        public int MallBaseId
        {
            get;
            set;
        }
        /// <summary>
        /// CreateDate
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }
        /// <summary>
        /// UpdateDate
        /// </summary>        
        public DateTime? UpdateDate
        {
            get;
            set;
        }
    }
}
