﻿using Mall.Model.Entity.Product;
using Mall.Model.Extend.Product;
using System;
using System.Collections.Generic;
using System.Text;
using System.Linq;

namespace Mall.Repository.Product
{
    /// <summary>
    /// 拼团活动仓储层
    /// </summary>
    public class RB_Groupbuy_ActivityRepository : BaseRepository<RB_Groupbuy_Activity>
    {
        /// <summary>
        ///  获取拼团活动分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowsCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Groupbuy_Activity_Extend> GetGroupbuyActivityPageListRepository(int pageIndex, int pageSize, out long rowsCount, RB_Groupbuy_Activity_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT A.*,B.Name AS QGoodName,B.CarouselImage AS CarouselImage
FROM RB_Groupbuy_Activity AS A LEFT JOIN rb_goods AS B ON A.GoodId=B.Id
WHERE 1=1 
");
            if (query != null)
            {
                //时间范围
                if (!string.IsNullOrWhiteSpace(query.QStartDate) && !string.IsNullOrWhiteSpace(query.QEndDate))
                {
                    builder.AppendFormat(@" AND
                        (
                            '{0}' BETWEEN StartTime AND EndTime OR 
                            '{1}' BETWEEN StartTime AND EndTime OR 
                            StartTime BETWEEN '{0}' AND '{1}' OR
                            EndTime BETWEEN '{0}' AND '{1}'
                        )", Convert.ToDateTime(query.QStartDate).ToString("yyyy-MM-dd HH:mm:ss"), Convert.ToDateTime(query.QEndDate).ToString("yyyy-MM-dd HH:mm:ss"));
                }
                if (!string.IsNullOrWhiteSpace(query.QGoodName))
                {
                    builder.AppendFormat(@" AND B.Name LIKE '%{0}%' ", query.QGoodName);
                }
                if (query.GoodsStatus > 0)
                {
                    builder.AppendFormat(@" AND A.GoodsStatus={0} ", query.GoodsStatus);
                }
            }
            return GetPage<RB_Groupbuy_Activity_Extend>(pageIndex, pageSize, out rowsCount, builder.ToString()).ToList();
        }


        /// <summary>
        /// 获取活动实体类
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public RB_Groupbuy_Activity_Extend GetGroupbuyActivityEntityRepository(RB_Groupbuy_Activity_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT * 
FROM RB_Groupbuy_Activity
WHERE 1=1 
");
            return Get<RB_Groupbuy_Activity_Extend>(builder.ToString()).FirstOrDefault();
        }

    }

    /// <summary>
    /// 拼团商品关联规格价格仓储层
    /// </summary>
    public class RB_Groupbuy_Activity_SpecificationPriceRepository : BaseRepository<RB_Groupbuy_Activity_Specificationprice>
    {
        /// <summary>
        /// 获取拼团活动商品规格价格列表
        /// </summary>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Groupbuy_Activity_Specificationprice_Extend> GetGroupbuyActivitySpecificationpriceListRepository(RB_Groupbuy_Activity_Specificationprice_Extend dmodel)
        {
            string where = $" 1=1 and {nameof(RB_Groupbuy_Activity_Specificationprice_Extend.Status)}=0";
            if (dmodel.TenantId > 0)
            {
                where += $@" and {nameof(RB_Groupbuy_Activity_Specificationprice_Extend.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_Groupbuy_Activity_Specificationprice_Extend.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Id > 0)
            {
                where += $@" and {nameof(RB_Groupbuy_Activity_Specificationprice_Extend.Id)}={dmodel.Id}";
            }
            if (dmodel.GoodsId > 0)
            {
                where += $@" and {nameof(RB_Groupbuy_Activity_Specificationprice_Extend.GoodsId)}={dmodel.GoodsId}";
            }
            if (!string.IsNullOrEmpty(dmodel.GoodsIds))
            {
                where += $@" and {nameof(RB_Groupbuy_Activity_Specificationprice_Extend.GoodsId)} in({dmodel.GoodsIds})";
            }

            string sql = $@"select * from rb_groupbuy_activity_specificationprice where {where} order by Id desc";
            return Get<RB_Groupbuy_Activity_Specificationprice_Extend>(sql).ToList();
        }

    }

    /// <summary>
    /// 拼团活动商品关联规格值仓储层
    /// </summary>
    public class RB_Groupbuy_Activity_SpecificationValueRepository : BaseRepository<RB_Groupbuy_Activity_Specificationvalue>
    {

        /// <summary>
        /// 获取拼团活动商品关联规格值列表
        /// </summary>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Groupbuy_Activity_Specificationvalue_Extend> GetGroupbuyActivitySpecificationValueListRepository(RB_Groupbuy_Activity_Specificationvalue_Extend dmodel)
        {
            string where = $" 1=1 and {nameof(RB_Groupbuy_Activity_Specificationvalue_Extend.Status)}=0";
            if (dmodel.TenantId > 0)
            {
                where += $@" and {nameof(RB_Groupbuy_Activity_Specificationvalue_Extend.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_Groupbuy_Activity_Specificationvalue_Extend.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Id > 0)
            {
                where += $@" and {nameof(RB_Groupbuy_Activity_Specificationvalue_Extend.Id)}={dmodel.Id}";
            }
            if (dmodel.SpecificationId > 0)
            {
                where += $@" and {nameof(RB_Groupbuy_Activity_Specificationvalue_Extend.SpecificationId)}={dmodel.SpecificationId}";
            }
            if (dmodel.GoodsId > 0)
            {
                where += $@" and {nameof(RB_Groupbuy_Activity_Specificationvalue_Extend.GoodsId)}={dmodel.GoodsId}";
            }
            if (!string.IsNullOrEmpty(dmodel.GoodsIds))
            {
                where += $@" and {nameof(RB_Groupbuy_Activity_Specificationvalue_Extend.GoodsId)} in({dmodel.GoodsIds})";
            }
            string sql = $@"select * from rb_groupbuy_activity_specificationvalue where {where} order by Id asc";
            return Get<RB_Groupbuy_Activity_Specificationvalue_Extend>(sql).ToList();
        }
    }

    /// <summary>
    /// 拼团商品关联规格仓储层
    /// </summary>
    public class RB_Groupbuy_Activity_SpecificationRepository : BaseRepository<RB_Groupbuy_Activity_Specification>
    {

        /// <summary>
        /// 获取拼团商品关联规格列表
        /// </summary>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Groupbuy_Activity_Specification_Extend> GetGroupbuyActivitySpecificationListRepository(RB_Groupbuy_Activity_Specification_Extend dmodel)
        {
            string where = $" 1=1 and {nameof(RB_Groupbuy_Activity_Specification_Extend.Status)}=0";
            if (dmodel.TenantId > 0)
            {
                where += $@" and {nameof(RB_Groupbuy_Activity_Specification_Extend.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_Groupbuy_Activity_Specification_Extend.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Id > 0)
            {
                where += $@" and {nameof(RB_Groupbuy_Activity_Specification_Extend.Id)}={dmodel.Id}";
            }
            if (dmodel.GoodsId > 0)
            {
                where += $@" and {nameof(RB_Groupbuy_Activity_Specification_Extend.GoodsId)}={dmodel.GoodsId}";
            }
            if (!string.IsNullOrEmpty(dmodel.GoodsIds))
            {
                where += $@" and {nameof(RB_Groupbuy_Activity_Specification_Extend.GoodsId)} in({dmodel.GoodsIds})";
            }

            string sql = $@"select * from rb_groupbuy_activity_specification where {where} order by Id asc";
            return Get<RB_Groupbuy_Activity_Specification_Extend>(sql).ToList();
        }
    }
}
