﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.User;
using Mall.Model.Extend.User;
using System.Linq;

namespace Mall.Repository.User
{
    /// <summary>
    /// 微店价格仓储层
    /// </summary>
    public class RB_SmallShops_PriceRepository : BaseRepository<RB_SmallShops_Price>
    {

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_SmallShops_Price_Extend> GetList(RB_SmallShops_Price_Extend dmodel)
        {
            string where = $@" 1=1 and di.{nameof(RB_SmallShops_Price_Extend.Status)}=0";
            if (dmodel.TenantId > 0)
            {
                where += $@" and di.{nameof(RB_SmallShops_Price_Extend.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and di.{nameof(RB_SmallShops_Price_Extend.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.SmallShopsId > 0)
            {
                where += $@" and di.{nameof(RB_SmallShops_Price_Extend.SmallShopsId)}={dmodel.SmallShopsId}";
            }
            if (!string.IsNullOrEmpty(dmodel.SmallShopsIds)) {
                where += $@" and di.{nameof(RB_SmallShops_Price_Extend.SmallShopsId)} in({dmodel.SmallShopsIds})";
            }
            

            string sql = $@"select di.* from RB_SmallShops_Price_Extend di
where {where} order by di.Id desc";
            return Get<RB_SmallShops_Price_Extend>(sql).ToList();
        }
    }
}
