﻿using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System;
using System.IO;
using System.Text.RegularExpressions;

namespace Mall.ThirdCore.Commom
{
    internal class Config
    {
        /// <summary>
        /// 日志保存路径
        /// </summary>
        public static string LogPath
        {
            get
            {

                string logPath = ReadConfigKey("LogPath");
                if (!logPath.ToString().Contains(":\\"))
                {
                    if (string.IsNullOrEmpty(logPath.ToString()))
                        logPath = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "log");
                    else
                    {
                        logPath = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, logPath.ToString());
                    }
                }


                return logPath.ToString();
            }
        }
        /// <summary>
        /// 获取阿里云Oss配置
        /// </summary>
        public static JObject AliOss
        {
            get
            {
                string aliOss = ReadConfigKey("AliOss");
                return JObject.Parse(aliOss.ToString());
            }
        }
        /// <summary>
        /// 获取阿里云Sms配置
        /// </summary>
        public static JObject AliSms
        {
            get
            {
                string aliOss = ReadConfigKey("AliSms");
                return JObject.Parse(aliOss.ToString());
            }
        }
        /// <summary>
        /// 获取JPush配置
        /// </summary>
        public static JObject JPush
        {
            get
            {
                string jpush = ReadConfigKey("Jpush");
                return JObject.Parse(jpush.ToString());
            }
        }
        /// <summary>
        /// 读取配置文件key的值 ConfigKey.config
        /// </summary>
        /// <param name="key"></param>
        /// <returns></returns>
        private static string ReadConfigKey(string key)
        {
            try
            {
                string path = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "ConfigValue.json");

                //读取json文件  
                using (StreamReader sr = new StreamReader(path))
                {
                    try
                    {
                        JsonSerializer serializer = new JsonSerializer();
                        serializer.Converters.Add(new JavaScriptDateTimeConverter());
                        serializer.NullValueHandling = NullValueHandling.Ignore;

                        //构建Json.net的读取流  
                        JsonReader reader = new JsonTextReader(sr);
                        JObject jObject = JObject.Load(reader);
                        return jObject[key].ToString();
                    }
                    catch
                    {
                        //ex.Message.ToString();
                        return "";
                    }
                }

            }
            catch
            {
                return "";
            }
        }

        /// <summary>
        /// web推送消息rabbit配置
        /// </summary>
        public static string WebPushRabbitConfig
        {
            get
            {
                return ReadConfigKey("WebPushRabbitConfig");
            }
        }

        /// <summary>
        /// 获取文件相对路径
        /// </summary>
        public static string GetFilePath(string path)
        {
            string p = @"(http|https)://(?<domain>[^(:|/]*)";
            Regex reg = new Regex(p, RegexOptions.IgnoreCase);
            string value = reg.Match(path).Value;
            if (!string.IsNullOrWhiteSpace(value))
            {
                return path.Replace(value, "");
            }
            else
            {
                return path;
            }

        }
    }
}
