﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Model.Entity.Education;
using Mall.Model.Extend.Education;

namespace Mall.Repository.Education
{
    public class Rb_Education_DynamicCommentRepository : BaseRepository<Rb_Education_DynamicComment>
    {
        /// <summary>
        /// 获取动态评论
        /// </summary>
        /// <param name="articleId">动态文章id</param>
        /// <returns></returns>
        public List<Rb_Education_DynamicComment_Extend> GetDynamicCommentList(Rb_Education_DynamicComment_Extend model)
        {
            string where = " where c.`Status`=0 ";
            if (model != null)
            {
                if (model.TenantId > 0)
                {
                    where += $@" and c.TenantId = {model.TenantId} ";
                }
                if (model.MallBaseId > 0)
                {
                    where += $@" and c.MallBaseId = {model.MallBaseId} ";
                }
                if (model.UserId > 0)
                {
                    where += $@" and c.UserId = {model.UserId} ";
                }
                if (model.ArticleId > 0)
                {
                    where += $@" and c.ArticleId = {model.ArticleId} ";
                }
                if (!string.IsNullOrWhiteSpace(model.ArticleIds))
                {
                    where += $@" and c.ArticleId in({model.ArticleIds} ) ";
                }
            }
            string sql = $@"SELECT c.*,e.`Name` as UserName from Rb_Education_DynamicComment c 
                            LEFT JOIN rb_member_user e on c.UserId = e.Id
                            {where}  order by c.CreateTime desc";
            return Get<Rb_Education_DynamicComment_Extend>(sql).ToList();
        }

        /// <summary>
        /// 删除动态评论
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public int DynamicDeleteComment(Rb_Education_DynamicComment_Extend model)
        {
            string sql = $@"UPDATE  Rb_Education_DynamicComment set `Status` =1 where Id ={model.Id} and TenantId = {model.TenantId} and MallBaseId = {model.MallBaseId} and (UserId = {model.UserId} or ArticleId in (
                            SELECT a.Id from Rb_Education_Dynamic a where a.CreateBy = {model.UserId} and a.`Status` =0
                            ))";
            return Execute(sql);
        }
    }
}
