﻿using VT.FW.DB;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Mall.Model.Entity.Finance
{
    /// <summary>
    /// 费用类型表
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "FinanceConnection")]
    public class RB_Costtype
    {
        /// <summary>
        /// ID
        /// </summary>        
        public int ID
        {
            get;
            set;
        }
        /// <summary>
        /// 父级节点
        /// </summary>
        public int? ParentId { get; set; }
        /// <summary>
        /// 层级
        /// </summary>
        public int? Tier { get; set; }
        /// <summary>
        /// 根节点ID
        /// </summary>
        public int? RootId { get; set; }
        /// <summary>
        /// 排序
        /// </summary>
        public int? Sort { get; set; }
        /// <summary>
        /// 是否摊账0-否1-是
        /// </summary>
        public int? IsShareAccount { get; set; }
        /// <summary>
        /// 费用类型
        /// </summary>        
        public string Name
        {
            get;
            set;
        }
        /// <summary>
        /// 1-收入2-支出3-收支
        /// </summary>
        public Common.Enum.Finance.WFTempLateClassEnum? Type
        {
            get; set;
        }
        /// <summary>
        /// 集团ID
        /// </summary>        
        public int? RB_Group_Id
        {
            get;
            set;
        }
        /// <summary>
        /// 操作人
        /// </summary>        
        public int? UpdateBy
        {
            get;
            set;
        }
        /// <summary>
        /// 操作时间
        /// </summary>        
        public DateTime? UpdateDate
        {
            get;
            set;
        }
        /// <summary>
        /// 删除标识
        /// </summary>        
        public Common.Enum.DateStateEnum Status
        {
            get;
            set;
        }
        /// <summary>
        /// 是否进入营收报表
        /// </summary>
        public int? Is_Report { get; set; }
        /// <summary>
        /// 是否是机密费用  1是 0否
        /// </summary>
        public int? IsSecret { get; set; }
    }
}
