﻿using Mall.Common.Plugin;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Mall.Common.Enum.Finance
{
    #region OA
    /// <summary>
    /// 工作申请流审核状态
    /// </summary>
    public enum WFAuditStatus
    {
        /// <summary>
        /// 审核中
        /// </summary>
        [EnumField("审核中")]
        InReview = 1,
        /// <summary>
        /// 撤回 
        /// </summary>
        [EnumField("撤回")]
        ToWithdraw = 2,
        /// <summary>
        /// 驳回 
        /// </summary>
        [EnumField("驳回")]
        Rejected = 3,
        /// <summary>
        /// 不通过
        /// </summary>
        [EnumField("不通过")]
        NotThrough = 4,
        /// <summary>
        /// 通过
        /// </summary>
        [EnumField("通过")]
        Through = 5
    }
    /// <summary>
    /// 流程审核状态
    /// </summary>
    public enum WFRrocessStatus
    {
        /// <summary>
        /// 未审核
        /// </summary>
        [EnumField("未审核")]
        NotAudit = 1,
        /// <summary>
        /// 通过
        /// </summary>
        [EnumField("审核通过")]
        AuditThrough = 2,
        /// <summary>
        /// 不通过
        /// </summary>
        [EnumField("审核不通过")]
        AuditNotThrough = 3,
        /// <summary>
        /// 驳回 
        /// </summary>
        [EnumField("驳回")]
        Rejected = 4,
        /// <summary>
        /// 他人已审核（仅限审核记录表） 
        /// </summary>
        [EnumField("他人已审核")]
        OtherHaveAudit = 5

    }

    /// <summary>
    /// app筛选审核状态枚举
    /// </summary>
    public enum AppAuditStatusEnum
    {
        /// <summary>
        /// 全部
        /// </summary>
        [EnumField("全部")]
        All = 0,
        /// <summary>
        /// 审批完成 
        /// </summary>
        [EnumField("审批完成")]
        AuditComplete = 1,
        /// <summary>
        /// 审批中 
        /// </summary>
        [EnumField("审批中")]
        InComplete = 2,
        /// <summary>
        /// 已撤销
        /// </summary>
        [EnumField("已撤销")]
        ToWithdraw = 3
    }
    /// <summary>
    /// 申请单撤回状态
    /// </summary>
    public enum WFAuditCancelStatus
    {
        /// <summary>
        /// 正常
        /// </summary>
        [EnumField("正常")]
        Normal = 1,
        /// <summary>
        /// 撤回
        /// </summary>
        [EnumField("撤回")]
        Cancel = 2
    }
    #endregion
    #region 财务
    /// <summary>
    /// 财务审核状态
    /// </summary>
    public enum FinanceAuditStatus
    {
        /// <summary>
        /// 暂存
        /// </summary>
        [EnumField("制单人暂存")]
        Temporary = 0,
        /// <summary>
        /// 审核中
        /// </summary>
        [EnumField("审核中")]
        InReview = 1,
        /// <summary>
        /// 通过 
        /// </summary>
        [EnumField("通过")]
        Pass = 2,
        /// <summary>
        /// 驳回 
        /// </summary>
        [EnumField("驳回")]
        Rejected = 3,
        /// <summary>
        /// 作废
        /// </summary>
        [EnumField("作废")]
        Delete = 4,
        /// <summary>
        /// 出纳暂存
        /// </summary>
        [EnumField("出纳暂存")]
        CTemporary = 5
    }
    #endregion
}
