﻿using Mall.Common.Plugin;

namespace Mall.Common.Enum.Property
{
    /// <summary>
    /// 资产审批枚举
    /// </summary>
    public enum PropertyFlowEnum
    {
        /// <summary>
        /// 领用
        /// </summary>
        [EnumField("领用")]
        Receive = 1,
        /// <summary>
        /// 退库
        /// </summary>
        [EnumField("退库")]
        CancellingStocks = 2,
        /// <summary>
        /// 借用
        /// </summary>
        [EnumField("借用")]
        Borrow = 3,
        /// <summary>
        /// 归还
        /// </summary>
        [EnumField("归还")]
        GiveBack = 4,
        /// <summary>
        /// 调拨
        /// </summary>
        [EnumField("调拨")]
        Allot = 5,
        /// <summary>
        /// 处置
        /// </summary>
        [EnumField("处置")]
        Dispose = 6,
        /// <summary>
        /// 维修
        /// </summary>
        [EnumField("维修")]
        Maintain = 7,
        /// <summary>
        /// 员工领用资产
        /// </summary>
        [EnumField("员工领用资产")]
        EmpReceive = 8,
        /// <summary>
        /// 员工退库资产
        /// </summary>
        [EnumField("员工退库资产")]
        EmpCancellingStocks = 9,
        /// <summary>
        /// 变更领用人
        /// </summary>
        [EnumField("变更领用人")]
        Change = 10,
        /// <summary>
        /// 入库
        /// </summary>
        [EnumField("入库")]
        StockIn = 11
    }
}
