﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Common.Plugin;

namespace Mall.Common.Enum.TradePavilion
{
    /// <summary>
    /// 品牌下载枚举列表
    /// </summary>
    public enum SZTBusinessExportEnum
    {

        /// <summary>
        /// 品牌全名
        /// </summary>
        [EnumField("品牌全名")]
        FullBrandName = 1,
        /// <summary>
        /// 品牌名
        /// </summary>
        [EnumField("品牌名")]
        BrandName = 2,

        /// <summary>
        /// 品牌视频
        /// </summary>
        [EnumField("品牌视频")]
        VideoUrl = 3,
        /// <summary>
        /// Logo
        /// </summary>
        [EnumField("Logo")]
        Logo = 4,


        /// <summary>
        /// 品牌分类
        /// </summary>
        [EnumField("品牌分类")]
        CategoryId = 5,
        /// <summary>
        /// 品牌简介
        /// </summary>
        [EnumField("品牌简介")]
        Introduce = 6,


        /// <summary>
        /// 店铺数量
        /// </summary>
        [EnumField("店铺数量")]
        ShopNum = 7,
        /// <summary>
        /// 建筑面积
        /// </summary>
        [EnumField("建筑面积")]
        BuiltUpArea = 8,
        /// <summary>
        /// 需求面积
        /// </summary>
        [EnumField("需求面积")]
        AreaRequirement = 9,
        /// <summary>
        /// 客群定位
        /// </summary>
        [EnumField("客群定位")]
        CustomerType = 10,
        /// <summary>
        /// 品牌定位
        /// </summary>
        [EnumField("品牌定位")]
        BrandType = 11,
        /// <summary>
        /// 合作条件
        /// </summary>
        [EnumField("合作条件")]
        Cooperation = 12,
        /// <summary>
        /// 物业需求
        /// </summary>
        [EnumField("物业需求")]
        PropertyDemand = 13,
        /// <summary>
        /// 配套需求
        /// </summary>
        [EnumField("配套需求")]
        Complementary = 14,
        /// <summary>
        /// 联系人
        /// </summary>
        [EnumField("联系人")]
        ContactName = 15,
        /// <summary>
        /// 联系电话
        /// </summary>
        [EnumField("联系电话")]
        ContactPhone = 16,

    }


    /// <summary>
    /// 【商载通】企业服务下载枚举列表
    /// </summary>
    public enum SZTBrandServicesExportEnum
    {
        /// <summary>
        /// 企业名称
        /// </summary>
        [EnumField("企业名称")]
        Name = 1,
        /// <summary>
        /// LOGO
        /// </summary>
        [EnumField("LOGO")]
        Banner = 2,
        /// <summary>
        /// 企业简介
        /// </summary>
        [EnumField("企业简介")]
        Introduction = 3,
        /// <summary>
        /// 企业类别
        /// </summary>
        [EnumField("企业类别")]
        EType = 4,

        /// <summary>
        /// 意向楼宇等级
        /// </summary>
        [EnumField("意向楼宇等级")]
        CategoryId = 5,
        /// <summary>
        /// 意向楼宇位置
        /// </summary>
        [EnumField("意向楼宇位置")]
        Address = 6,
        /// <summary>
        /// 经纬度
        /// </summary>
        [EnumField("经纬度")]
        LatAndLon = 7,
        /// <summary>
        /// 投运时间
        /// </summary>
        [EnumField("投运时间")]
        OperationTime = 8,
        /// <summary>
        /// 企业发展意向
        /// </summary>
        [EnumField("企业发展意向")]
        DevIntention = 9,
        /// <summary>
        /// 楼宇装修
        /// </summary>
        [EnumField("楼宇装修")]
        Renovation = 10,

        /// <summary>
        /// 支付方式
        /// </summary>
        [EnumField("支付方式")]
        Payment = 11,

        /// <summary>
        /// 交房日期
        /// </summary>
        [EnumField("交房日期")]
        HandoverDate = 12,

        /// <summary>
        /// 意向楼层
        /// </summary>
        [EnumField("意向楼层")]
        IntentionalFloor = 13,

        /// <summary>
        /// 电梯数
        /// </summary>
        [EnumField("电梯数")]
        ElevatorNum = 14,

        /// <summary>
        /// 物业费
        /// </summary>
        [EnumField("物业费")]
        PropertyFee = 15,

        /// <summary>
        /// 月租金
        /// </summary>
        [EnumField("月租金")]
        RentFee = 16,
       
        /// <summary>
        /// 联系人名字
        /// </summary>
        [EnumField("联系人名字")]
        ContactName = 17,
        /// <summary>
        /// 联系人电话
        /// </summary>
        [EnumField("联系人电话")]
        ContactPhone = 18
    }
}
