﻿using System;
using System.Collections.Generic;
using System.Text;
using VT.FW.DB;

namespace Mall.Model.Entity.Education
{
	/// <summary>
	/// 课程分类实体类
	/// </summary>
	[Serializable]
	[DB(ConnectionName = "ThinkConnection")]
	public class RB_Course_Category
	{
		/// <summary>
		/// 主键（课程分类编号）
		/// </summary>
		public int CateId { get; set; }

		/// <summary>
		/// 父级编号
		/// </summary>
		public int ParentId { get; set; }

		/// <summary>
		/// 课程分类名称
		/// </summary>
		public string CateName { get; set; }

		/// <summary>
		/// 排序
		/// </summary>
		public int SortNum { get; set; }

		/// <summary>
		/// 删除状态
		/// </summary>
		public int Status { get; set; }

		/// <summary>
		/// 创建人
		/// </summary>
		public int CreateBy { get; set; }

		/// <summary>
		/// 创建时间
		/// </summary>
		public DateTime CreateTime { get; set; }

		/// <summary>
		/// 修改人
		/// </summary>
		public int UpdateBy { get; set; }

		/// <summary>
		/// 更新时间
		/// </summary>
		public DateTime UpdateTime { get; set; }

		/// <summary>
		/// 集团编号
		/// </summary>
		public int Group_Id { get; set; }

		/// <summary>
		/// 学校Id
		/// </summary>
		public int School_Id { get; set; }

		/// <summary>
		/// 所属科目
		/// </summary>
		public int CourseSubject { get; set; }

		/// <summary>
		/// 源数据课程分类编号
		/// </summary>
		public string GUIDStr { get; set; }

		/// <summary>
		/// 商城表RB_Product_Category的Id
		/// </summary>
		public int Mall_Product_Category_Id { get; set; }
	}
}
