﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Common.Enum.Education;
using VT.FW.DB;

namespace Mall.Model.Entity.Education
{
    /// <summary>
    /// 财务流程费用配置实体类
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "EduConnection")]
    public class RB_Finance_Config
    {
        /// <summary>
        /// 主键
        /// </summary>
        public int Id { get; set; }

        /// <summary>
        /// 类型   1教师课时费   2教师绩效   3学生退课   枚举
        /// </summary>
        public FinanceConfigTypeEnum Type { get; set; }

        /// <summary>
        /// 费用id
        /// </summary>
        public int CostTypeId { get; set; }

        /// <summary>
        /// 流程Id
        /// </summary>
        public int TempleteId { get; set; }

        /// <summary>
        /// 删除状态
        /// </summary>
        public int Status { get; set; }

        /// <summary>
		/// 集团编号
		/// </summary>
		public int Group_Id { get; set; }

        /// <summary>
        /// 校区id
        /// </summary>
        public int School_Id { get; set; }

        /// <summary>
        /// 创建人
        /// </summary>
        public int CreateBy { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime CreateTime { get; set; }

        /// <summary>
        /// 修改人
        /// </summary>
        public int UpdateBy { get; set; }

        /// <summary>
        /// 更新时间
        /// </summary>
        public DateTime UpdateTime { get; set; }

        /// <summary>
        /// 币种id
        /// </summary>
        public int CurrencyId { get; set; }

        /// <summary>
        /// ClientID=74 的时候是学费收款账户id
        /// </summary>
        public int ClientID { get; set; }
    }
}
