﻿using System;
using System.Collections.Generic;
using System.Text;
using VT.FW.DB;

namespace Mall.Model.Entity.Finance
{
    /// <summary>
	/// Rb_Workflow_AuditRelevance:实体类(属性说明自动提取数据库字段的描述信息)
	/// </summary>
	[Serializable]
    [DB(ConnectionName = "FinanceConnection")]
    public class Rb_Workflow_AuditRelevance
    {

        /// <summary>
        /// Id
        /// </summary>        
        public int Id
        {
            get;
            set;
        }
        /// <summary>
        /// 审批条件id
        /// </summary>        
        public int? ConditionId
        {
            get;
            set;
        }
        /// <summary>
        /// 审核人类型  1主管(指定一级) 2 指定成员  3角色
        /// </summary>        
        public int? AuditType
        {
            get;
            set;
        }
        /// <summary>
        /// 1依次审批（本环节内审批人依次审批） 2 会签（须所有审批人同意）3或签（一名审批人同意或拒绝即可）
        /// </summary>        
        public int? AuditWay
        {
            get;
            set;
        }
        /// <summary>
        /// 存发起人或者岗位部门关联表id   发起人1 表示直属主管   2表示再上一级   依次类推
        /// </summary>        
        public int? RoleOrInitiator
        {
            get;
            set;
        }
        /// <summary>
        /// 步骤（排序）
        /// </summary>        
        public int? Sort
        {
            get;
            set;
        }
        /// <summary>
        /// AuditDescription
        /// </summary>        
        public string AuditDescription
        {
            get;
            set;
        }
        /// <summary>
        /// 是否特殊节点0-常规1-出纳收款2-出纳付款
        /// </summary>
        public int? SpecialNode
        {
            get; set;
        }
        /// <summary>
        /// 工作流id
        /// </summary>        
        public int? WorkFlowId
        {
            get;
            set;
        }
        /// <summary>
        /// 1请假  2出差  3  外出  4  补卡
        /// </summary>        
        public int? TemplateType
        {
            get;
            set;
        }
        /// <summary>
        /// 原审核id
        /// </summary>        
        public int? OriginalAuditId
        {
            get;
            set;
        }
        /// <summary>
        /// 1未审核  2审核通过  3 不通过  4 驳回
        /// </summary>        
        public int? Stauts
        {
            get;
            set;
        }
        /// <summary>
        /// 待审核人  1,2,3 以逗号分隔
        /// </summary>
        public string ToAuditId { get; set; }
        /// <summary>
        /// 已审核人   1,2,3  以逗号分割
        /// </summary>
        public string AuditedId { get; set; }
    }
}
