﻿using System;
using System.Collections.Generic;
using System.Text;
using VT.FW.DB;

namespace Mall.Model.Entity.MarketingCenter
{
    /// <summary>
    /// 活动参与人员配置表
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_ActivitySurvey_Guest
    {
		/// <summary>
		/// 主键编号
		/// </summary>
		public int Id { get; set; }

		/// <summary>
		/// 客户类型(1-小程序用户,2-学员用户)
		/// </summary>
		public int GuestType { get; set; }

		/// <summary>
		/// 对应客户类型Id
		/// </summary>
		public int GuestId { get; set; }

		/// <summary>
		/// 是否完成
		/// </summary>
		public int IsFinish { get; set; }

		/// <summary>
		/// 开始时间
		/// </summary>
		public DateTime StartTime { get; set; }

		/// <summary>
		/// 结束时间
		/// </summary>
		public DateTime EndTime { get; set; }

		/// <summary>
		/// 删除状态
		/// </summary>
		public int Status { get; set; }

		/// <summary>
		/// 集团
		/// </summary>
		public int MallBaseId { get; set; }

		/// <summary>
		/// 公司
		/// </summary>
		public int TenantId { get; set; }

		/// <summary>
		/// 创建人
		/// </summary>
		public int CreateBy { get; set; }

		/// <summary>
		/// 创建时间
		/// </summary>
		public DateTime CreateDate { get; set; }

		/// <summary>
		/// 活动编号
		/// </summary>
        public int SurveyId { get; set; }
    }
}
