﻿using System;
using VT.FW.DB;

namespace Mall.Model.Entity.Product
{
    /// <summary>
    /// 商品关联规格表实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Goods_Specification
    {

        /// <summary>
        /// Id
        /// </summary>        
        public int Id
        {
            get;
            set;
        }
        /// <summary>
        /// 商品id
        /// </summary>        
        public int? GoodsId
        {
            get;
            set;
        }
        /// <summary>
        /// 规格名称
        /// </summary>        
        public string Name
        {
            get;
            set;
        }
        /// <summary>
        /// 排序
        /// </summary>        
        public int? Sort
        {
            get;
            set;
        }
        /// <summary>
        /// 是否启用规格图片  1是  2否
        /// </summary>        
        public int? EnabledImage
        {
            get;
            set;
        }

        /// <summary>
        /// 默认0，1-是，是日期格式，方便后面转换成日期
        /// </summary>
        public int IsDateFormat { get; set; }


        /// <summary>
        /// Status
        /// </summary>        
        public int? Status
        {
            get;
            set;
        }
        /// <summary>
        /// 商户号
        /// </summary>        
        public int TenantId
        {
            get;
            set;
        }
        /// <summary>
        /// 小程序id
        /// </summary>        
        public int MallBaseId
        {
            get;
            set;
        }
        /// <summary>
        /// CreateDate
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }
    }
}
