﻿using Mall.Common.Enum;
using Mall.Common.Enum.TradePavilion;
using System;
using VT.FW.DB;

namespace Mall.Model.Entity.TradePavilion
{
    /// <summary>
    /// 【商载通】楼宇、载体 实体类
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Building_Carrier
    {
        /// <summary>
        /// 编号
        /// </summary>
        public int ID { get; set; }

        /// <summary>
        /// 商户号id
        /// </summary>
        public int TenantId { get; set; }

        /// <summary>
        /// 小程序id
        /// </summary>
        public int MallBaseId { get; set; }
        /// <summary>
        /// 创建人
        /// </summary>
        public int CreateBy { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime CreateDate { get; set; }

        /// <summary>
        /// 修改人
        /// </summary>
        public int UpdateBy { get; set; }

        /// <summary>
        /// 修改时间
        /// </summary>
        public DateTime UpdateDate { get; set; }

        /// <summary>
        /// 删除状态
        /// </summary>
        public DateStateEnum Status { get; set; }


        /// <summary>
        /// 载体名称
        /// </summary>
        public string CarrierName { get; set; }


        /// <summary>
        /// logo
        /// </summary>
        public string Logo { get; set; }


        /// <summary>
        /// 载体介绍图
        /// </summary>
        public string Banner { get; set; }

        /// <summary>
        /// 载体视频
        /// </summary>
        public string VideoUrl { get; set; }

        /// <summary>
        /// 省
        /// </summary>
        public int Province { get; set; }

        /// <summary>
        /// 市
        /// </summary>
        public int City { get; set; }


        /// <summary>
        /// 区
        /// </summary>
        public int Area { get; set; }

        /// <summary>
        /// 载体地址
        /// </summary>
        public string Address { get; set; }

        /// <summary>
        /// 载体地址经纬度
        /// </summary>
        public string LatAndLon { get; set; }

        /// <summary>
        /// 开发商
        /// </summary>
        public string Developers { get; set; }

        /// <summary>
        /// 开业时间
        /// </summary>
        public DateTime OpenTime { get; set; }

        /// <summary>
        /// 项目类型
        /// </summary>
        public int? ProjectType { get; set; }

        /// <summary>
        /// 商业体量（单位：万平方米）
        /// </summary>
        public decimal CarrierSize { get; set; }

        /// <summary>
        /// 商业层数
        /// </summary>
        public string LayersNum { get; set; }

        /// <summary>
        /// 车位数量
        /// </summary>
        public int CarNum { get; set; }


        /// <summary>
        /// 业态规划
        /// </summary>
        public string CarrierPlan { get; set; }

        /// <summary>
        /// 招引目标
        /// </summary>
        public string CarrierTarget { get; set; }

        /// <summary>
        /// 目标人群[周边人群结构特征]
        /// </summary>
        public string Crowd { get; set; }

        /// <summary>
        /// 归属于用户
        /// </summary>
        public int UserId { get; set; }


        /// <summary>
        /// 开业状态0-即将开业，1-已开业
        /// </summary>
        public int OpeningStatus { get; set; }

        /// <summary>
        /// 首店试验场 0-否，1-是
        /// </summary>
        public int? FirstStoreTest { get; set; }


        /// <summary>
        /// 招商优惠政策
        /// </summary>
        public string Discount { get; set; }

        /// <summary>
        /// 载体荣誉
        /// </summary>
        public string Honor { get; set; }

        /// <summary>
        /// 去年业绩（单位：W）
        /// </summary>
        public decimal? YeJi { get; set; }

        /// <summary>
        /// 店铺数量
        /// </summary>
        public int? ShopNum { get; set; }

        /// <summary>
        /// 可租赁面积
        /// </summary>
        public decimal AreaRequirement { get; set; }

        /// <summary>
        /// 可租赁面积
        /// </summary>
        public decimal? EndAreaRequirement { get; set; }


        /// <summary>
        /// 经营面积
        /// </summary>
        public decimal BuiltUpArea { get; set; }

        /// <summary>
        /// 经营面积
        /// </summary>
        public decimal? EndBuiltUpArea { get; set; }


        /// <summary>
        /// 首店数量
        /// </summary>
        public string FirstShopNum { get; set; }

        /// <summary>
        /// 首发政策
        /// </summary>
        public string StartingInfo { get; set; }


        /// <summary>
        /// 项目类型
        /// </summary>
        public int CategoryId { get; set; }

        /// <summary>
        /// 类型(1-载体,2-楼宇)
        /// </summary>
        public int? BuildingCarrierType { get; set; }

        /// <summary>
        /// 是否为成都载体(1-是)
        /// </summary>
        public int? IsChengDu { get; set; }

        /// <summary>
        /// 资产权属
        /// </summary>
        public string Ascription { get; set;}

        /// <summary>
        /// 物业构成
        /// </summary>
        public string PropertyComposition { get; set; }

 
        /// <summary>
        /// 项目发展及定位
        /// </summary>
        public string Location { get; set; }

        /// <summary>
        /// 人流量参数
        /// </summary>
        public string VisitorsFlowrate { get; set;}

        /// <summary>
        /// 水电气及配套
        /// </summary>
        public string SupportingFacilities { get; set; }

        /// <summary>
        /// 管理公司及管理费
        /// </summary>
        public string ManagementCompany { get; set; }

        /// <summary>
        /// 目标招商业态及品牌需求
        /// </summary>
        public string BrandDemand { get; set; }

        /// <summary>
        /// 联系人
        /// </summary>
        public string ContactName { get; set; }

        /// <summary>
        /// 联系电话
        /// </summary>
        public string ContactPhone { get; set; }
    }
}
