﻿using Mall.Model.Entity.MarketingCenter;
using Mall.Model.Extend.MarketingCenter;
using Mall.Model.Extend.User;
using Mall.Model.Query;
using Mall.Repository.MarketingCenter;
using Mall.Repository.User;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Module.MarketingCenter
{
    public class IntegralModule
    {
        private readonly RB_Integral_SettingsRepository settingsRepository = new RB_Integral_SettingsRepository();

        private readonly RB_Member_IntegralRepository recordRepository = new RB_Member_IntegralRepository();

        #region 积分设置

        /// <summary>
        /// 积分设置列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Integral_Settings> GetIntegralSettingsList(RB_Integral_Settings query)
        {
            return settingsRepository.GetIntegralSettingsList(query);
        }


        /// <summary>
        /// 新增修改积分
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool AddOrUpdateIntegralSettings(RB_Integral_Settings model)
        {
            if (model.ID == 0)
            {
                return settingsRepository.Insert(model) > 0;
            }
            else
            {
                return settingsRepository.Update(model);
            }
        }
        #endregion

        #region 积分记录

        /// <summary>
        /// 积分记录列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Member_Integral_Extend> GetRechargeRecordPageList(int pageIndex, int pageSize, out long rowCount, RB_Member_Integral_Extend query)
        {
            return recordRepository.GetRechargeRecordPageList(pageIndex, pageSize, out rowCount, query);
        }



        /// <summary>
        /// 营销中心-积分记录导出
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Member_Integral_Extend> GetIntegralRecordExport(RB_Member_Integral_Extend query)
        {
            return recordRepository.GetIntegralExport(query);
        }


        /// <summary>
        /// 数据统计-积分收支
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<Integral_Query> GetIntegraStatisticslList(int pageIndex, int pageSize, out long rowCount, Integral_Query query)
        {
            return recordRepository.GetIntegraStatisticslList(pageIndex, pageSize, out rowCount, query);
        }


        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Member_Integral_Extend> GetTotalIntegral(RB_Member_Integral_Extend dmodel)
        {
            return recordRepository.GetList(dmodel);

        }


        /// <summary>
        /// 数据统计-积分收支
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<Integral_Query> GetExportIntegraStatisticslList(Integral_Query query)
        {
            return recordRepository.GetExportIntegraStatisticslList(query);
        }
        #endregion
    }
}
