﻿using Mall.Model.Entity.AppletWeChat;
using Mall.Model.Extend.AppletWeChat;
using System;
using System.Collections.Generic;
using System.Text;
using System.Linq;

namespace Mall.Repository.AppletWeChat
{
    /// <summary>
    /// 直播海报配置仓储层
    /// </summary>
    public class RB_Live_ConfigRepository : BaseRepository<RB_Live_Config>
    {
        /// <summary>
        /// 获取直播配置实体
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public RB_Live_Config_Extend GetLiveConfigRepository(RB_Live_Config_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@" SELECT * FROM RB_Live_Config WHERE 1=1 ");
            if (query != null)
            {
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(@" AND {0}={1} ", nameof(RB_Live_Config_Extend.MallBaseId), query.MallBaseId);
                }
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(@" AND {0}={1} ", nameof(RB_Live_Config_Extend.TenantId), query.TenantId);
                }
                if (query.Id > 0)
                {
                    builder.AppendFormat(@" AND {0}={1} ", nameof(RB_Live_Config_Extend.Id), query.Id);
                }
            }
            return Get<RB_Live_Config_Extend>(builder.ToString()).FirstOrDefault();
        }
    }
}
