﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Model.Entity.Education;
using Mall.Model.Extend.Education;

namespace Mall.Repository.Education
{
    public class RB_Education_ActivitySummaryGroupRepository : BaseRepository<RB_Education_ActivitySummaryGroup>
    {
        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Education_ActivitySummaryGroup_Extend> GetPageList(int pageIndex, int pageSize, out long rowCount, RB_Education_ActivitySummaryGroup_Extend dmodel)
        {
            string where = $" 1=1 and {nameof(RB_Education_ActivitySummaryGroup.Status)}=0";
            if (dmodel.TenantId > 0)
            {
                where += $@" and {nameof(RB_Education_ActivitySummaryGroup.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_Education_ActivitySummaryGroup.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Id > 0)
            {
                where += $@" and {nameof(RB_Education_ActivitySummaryGroup.Id)}={dmodel.Id}";
            }
            if (dmodel.ActivityId > 0)
            {
                where += $@" and {nameof(RB_Education_ActivitySummaryGroup.ActivityId)}={dmodel.ActivityId}";
            }
            if (!string.IsNullOrEmpty(dmodel.Name))
            {
                where += $@" and {nameof(RB_Education_ActivitySummaryGroup.Name)} like '%{dmodel.Name}%'";
            }
            if (dmodel.Type > 0)
            {
                where += $@" and {nameof(RB_Education_ActivitySummaryGroup.Type)}={dmodel.Type}";
            }
            
            string sql = $@"select * from RB_Education_ActivitySummaryGroup where {where} order by Id desc";
            return GetPage<RB_Education_ActivitySummaryGroup_Extend>(pageIndex, pageSize, out rowCount, sql).ToList();
        }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Education_ActivitySummaryGroup_Extend> GetList(RB_Education_ActivitySummaryGroup_Extend dmodel)
        {
            string where = $" 1=1 and {nameof(RB_Education_ActivitySummaryGroup.Status)}=0";
            if (dmodel.TenantId > 0)
            {
                where += $@" and {nameof(RB_Education_ActivitySummaryGroup.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_Education_ActivitySummaryGroup.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.ActivityId > 0)
            {
                where += $@" and {nameof(RB_Education_ActivitySummaryGroup.ActivityId)}={dmodel.ActivityId}";
            }
            if (dmodel.Id > 0)
            {
                where += $@" and {nameof(RB_Education_ActivitySummaryGroup.Id)}={dmodel.Id}";
            }
            if (!string.IsNullOrEmpty(dmodel.GroupIds))
            {
                where += $@" and {nameof(RB_Education_ActivitySummaryGroup.Id)} in({dmodel.GroupIds})";
            }
            if (!string.IsNullOrEmpty(dmodel.Name))
            {
                where += $@" and {nameof(RB_Education_ActivitySummaryGroup.Name)} like '%{dmodel.Name}%'";
            }
            if (dmodel.Type > 0)
            {
                where += $@" and {nameof(RB_Education_ActivitySummaryGroup.Type)}={dmodel.Type}";
            }
          
            string sql = $@"select * from RB_Education_ActivitySummaryGroup where {where} order by Sort,Id desc";
            return Get<RB_Education_ActivitySummaryGroup_Extend>(sql).ToList();
        }
    }
}
