﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Model.Entity.Miai;

namespace Mall.Repository.Miai
{
    /// <summary>
    /// 详情会员每日随机查询仓储层
    /// </summary>
    public class RB_MiAi_BaseInfoDayQueryRepository : BaseRepository<RB_MiAi_BaseInfoDayQuery>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_MiAi_BaseInfoDayQuery); } }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<RB_MiAi_BaseInfoDayQuery> GetBaseInfoDayQueryList(RB_MiAi_BaseInfoDayQuery where)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append($@" SELECT * from RB_MiAi_BaseInfoDayQuery  where Status=0");
            if (where != null)
            {
                if (where.TenantId > 0)
                {
                    sb.AppendFormat(" and TenantId={0}", where.TenantId);
                }
                if (where.MallBaseId > 0)
                {
                    sb.AppendFormat(" and MallBaseId={0}", where.MallBaseId);
                }
                if (where.Id > 0)
                {
                    sb.AppendFormat(" and Id={0}", where.Id);
                }
                if (where.UserId > 0)
                {
                    sb.AppendFormat(" and UserId={0}", where.UserId);
                }
                if (where.Sex > 0)
                {
                    sb.AppendFormat(" and Sex={0}", where.Sex);
                }
                if (where.CreateDate.HasValue)
                {
                    sb.AppendFormat(" and DATE_FORMAT(CreateDate,'%Y-%m-%d' ) = DATE_FORMAT('{0}','%Y-%m-%d' )", where.CreateDate.Value);
                }
            }
            return Get<RB_MiAi_BaseInfoDayQuery>(sb.ToString()).ToList();
        }

    }
}
