﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Product;
using Mall.Model.Extend.Product;
using System.Linq;

namespace Mall.Repository.Product
{
    /// <summary>
    /// 网课学习时间仓储层
    /// </summary>
    public class RB_Goods_WK_StudyTimeRepository : BaseRepository<RB_Goods_WK_StudyTime>
    {

        /// <summary>
        /// 列表
        /// </summary>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Goods_WK_StudyTime_Extend> GetList(RB_Goods_WK_StudyTime_Extend dmodel)
        {
            string where = $" 1=1";
            if (dmodel.Id > 0) {
                where += $@" and gc.{nameof(RB_Goods_WK_StudyTime.Id)}={dmodel.Id}";
            }
            if (dmodel.UserId > 0) {
                where += $@" and gc.{nameof(RB_Goods_WK_StudyTime.UserId)}={dmodel.UserId}";
            }
            if (dmodel.GoodsId > 0) {
                where += $@" and gc.{nameof(RB_Goods_WK_StudyTime.GoodsId)}={dmodel.GoodsId}";
            }
            if (!string.IsNullOrEmpty(dmodel.GoodsIds)) {
                where += $@" and gc.{nameof(RB_Goods_WK_StudyTime.GoodsId)} in({dmodel.GoodsIds})";
            }
            
            string sql = $@"
SELECT gc.* FROM RB_Goods_WK_StudyTime gc 
WHERE {where} ORDER BY gc.Id desc ";
            return Get<RB_Goods_WK_StudyTime_Extend>(sql).ToList();
        }

        /// <summary>
        /// 获取分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Goods_WK_StudyTime_Extend> GetPageList(int pageIndex, int pageSize, out long count, RB_Goods_WK_StudyTime_Extend dmodel)
        {
            string where = $" 1=1";
            if (dmodel.Id > 0)
            {
                where += $@" and gc.{nameof(RB_Goods_WK_StudyTime.Id)}={dmodel.Id}";
            }
            if (dmodel.UserId > 0)
            {
                where += $@" and gc.{nameof(RB_Goods_WK_StudyTime.UserId)}={dmodel.UserId}";
            }
            if (dmodel.GoodsId > 0)
            {
                where += $@" and gc.{nameof(RB_Goods_WK_StudyTime.GoodsId)}={dmodel.GoodsId}";
            }
            if (!string.IsNullOrEmpty(dmodel.GoodsIds))
            {
                where += $@" and gc.{nameof(RB_Goods_WK_StudyTime.GoodsId)} in({dmodel.GoodsIds})";
            }

            string sql = $@"
SELECT gc.* FROM RB_Goods_WK_StudyTime gc 
WHERE {where} ORDER BY gc.Id desc ";
            return GetPage<RB_Goods_WK_StudyTime_Extend>(pageIndex, pageSize, out count, sql).ToList();
        }

        /// <summary>
        /// 学习时间
        /// </summary>
        /// <param name="userId"></param>
        /// <param name="startTime"></param>
        /// <param name="endTime"></param>
        /// <returns></returns>
        public List<RB_Goods_WK_StudyTime_Extend> GetMyStudyTimeByDay(int userId, string startTime, string endTime)
        {
            string sql = $@"SELECT DATE_FORMAT(CreateDate,'%Y-%m-%d') CreateDate,SUM(Time) Time FROM rb_goods_wk_studytime WHERE UserId = {userId} AND CreateDate >='{startTime}' AND CreateDate <= '{endTime} 23:59:59'
GROUP BY DATE_FORMAT(CreateDate,'%Y-%m-%d') ORDER BY DATE_FORMAT(CreateDate,'%Y-%m-%d')";

            return Get<RB_Goods_WK_StudyTime_Extend>(sql).ToList();
        }

        /// <summary>
        /// 获取今天学习时间
        /// </summary>
        /// <param name="userId"></param>
        /// <param name="time"></param>
        /// <returns></returns>
        public int GetMyStudyTimeByToDay(int userId, string time)
        {
            string sql = $@"SELECT DATE_FORMAT(CreateDate,'%Y-%m-%d') CreateDate,SUM(Time) Time FROM rb_goods_wk_studytime WHERE UserId = {userId} AND CreateDate >='{time}' AND CreateDate <= '{time} 23:59:59'
GROUP BY DATE_FORMAT(CreateDate,'%Y-%m-%d') ORDER BY DATE_FORMAT(CreateDate,'%Y-%m-%d')";

            var model = Get<RB_Goods_WK_StudyTime_Extend>(sql).FirstOrDefault();
            if (model != null)
            {
                return model.Time;
            }
            else {
                return 0;
            }
        }
        /// <summary>
        /// 获取累积学习时间
        /// </summary>
        /// <param name="userId"></param>
        /// <returns></returns>
        public int GetMyStudyTimeByTotal(int userId)
        {
            string sql = $@"SELECT SUM(Time) Time FROM rb_goods_wk_studytime WHERE UserId = {userId}";

            var model = Get<RB_Goods_WK_StudyTime_Extend>(sql).FirstOrDefault();
            if (model != null)
            {
                return model.Time;
            }
            else
            {
                return 0;
            }
        }
        /// <summary>
        /// 获取连续学习天数
        /// </summary>
        /// <param name="userId"></param>
        /// <returns></returns>
        public int GetMyStudyTimeByStydyDay(int userId)
        {
            string sql = $@"select GetUserStudyDay({userId})";

            var obj = ExecuteScalar(sql);
            if (obj != null)
            {
                return Convert.ToInt32(obj);
            }
            else {
                return 0;
            }
        }

        /// <summary>
        /// 获取最后一条记录
        /// </summary>
        /// <param name="userId"></param>
        /// <returns></returns>
        public RB_Goods_WK_StudyTime_Extend GetMyStudyTimeByLast(int userId)
        {
            string sql = $@"SELECT * FROM rb_goods_wk_studytime WHERE UserId = {userId} order by Id desc limit 1 ";
            return Get<RB_Goods_WK_StudyTime_Extend>(sql).FirstOrDefault();
        }

        /// <summary>
        /// 最近学习列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="userId"></param>
        /// <returns></returns>
        public List<RB_Goods_WK_StudyTime_Extend> GetMyRecentStudyPageList(int pageIndex, int pageSize, out long count, int userId)
        {
            string sql = $@"
SELECT wk.GoodsId,g.`Name` as GoodsName,g.CarouselImage FROM rb_goods_wk_studytime wk
INNER JOIN rb_goods g on wk.GoodsId = g.Id
 WHERE wk.UserId ={userId} AND g.GoodsClassify = 2 GROUP BY wk.GoodsId ORDER BY wk.CreateDate DESC";
            return GetPage<RB_Goods_WK_StudyTime_Extend>(pageIndex, pageSize, out count, sql).ToList();
        }

        /// <summary>
        /// 获取我的学习详情
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="userId"></param>
        /// <returns></returns>
        public List<RB_Goods_WK_StudyTime_Extend> GetMyStudyDetailPageList(int pageIndex, int pageSize, out long count, int userId)
        {
            string sql = $@"
SELECT wk.GoodsId,wk.CreateDate,g.`Name` as GoodsName,g.CarouselImage,g.CourseScore,g.CourseLable FROM rb_goods_wk_studytime wk
INNER JOIN rb_goods g on wk.GoodsId = g.Id
 WHERE wk.UserId ={userId} AND g.GoodsClassify = 2 ORDER BY wk.CreateDate DESC";
            return GetPage<RB_Goods_WK_StudyTime_Extend>(pageIndex, pageSize, out count, sql).ToList();
        }

        /// <summary>
        /// 我的报名记录
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="userId"></param>
        /// <returns></returns>
        public List<RB_Goods_WK_StudyTime_Extend> GetMyOrderStudyRecordPageList(int pageIndex, int pageSize, out long count, int userId)
        {
            string sql = $@"SELECT od.GoodsId,g.`Name` as GoodsName,g.CarouselImage FROM rb_goods_orderdetail od
INNER JOIN rb_goods_order o on od.OrderId = o.OrderId
INNER JOIN rb_goods g on od.GoodsId = g.Id
WHERE o.OrderStatus = 5 AND o.OrderClassify = 2 AND o.UserId = {userId} 
ORDER BY o.PaymentTime DESC";
            return GetPage<RB_Goods_WK_StudyTime_Extend>(pageIndex, pageSize, out count, sql).ToList();
        }
    }
}
