﻿using Mall.Model.Entity.Property;
using Mall.Model.Extend.Property;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.Property
{
    /// <summary>
    /// 员工扩展方法
    /// </summary>
    public partial class Rb_employeeRepository : BaseRepository<RB_Employee>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_Employee); } }

        /// <summary>
        /// 分页查询
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="model">查询实体条件</param>
        /// <param name="Status">0-在职，其他-离职</param>
        /// <param name="sEmEntry">入职起始时间</param>
        /// <param name="eEmEntry">入职结束时间</param>
        /// <param name="sEmLeave">离职起始时间</param>
        /// <param name="eEmLeave">离职结束时间</param>
        /// <param name="RowCount">总条数</param>
        /// <returns></returns>
        public List<RB_Employee_Extend> GetPageList(int pageIndex, int pageSize, RB_Employee model, int Status, string sEmEntry, string eEmEntry, string sEmLeave, string eEmLeave,
            out long RowCount)
        {
            StringBuilder sb = new StringBuilder(); ;
            if (model.RB_Group_id > 0)
            {
                sb.AppendFormat(" AND e.{0}={1}", nameof(RB_Employee.RB_Group_id), model.RB_Group_id);
            }
            if (model.RB_Branch_id >= 0)
            {
                sb.AppendFormat(" AND e.{0}={1}", nameof(RB_Employee.RB_Branch_id), model.RB_Branch_id);
            }
            if (model.RB_Department_Id > 0)
            {
                sb.AppendFormat(" AND e.{0}={1}", nameof(RB_Employee.RB_Department_Id), model.RB_Department_Id);
            }
            if (model.RB_Post_Id > 0)
            {
                sb.AppendFormat(" AND e.{0}={1}", nameof(RB_Employee.RB_Post_Id), model.RB_Post_Id);
            }
            if (!string.IsNullOrEmpty(model.EmName))
            {
                sb.AppendFormat(" AND e.{0} LIKE '%{1}%'", nameof(RB_Employee.EmName), model.EmName.Trim());

            }
            if (!string.IsNullOrEmpty(model.EmAccount))
            {
                sb.AppendFormat(" AND e.{0} LIKE '%{1}%'", nameof(RB_Employee.EmAccount), model.EmAccount.Trim());
            }
            if (Status >= 0)
            {
                if (Status == 0)
                {
                    sb.AppendFormat(" AND e.{0}=0 ", nameof(RB_Employee.IsLeave));
                }
                else
                {
                    sb.AppendFormat(" AND e.{0}=1 ", nameof(RB_Employee.IsLeave));
                }
            }
            if (!string.IsNullOrEmpty(sEmEntry))
            {
                sb.AppendFormat(" AND e.{0}>='{1}' ", nameof(RB_Employee.EmEntry), sEmEntry);
            }
            if (!string.IsNullOrEmpty(eEmEntry))
            {
                sb.AppendFormat(" AND e.{0}<='{1} 23:59:59'  ", nameof(RB_Employee.EmEntry), eEmEntry);
            }
            if (!string.IsNullOrEmpty(sEmLeave))
            {
                sb.AppendFormat(" AND e.{0}>='{1}' and e.{2}=1 ", nameof(RB_Employee.EmLeave), sEmLeave, nameof(RB_Employee.IsLeave));
            }
            if (!string.IsNullOrEmpty(eEmLeave))
            {
                sb.AppendFormat(" AND e.{0}<='{1} 23:59:59' and e.{2}=1 ", nameof(RB_Employee.EmLeave), eEmLeave, nameof(RB_Employee.IsLeave));
            }
            if (model.EmployeeType > 0)
            {
                sb.AppendFormat(" AND e.{0}={1} ", nameof(RB_Employee.EmployeeType), model.EmployeeType);
            }
            if (sb.ToString().Length > 0)
            {
                sb.Insert(0, " WHERE 1=1 ");
            }
            string sql = string.Format($@"SELECT e.*,g.GroupName,b.BName as CompanyName,d.DepartmentName,p.PostName FROM {TableName} e left join {nameof(RB_Group)} g on e.{nameof(RB_Employee.RB_Group_id)}=g.{nameof(RB_Group.Id)}
left join RB_Branch b on e.{nameof(RB_Employee.RB_Branch_id)}=b.Id
left join RB_Department d on e.{nameof(RB_Employee.RB_Department_Id)}=d.DepartmentID
left join RB_Post p on e.{nameof(RB_Employee.RB_Post_Id)}=p.PostId
{sb.ToString()}");
            return GetPage<RB_Employee_Extend>(pageIndex, pageSize, out RowCount, sql).ToList();
        }

        /// <summary>
        /// 获取集团下 在职员工的数量
        /// </summary>
        /// <param name="GroupId"></param>
        /// <returns></returns>
        public int GetGroupEmployeeNum(int GroupId)
        {
            string sql = $@" SELECT count(0) as Num FROM {TableName} where RB_Group_id={GroupId} and IsLeave=0";
            var obj = ExecuteScalar(sql);
            if (obj == null)
            {
                return 0;
            }
            else
            {
                return Convert.ToInt32(obj);
            }
        }

        /// <summary>
        /// 根据条件获取员工列表
        /// </summary>
        /// <param name="where"></param>
        /// <param name="SelectNormal"></param>
        /// <returns></returns>
        public List<RB_Employee_Extend> GetListByWhere(RB_Employee_Extend where, bool SelectNormal = true)
        {
            StringBuilder sb = new StringBuilder();
            sb.AppendFormat($@" SELECT {TableName}.*,rb_post.PostName,m.OpenAccount FROM {TableName} LEFT JOIN (SELECT m.EmpId,m.OpenAccount from rb_account_mapping m where m.MappingSource = 3) m on m.EmpId = {TableName}.EmployeeId 
              left join rb_post on {TableName}.RB_Post_Id=rb_post.PostId WHERE 1=1 ");
            if (where != null)
            {
                if (where.RB_Group_id > 0)
                {
                    sb.AppendFormat(" AND RB_Employee.{0}={1} ", nameof(RB_Employee.RB_Group_id), where.RB_Group_id);
                }
                if (where.RB_Branch_id >= 0)
                {
                    sb.AppendFormat(" AND RB_Employee.{0}={1} ", nameof(RB_Employee.RB_Branch_id), where.RB_Branch_id);
                }
                if (where.RB_Department_Id > 0)
                {
                    sb.AppendFormat(" AND RB_Employee.{0}={1} ", nameof(RB_Employee.RB_Department_Id), where.RB_Department_Id);
                }
                if (!string.IsNullOrWhiteSpace(where.DepartmentIds))
                {
                    sb.AppendFormat(" AND RB_Employee.{0} in({1}) ", nameof(RB_Employee.RB_Department_Id), where.DepartmentIds);
                }
                if (where.RB_Post_Id > 0)
                {
                    sb.AppendFormat(" AND RB_Employee.{0}={1} ", nameof(RB_Employee.RB_Post_Id), where.RB_Post_Id);
                }
                if (where.IsLeave >= 0)
                {
                    sb.AppendFormat(" AND RB_Employee.{0}={1} ", nameof(RB_Employee.IsLeave), where.IsLeave);
                }
                if (!string.IsNullOrWhiteSpace(where.LeaveMonth))
                {
                    sb.AppendFormat(" AND case when RB_Employee.IsLeave=1 then RB_Employee.{0}>='{1}' else  RB_Employee.{3}<='{2}' end ", nameof(RB_Employee.EmLeave), where.LeaveMonth + "-01", Convert.ToDateTime(where.LeaveMonth + "-01").AddMonths(1).AddDays(-1).ToString("yyyy-MM-dd") + " 23:59:59", nameof(RB_Employee.EmEntry));
                }
                if (!string.IsNullOrEmpty(where.EmAccount))
                {
                    sb.AppendFormat(" AND RB_Employee.{0}='{1}' ", nameof(RB_Employee.EmAccount), where.EmAccount.Trim());
                }
                if (!string.IsNullOrEmpty(where.EmLoginMobile))
                {
                    sb.AppendFormat(" AND RB_Employee.{0}='{1}' ", nameof(RB_Employee.EmLoginMobile), where.EmLoginMobile.Trim());
                }
                if (!string.IsNullOrWhiteSpace(where.EmployeeIds))
                {
                    sb.AppendFormat(" AND RB_Employee.{0} in({1}) ", nameof(RB_Employee.EmployeeId), where.EmployeeIds);
                }
                if (SelectNormal)
                {
                    sb.Append(" AND RB_Employee.IsLeave=0 ");
                }
            }
            return Get<RB_Employee_Extend>(sb.ToString()).ToList();
        }

        /// <summary>
        /// 根据where 获取列表数据
        /// </summary>
        /// <param name="where">查询条件</param>
        /// <returns></returns>
        public List<RB_Employee_Extend> GetList(RB_Employee_Extend where)
        {
            StringBuilder sb = new StringBuilder();
            sb.AppendFormat($@" SELECT e.*,p.PostName FROM {TableName} e left join RB_Post p on e.{nameof(RB_Employee.RB_Post_Id)}=p.PostId WHERE 1=1 ");
            if (where != null)
            {
                if (where.RB_Group_id > 0)
                {
                    sb.AppendFormat(" AND e.{0}={1} ", nameof(RB_Employee.RB_Group_id), where.RB_Group_id);
                }
                if (!string.IsNullOrWhiteSpace(where.EmployeeIds))
                {
                    sb.AppendFormat(" AND e.{0} in({1}) ", nameof(RB_Employee.EmployeeId), where.EmployeeIds);
                }
                if (where.RB_Department_Id > 0)
                {
                    sb.AppendFormat(" AND e.{0}={1} ", nameof(RB_Employee.RB_Department_Id), where.RB_Department_Id);
                }
                if (where.BranchId >= 0)
                {
                    sb.AppendFormat(" AND e.{0}={1} ", nameof(RB_Employee.RB_Branch_id), where.BranchId);
                }
                if (where.RB_Post_Id > 0)
                {
                    sb.AppendFormat(" AND e.{0}={1} ", nameof(RB_Employee.RB_Post_Id), where.RB_Post_Id);
                }
                sb.Append(" AND IsLeave=0 ");
            }
            return Get<RB_Employee_Extend>(sb.ToString()).ToList();
        }

        
        /// <summary>
        /// 根据员工IDs，批量获取员工信息
        /// </summary>
        /// <param name="ids">员工Id，多个员工用,</param>
        /// <returns></returns>
        public List<RB_Employee_Extend> GetEmpInfoByIds(string ids)
        {
            if (ids != null && !string.IsNullOrEmpty(ids.Trim()))
            {
                StringBuilder sb = new StringBuilder();
                sb.AppendFormat(@" SELECT EmployeeId,EmName,EmPhoto,EmMobile,CreateTime,EmLoginMobile,RB_Branch_id,RB_Group_id,IsLeave,RB_Post_Id FROM {0} ", TableName);
                sb.AppendFormat("  WHERE {0} in ({1})", nameof(RB_Employee.EmployeeId), ids);
                return Get<RB_Employee_Extend>(sb.ToString()).ToList();
            }
            return new List<RB_Employee_Extend>();
        }

        /// <summary>
        /// 获取所有在职员工
        /// </summary>
        /// <returns></returns>
        public List<RB_Employee_Extend> GetEmpInfoForZZ()
        {
            StringBuilder sb = new StringBuilder();
            sb.AppendFormat(@" SELECT EmployeeId,EmName,EmPhoto,EmMobile,CreateTime,EmLoginMobile,RB_Branch_id,RB_Group_id,IsLeave FROM {0} ", TableName);
            sb.AppendFormat("  WHERE {0} ={1}", nameof(RB_Employee.IsLeave), 0);
            return Get<RB_Employee_Extend>(sb.ToString()).ToList();
        }

        /// <summary>
        /// 根据员工id获取员工信息
        /// </summary>
        /// <param name="EmployeeId">员工编号</param>
        /// <returns></returns>
        public RB_Employee_Extend GetEmpInfoByEmpId(int EmployeeId)
        {
            StringBuilder sb = new StringBuilder();
            sb.AppendFormat(@"
                                 SELECT e.*,g.GroupName,b.BName as CompanyName,d.DepartmentName,P.PostName  
                                 FROM rb_employee e
                                 LEFT JOIN rb_group g ON e.RB_Group_id=g.Id
                                 LEFT JOIN rb_branch b on e.RB_Branch_id = b.Id
                                 LEFT JOIN rb_department d on e.RB_Department_Id = d.DepartmentID
                                 LEFT JOIN rb_post p ON e.RB_Post_Id=p.PostId
                                 WHERE e.{0} ={1}", nameof(RB_Employee_Extend.EmployeeId), EmployeeId);
            sb.Append(" LIMIT 1;");
            return Get<RB_Employee_Extend>(sb.ToString()).ToList().FirstOrDefault();
        }


        /// <summary>
        /// 根据部门岗位关联表id获取部门岗位下所有员工
        /// </summary>
        /// <param name="depPostRelevanceId"></param>
        /// <returns></returns>
        public List<RB_Employee_Extend> GetEmpByDepPostRelevanceId(int depPostRelevanceId)
        {
            string sql = $@"SELECT * from rb_employee e 
                            LEFT JOIN rb_departmentpost_relevance r 
                            on e.RB_Department_Id = r.DepartmentId and e.RB_Post_Id = r.PostId
                            where r.Id = {depPostRelevanceId} and e.IsLeave = 0";
            return Get<RB_Employee_Extend>(sql).ToList();
        }


        /// <summary>
        /// 根据员工id获取员工所在部门
        /// </summary>
        /// <param name="eid"></param>
        /// <returns></returns>
        public string GetDepartmentForEmplyoeeId(int eid)
        {
            string where = $@" where 1=1 and {nameof(RB_Employee_Extend.EmployeeId)}={eid}";
            var data = ExecuteScalar($@" select d.DepartmentName from rb_employee e left join rb_department d on e.RB_Department_Id=d.DepartmentID {where}");
            if (data != null)
            {
                return data.ToString();
            }
            else
            {
                return "";
            }
        }

        /// <summary>
        /// 根据账号密码获取员工信息
        /// </summary>
        /// <param name="account">账号</param>
        /// <param name="pwd">密码</param>
        /// <returns></returns>
        public RB_Employee GetByAccountAndPwd(string account, string pwd)
        {
            string sql = $"SELECT * from rb_employee WHERE EmAccount = '{account}' and EmPassword = '{pwd}'";
            return Get<RB_Employee>(sql).FirstOrDefault();
        }

        /// <summary>
        /// 验证登录手机号码
        /// </summary>
        /// <param name="employeeId"></param>
        /// <param name="loginMobile"></param>
        /// <param name="groupId"></param>
        /// <returns></returns>
        public bool ValidateLoginMobileRepetition(int employeeId, string loginMobile, int groupId)
        {
            string sql = $"SELECT * from rb_employee WHERE {nameof(RB_Employee.EmLoginMobile)} = '{loginMobile}' and {nameof(RB_Employee.EmployeeId)} != {employeeId} and {nameof(RB_Employee.RB_Group_id)}={groupId}";
            var list = Get(sql).ToList();
            if (list.Count() > 0)
            {
                return true;
            }
            else
            {
                return false;
            }
        }

        /// <summary>
        /// 根据账号获取员工信息
        /// </summary>
        /// <param name="account">账号</param>
        /// <returns></returns>
        public RB_Employee GetByAccount(string account)
        {
            string sql = $"SELECT * from rb_employee WHERE EmAccount = '{account}' and IsLeave = 0";
            return Get<RB_Employee>(sql).FirstOrDefault();
        }

        /// <summary>
        /// 根据账号获取员工信息 最新（2018-12-18新增）
        /// </summary>
        /// <param name="account">账号</param>
        /// <param name="RB_Group_id">集团id</param>
        /// <returns></returns>
        public RB_Employee GetByAccount(string account, int RB_Group_id = 0)
        {
            string sql = $"SELECT * from rb_employee WHERE EmAccount = '{account}' and IsLeave = 0";
            if (RB_Group_id > 0)
            {
                sql += $" and RB_Group_id={RB_Group_id}";
            }
            return Get<RB_Employee>(sql).FirstOrDefault();
        }
        /// <summary>
        /// 根据登陆手机号密码获取员工信息
        /// </summary>
        /// <param name="loginMobile">登陆手机号</param>
        /// <param name="pwd">密码</param>
        /// <returns></returns>
        public RB_Employee GetByLoginMobileAndPwd(string loginMobile, string pwd)
        {
            string sql = $"SELECT * from rb_employee WHERE EmLoginMobile = '{loginMobile}' and EmPassword = '{pwd}'";
            return Get<RB_Employee>(sql).FirstOrDefault();
        }
        /// <summary>
        /// 根据登陆手机号获取员工信息
        /// </summary>
        /// <param name="loginMobile">登陆手机号</param>
        /// <returns></returns>
        public RB_Employee GetByLoginMobile(string loginMobile)
        {
            string sql = $"SELECT * from rb_employee WHERE EmLoginMobile = '{loginMobile}' and IsLeave = 0";
            return Get<RB_Employee>(sql).FirstOrDefault();
        }
        /// <summary>
        /// 根据账号获取员工信息(多账号)
        /// </summary>
        /// <param name="account">账号</param>
        /// <returns></returns>
        public List<RB_Employee> GetEmployeeListByAccount(string account)
        {
            string sql = $"SELECT * from rb_employee WHERE (EmAccount = '{account}' or EmLoginMobile = '{account}') and IsLeave = 0";
            return Get<RB_Employee>(sql).ToList();
        }

        /// <summary>
        /// 根据登陆手机号获取员工信息  最新（2018-12-18 Add）
        /// </summary>
        /// <param name="loginMobile">登陆手机号</param>
        /// <param name="RB_Group_id">集团id</param>
        /// <returns></returns>
        public RB_Employee GetByLoginMobile(string loginMobile, int RB_Group_id = 0)
        {
            string sql = $"SELECT * from rb_employee WHERE EmLoginMobile = '{loginMobile}' ";
            if (RB_Group_id > 0)
            {
                sql += $" and RB_Group_id={RB_Group_id}";
            }
            return Get<RB_Employee>(sql).FirstOrDefault();
        }
       
      

        /// <summary>
        /// 根据根据部门id获取部门下所有员工
        /// </summary>
        /// <param name="depId">部门id</param>
        /// <returns></returns>
        public List<RB_Employee_Extend> GetEmpByDepartmentId(int depId)
        {
            return Get<RB_Employee_Extend>($"SELECT * from rb_employee e where e.RB_Department_Id = {depId} and e.IsLeave = 0").ToList();
        }

        /// <summary>
        /// 根据根据部门id获取部门下所有员工(用于缓存)
        /// </summary>
        /// <param name="depId">部门id</param>
        /// <returns></returns>
        public List<RB_Employee_Extend> GetEmpCacheByDepartmentId(int depId)
        {
            return Get<RB_Employee_Extend>($"SELECT * from rb_employee e where e.RB_Department_Id = {depId}").ToList();
        }

        /// <summary>
        /// 根据根据部门id获取部门下所有员工
        /// </summary>
        /// <param name="depIds">部门id(1,2)</param>
        /// <returns></returns>
        public List<RB_Employee_Extend> GetEmpByDepartmentIds(string depIds)
        {
            return Get<RB_Employee_Extend>($"SELECT * from rb_employee e where e.RB_Department_Id in ({depIds}) and e.IsLeave = 0").ToList();
        }

        /// <summary>
        /// 根据部门岗位关联表id获取部门岗位下所有员工
        /// </summary>
        /// <param name="depPostRelevanceIds">部门岗位关联表id(1,2,3)</param>
        /// <returns></returns>
        public List<RB_Employee_Extend> GetEmpByDepPostRelevanceIds(string depPostRelevanceIds)
        {
            string sql = $@"SELECT * from rb_employee e 
                            LEFT JOIN rb_departmentpost_relevance r 
                            on e.RB_Department_Id = r.DepartmentId and e.RB_Post_Id = r.PostId
                            where r.Id in ({depPostRelevanceIds}) and e.IsLeave = 0";
            return Get<RB_Employee_Extend>(sql).ToList();
        }

        /// <summary>
        ///  根据部门id获取员工列表以及对应IM信息
        /// </summary>
        /// <param name="depId">部门id</param>
        /// <returns></returns>
        public List<RB_Employee_Extend> GetEmpAndImByDepartmentId(int depId)
        {
            string sql = $@"SELECT e.*,m.OpenAccount from rb_employee e 
                            LEFT JOIN (SELECT m.EmpId,m.OpenAccount from rb_account_mapping m where m.MappingSource = 3) m on m.EmpId = e.EmployeeId
                            where e.RB_Department_Id = {depId} and e.IsLeave = 0";
            return Get<RB_Employee_Extend>(sql).ToList();
        }

        /// <summary>
        /// 根据部门id列表  获取全部成员
        /// </summary>
        /// <param name="depStr"></param>
        /// <param name="MobilePhone"></param>
        /// <returns></returns>
        public List<RB_Employee_Extend> GetEmpAndImByDepStr(string depStr, string MobilePhone = "")
        {
            string sql = $@"SELECT e.*,d.DepartmentName from rb_employee e left join rb_department d on e.RB_Department_Id=d.DepartmentID
                            where e.RB_Department_Id in ({depStr}) and e.IsLeave = 0 and d.`Status`=0 ";
            if (!string.IsNullOrWhiteSpace(MobilePhone))
            {
                sql += $@" and (e.{nameof(RB_Employee.EmLoginMobile)} like '%{MobilePhone}%' or e.{nameof(RB_Employee.EmName)} like '%{MobilePhone}%')";
            }
            return Get<RB_Employee_Extend>(sql).ToList();
        }

        
        /// <summary>
        /// 根据关键字搜索员工
        /// </summary>
        /// <param name="key">密码</param>
        /// <param name="groupId">集团id</param>
        /// <returns></returns>
        public RB_Employee GetByEmpBySearchKey(string key, int groupId)
        {
            string sql = $"SELECT * from rb_employee e WHERE e.EmName LIKE '%{key}%' or '{key}' LIKE CONCAT('%',e.EmName,'%') and e.IsLeave = 0 and e.RB_Group_id ={groupId} LIMIT 1";
            return Get<RB_Employee>(sql).FirstOrDefault();
        }

        /// <summary>
        /// 获取语音搜索索引分页查询
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="RowCount">总条数</param>
        /// <param name="pageCount">总页数</param>
        /// <returns></returns>
        public List<RB_Employee> GetVoiceIndexPageList(int pageIndex, int pageSize, out long RowCount, out int pageCount)
        {
            string sql = $"SELECT * FROM `rb_employee` WHERE `EmName` <> '' AND `IsLeave` = '0'";
            var list = GetPage(pageIndex, pageSize, out RowCount, sql).ToList();
            if (RowCount % pageSize == 0)
            {
                pageCount = Convert.ToInt32(RowCount) / pageSize;
            }
            else
            {
                pageCount = Convert.ToInt32(RowCount) / pageSize + 1;
            }
            return list;
        }


      

        /// <summary>
        /// 获取所有员工id
        /// </summary>
        /// <param name="where"></param>
        /// <returns></returns>
        public string GetEmpStrForWhere(RB_Employee_Extend where)
        {
            string whereStr = "";
            if (where.RB_Branch_id >= 0)
            {
                whereStr = $@" and RB_Branch_id={where.RB_Branch_id}";
            }
            string sql = $@"SELECT GROUP_CONCAT(EmployeeId) FROM rb_employee WHERE IsLeave=0 {whereStr}";
            var obj = ExecuteScalar(sql);
            if (obj != null)
            {
                return obj.ToString();
            }
            else
            {
                return "";
            }
        }

        /// <summary>
        /// 验证该集团下是否已经有管理员账户
        /// </summary>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<RB_Employee_Extend> ValidateAdmin(RB_Employee_Extend where)
        {
            StringBuilder sb = new StringBuilder();
            sb.AppendFormat($@" SELECT e.* FROM {TableName} e  WHERE 1=1 ");
            if (where != null)
            {
                if (where.RB_Group_id > 0)
                {
                    sb.AppendFormat(" AND e.{0}={1} ", nameof(RB_Employee.RB_Group_id), where.RB_Group_id);
                }
                if (where.IsAdmin > 0)
                {
                    sb.AppendFormat(" AND e.{0}={1} ", nameof(RB_Employee.IsAdmin), where.IsAdmin);
                }
            }
            return Get<RB_Employee_Extend>(sb.ToString()).ToList();
        }

    }
}
