﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.User;
using Mall.Model.Extend.User;
using System.Linq;

namespace Mall.Repository.User
{
    /// <summary>
    /// 微店价格仓储层
    /// </summary>
    public class RB_SmallShops_PriceRepository : BaseRepository<RB_SmallShops_Price>
    {

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_SmallShops_Price_Extend> GetList(RB_SmallShops_Price_Extend dmodel)
        {
            string where = $@" 1=1 and di.{nameof(RB_SmallShops_Price_Extend.Status)}=0";
            if (dmodel.TenantId > 0)
            {
                where += $@" and di.{nameof(RB_SmallShops_Price_Extend.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and di.{nameof(RB_SmallShops_Price_Extend.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.SmallShopsId > 0)
            {
                where += $@" and di.{nameof(RB_SmallShops_Price_Extend.SmallShopsId)}={dmodel.SmallShopsId}";
            }
            if (dmodel.GoodsId > 0) 
            {
                where += $@" and di.{nameof(RB_SmallShops_Price_Extend.GoodsId)}={dmodel.GoodsId}";
            }
            if (!string.IsNullOrEmpty(dmodel.SmallShopsIds)) {
                where += $@" and di.{nameof(RB_SmallShops_Price_Extend.SmallShopsId)} in({dmodel.SmallShopsIds})";
            }
            if (!string.IsNullOrEmpty(dmodel.GoodsIds)) {
                where += $@" and di.{nameof(RB_SmallShops_Price_Extend.GoodsId)} in({dmodel.GoodsIds})";
            }
            

            string sql = $@"select di.* from RB_SmallShops_Price di
where {where} order by di.Id desc";
            return Get<RB_SmallShops_Price_Extend>(sql).ToList();
        }

        /// <summary>
        /// 获取微店商品价格列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_SmallShops_Price_Extend> GetSmallShopsGoodsPricePageList(int pageIndex, int pageSize, out long count, RB_SmallShops_Price_Extend demodel)
        {
            string where = $@" 1=1 and sp.Status=0";
            if (demodel.TenantId > 0) 
            {
                where += $@" and sp.{nameof(RB_SmallShops_Price_Extend.TenantId)}={demodel.TenantId}";
            }
            if (demodel.MallBaseId > 0)
            {
                where += $@" and sp.{nameof(RB_SmallShops_Price_Extend.MallBaseId)}={demodel.MallBaseId}";
            }
            if (demodel.GoodsId > 0) 
            {
                where += $@" and sp.{nameof(RB_SmallShops_Price_Extend.GoodsId)}={demodel.GoodsId}";
            }
            if (!string.IsNullOrEmpty(demodel.GoodsName)) 
            {
                where += $@" and g.{nameof(Model.Entity.Product.RB_Goods.Name)} like '%{demodel.GoodsName}%'";
            }
            if (demodel.SmallShopsId > 0) {
                where += $@" and sp.{nameof(RB_SmallShops_Price_Extend.SmallShopsId)}={demodel.SmallShopsId}";
            }

            string sql = $@"
    SELECT sp.GoodsId FROM rb_smallshops_price sp
INNER JOIN rb_goods g on sp.GoodsId=g.Id
where {where}
GROUP BY sp.GoodsId  ORDER BY sp.CreateDate DESC 
";
            return GetPage<RB_SmallShops_Price_Extend>(pageIndex, pageSize, out count, sql).ToList();
        }
    }
}
