﻿using Mall.Model.Entity.User;
using Mall.Model.Extend.User;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.User
{
    /// <summary>
    /// 商户菜单表仓储层
    /// </summary>
    public class RB_Tenant_MenuRepository : BaseRepository<RB_Tenant_Menu>
    {
        /// <summary>
        /// 获取商户菜单列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Tenant_Menu_Extend> GetTenantMenuListRepository(RB_Tenant_Menu_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append(@" SELECT * FROM rb_tenant_menu WHERE 1=1 ");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Tenant_Menu_Extend.TenantId), query.TenantId);
                }
                return Get<RB_Tenant_Menu_Extend>(builder.ToString()).ToList();
            }
            else
            {
                return new List<RB_Tenant_Menu_Extend>();
            }
        }
    }
}
