﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.User;
using Mall.Model.Extend.User;
using System.Linq;

namespace Mall.Repository.User
{
    /// <summary>
    /// 专题表仓储层
    /// </summary>
    public class RB_TopicRepository : BaseRepository<RB_Topic>
    {
        /// <summary>
        /// 专题分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Topic_Extend> GetTopicPageListRepository(int pageIndex, int pageSize, out long rowCount, RB_Topic_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@" 
SELECT A.*,B.TopicName FROM RB_Topic AS A LEFT JOIN rb_topic_type AS B ON A.TopicTypeId=B.Id
WHERE 1=1 AND A.Status=0
");
            if (query.TenantId > 0)
            {
                builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Topic_Extend.TenantId), query.TenantId);
            }
            if (query.MallBaseId > 0)
            {
                builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Topic_Extend.MallBaseId), query.MallBaseId);
            }
            if (query.Id > 0)
            {
                builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Topic_Extend.Id), query.Id);
            }
            if (query.Title != null && !string.IsNullOrEmpty(query.Title.Trim()))
            {
                builder.AppendFormat(" AND A.{0} LIKE '%{1}%' ", nameof(RB_Topic_Extend.Title), query.Title.Trim());
            }
            if (query.TopicTypeId > 0)
            {
                builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Topic_Extend.TopicTypeId), query.TopicTypeId);
            }
            builder.Append(" ORDER BY A.SortNum ");
            return GetPage<RB_Topic_Extend>(pageIndex, pageSize, out rowCount, builder.ToString()).ToList();
        }

        /// <summary>
        /// 获取专题列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Topic_Extend> GetTopicListRepository(RB_Topic_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@" SELECT * FROM RB_Topic WHERE 1=1 AND Status=0 ");
            if (query.TenantId > 0)
            {
                builder.AppendFormat(" AND {0}={1} ", nameof(RB_Topic_Extend.TenantId), query.TenantId);
            }
            if (query.MallBaseId > 0)
            {
                builder.AppendFormat(" AND {0}={1} ", nameof(RB_Topic_Extend.MallBaseId), query.MallBaseId);
            }
            if (query.Id > 0)
            {
                builder.AppendFormat(" AND {0}={1} ", nameof(RB_Topic_Extend.Id), query.Id);
            }
            if (query.Title != null && !string.IsNullOrEmpty(query.Title.Trim()))
            {
                builder.AppendFormat(" AND {0} LIKE '%{1}%' ", nameof(RB_Topic_Extend.Title), query.Title.Trim());
            }
            builder.Append(" ORDER BY SortNum ");
            return Get<RB_Topic_Extend>(builder.ToString()).ToList();
        }
    }
}
