﻿using Mall.Repository.Product;
using System;
using System.Collections.Generic;
using System.Text;
using System.Linq;
using Mall.Model.Entity.Product;
using VT.FW.DB;
using Mall.Repository.Education;
using Mall.Model.Entity.Education;

namespace Mall.WindowsService.Module
{
    /// <summary>
    /// 资讯自动上架下架
    /// </summary>
    public class EducationArticleShelvesModule
    {
        /// <summary>
        /// 资讯评论信息
        /// </summary>
        private static readonly RB_Education_ArticleRepository educationArticleRepository = new RB_Education_ArticleRepository();

        /// <summary>
        /// 相亲每日随机会员查询信息
        /// </summary>
        private static readonly Repository.Miai.RB_MiAi_BaseInfoDayQueryRepository miaiBaseInfoDayQueryRepository = new Repository.Miai.RB_MiAi_BaseInfoDayQueryRepository();
        /// <summary>
        /// 会员储值卡仓储层
        /// </summary>
        private static readonly Repository.User.RB_Member_DepositBuyRepository memberDepositBuyRepository = new Repository.User.RB_Member_DepositBuyRepository();

        /// <summary>
        /// 商品自动上架时间
        /// </summary>
        /// <returns></returns>
        public static bool ShelvesEducationArticleModule()
        {
            bool flag = false;
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT ID,ArticleStatus,ShelvesDate,DownDate 
FROM rb_education_article 
WHERE Status=0 AND '{0}'>=ShelvesDate AND '{0}'<=DownDate  AND ArticleStatus<>1  
", DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss"));

            var list = educationArticleRepository.Get<RB_Education_Article>(builder.ToString()).ToList();
            if (list != null && list.Count > 0)
            {
                foreach (var item in list)
                {
                    Dictionary<string, object> fileds = new Dictionary<string, object>()
                    {
                        {nameof(RB_Education_Article.ArticleStatus),1 }
                    };
                    flag = educationArticleRepository.Update(fileds, new WhereHelper(nameof(RB_Education_Article.ID), item.ID));
                }
            }
            return flag;
        }


        /// <summary>
        /// 商品自动下架
        /// </summary>
        /// <returns></returns>
        public static bool DownEducationArticleModule()
        {
            bool flag = false;
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT ID,ArticleStatus,ShelvesDate,DownDate
FROM rb_education_article 
WHERE Status=0 AND DownDate<='{0}' AND ArticleStatus=1 ", DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss"));

            var list = educationArticleRepository.Get<RB_Education_Article>(builder.ToString()).ToList();
            if (list != null && list.Count > 0)
            {
                foreach (var item in list)
                {
                    Dictionary<string, object> fileds = new Dictionary<string, object>()
                    {
                        {nameof(RB_Education_Article.ArticleStatus),2 }
                    };
                    flag = educationArticleRepository.Update(fileds, new WhereHelper(nameof(RB_Education_Article.ID), item.ID));
                }
            }
            return flag;
        }

        /// <summary>
        /// 更新会员储值卡赠送状态
        /// </summary>
        /// <returns></returns>
        public static bool MemberDepositBuyModule()
        {
            bool flag = false;
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT *
FROM RB_Member_DepositBuy 
WHERE Status=1 AND SendTime<='{0}' and SendStatus=2 ", DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss"));

            var list = memberDepositBuyRepository.Get<Model.Entity.User.RB_Member_DepositBuy>(builder.ToString()).ToList();
            if (list != null && list.Count > 0)
            {
                foreach (var item in list)
                {
                    Dictionary<string, object> fileds = new Dictionary<string, object>()
                    {
                        {nameof(Model.Entity.User.RB_Member_DepositBuy.SendStatus),0 },
                        {nameof(Model.Entity.User.RB_Member_DepositBuy.SendTime),null }
                    };
                    flag = memberDepositBuyRepository.Update(fileds, new WhereHelper(nameof(Model.Entity.User.RB_Member_DepositBuy.Id), item.Id));
                }
            }
            return flag;
        }


        /// <summary>
        /// 相亲每日随机查询信息删除
        /// </summary>
        /// <returns></returns>
        public static bool DailyRandomModule()
        {
            bool flag = false;
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@" SELECT * from RB_MiAi_BaseInfoDayQuery  where Status=0   and DATE_FORMAT(CreateDate,'%Y-%m-%d' ) < DATE_FORMAT('{0}','%Y-%m-%d' )", DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss"));

            var list = miaiBaseInfoDayQueryRepository.Get<Model.Entity.Miai.RB_MiAi_BaseInfoDayQuery>(builder.ToString()).ToList();
            if (list != null && list.Count > 0)
            {

                flag = miaiBaseInfoDayQueryRepository.DeleteBatch(list);

            }
            return flag;
        }

    }
}
