﻿using Mall.CacheKey;
using Mall.CacheManager.DataStatistic;
using Mall.Common;
using Mall.Common.Plugin;
using Mall.Common.Plugin.Redis;
using Mall.Model.Extend.User;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.CacheManager.User
{
    /// <summary>
    /// redis缓存（只适用于数据统计）
    /// </summary>
    public class UserReidsCache
    {
        static RedisHelper redis = new RedisHelper(DataConstant.REDIS_DB2);

        /// <summary>
        /// 设置缓存
        /// </summary>
        /// <param name="model"></param>
        public static void UserInfoSet(string cacheKey, UserInfo model, int JwtExpirTime)
        {
            try
            {
                TimeSpan ts = GetExpirTime(JwtExpirTime);
                redis.StringSet<UserInfo>(cacheKey, model, ts);
            }
            catch (Exception ex)
            {
                Common.Plugin.LogHelper.Write(ex, "UserInfoSet缓存设置失败");
            }
        }

        /// <summary>
        /// 获取缓存时长
        /// </summary>
        /// <param name="JwtExpirTime"></param>
        /// <returns></returns>
        private static TimeSpan GetExpirTime(int JwtExpirTime)
        {
            DateTime dt = DateTime.Now;
            DateTime dt2 = DateTime.Now;
            TimeSpan ts = dt.AddSeconds(JwtExpirTime) - dt2;
            return ts;
        }

        /// <summary>
        /// 判断key是否存在
        /// </summary>
        /// <param name="cacheKey"></param>
        /// <returns></returns>
        public static bool Exists(string cacheKey)
        {
            return redis.KeyExists(cacheKey);
        }

        /// <summary>
        /// 设置缓存
        /// </summary>
        /// <param name="cacheKey"></param>
        /// <param name="Data"></param>
        /// <param name="JwtExpirTime"></param>
        public static void Set(string cacheKey, object Data, int JwtExpirTime)
        {
            try
            {
                TimeSpan ts = GetExpirTime(JwtExpirTime);
                redis.StringSet(cacheKey, Data, ts);
            }
            catch (Exception)
            {
            }
        }

        /// <summary>
        /// 商户信息仓储层对象
        /// </summary>
        private static Mall.Repository.User.RB_TenantRepository tenantRepository = new Repository.User.RB_TenantRepository();

        /// <summary>
        /// 获取用户登录信息
        /// </summary>
        /// <param name="TenantId">商户Id</param>
        /// <returns></returns>
        public static UserInfo GetUserLoginInfo(object TenantId)
        {
            string cacheKey = UserModuleCacheKeyConfig.Mall_Login_Info + TenantId.ToString();
            UserInfo userInfo = null;
            try
            {
                userInfo = redis.StringGet<UserInfo>(cacheKey);
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "GetUserLoginInfo");
            }
            if (userInfo == null)
            {
                Int32.TryParse(TenantId.ToString(), out int NewTenantId);
                if (NewTenantId > 0)
                {
                    string token = "";
                    var extModel = tenantRepository.GetEntity<RB_Tenant_Extend>(NewTenantId);
                    if (extModel != null)
                    {
                        UserInfo obj = new UserInfo
                        {
                            TenantId = extModel.TenantId,
                            Account = extModel.Account,
                            Name = extModel.Name,
                            MobilePhone = extModel.MobilePhone,
                            WeChatNum = extModel.WeChatNum,
                            IsEffective = extModel.IsEffective,
                            AccountValidate = extModel.AccountValidate,
                            CreateMiniPrograme = extModel.CreateMiniPrograme,
                            //MallName = extModel.MallName,
                            AccountStatus = extModel.AccountStatus,
                            Token = token,
                            SecretKey = "",
                        };
                        UserInfoSet(UserModuleCacheKeyConfig.Mall_Login_Info + TenantId, obj, Config.JwtExpirTime);
                    }
                }
            }
            return userInfo;
        }
    }
}
