﻿using Mall.Model.Entity.BaseSetUp;
using Mall.Model.Extend.BaseSetUp;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.BaseSetUp
{
  public  class RB_LogisticsRulesPriceRepository:RepositoryBase<RB_LogisticsRulesPrice>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_LogisticsRulesPrice); } }

        /// <summary>
        /// 获取小程序列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_LogisticsRulesPrice_Extend> GetListRepository(RB_LogisticsRulesPrice_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM {TableName} WHERE 1=1 ");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_LogisticsRulesPrice_Extend.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_LogisticsRulesPrice_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (query.RulesId > 0)
                {
                    builder.Append($" AND {nameof(RB_LogisticsRulesPrice_Extend.RulesId)}={query.RulesId}");
                }
            }
            return Get<RB_LogisticsRulesPrice_Extend>(builder.ToString()).ToList();
        }
    }
}
