﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Mall.Common.API;
using Mall.Model.Entity.BaseSetUp;
using Mall.Model.Extend.BaseSetUp;
using Mall.Module.BaseSetUp;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;

namespace Mall.WebApi.Controllers.MallBase
{
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class MallBaseController : BaseController
    {

        private MallBaseModule mallBaseModule = new MallBaseModule();
        private Module.User.TenantModule TenantModule = new Module.User.TenantModule();

        #region 基础设置
        public ApiResult AddOrUpdateMallBase()
        {
            var query = JsonConvert.DeserializeObject<RB_MallBase_Extend>(RequestParm.msg.ToString());

            if (query == null)
            {
                return ApiResult.Failed("请传入需要操作的小程序");
            }
            else
            {
                query.TenantId = UserInfo.TenantId;
                if (query.ID == 0)//新增
                {
                    var TenantModel = TenantModule.GetTenantModule(query.TenantId);
                    if (TenantModel == null)
                    {
                        return ApiResult.Failed("请确保商户信息正确");
                    }
                    if (TenantModel.AccountStatus != 2)
                    {
                        return ApiResult.Failed("商户状态审核不通过");
                    }
                    if (TenantModel.IsEffective == 0 && TenantModel.AccountValidate.HasValue && TenantModel.AccountValidate.Value < System.DateTime.Now)
                    {
                        return ApiResult.Failed("商户账号已过期");
                    }
                    //判断当前商户下面有多少小程序

                    if (TenantModel.CreateMiniPrograme.HasValue)
                    {
                        var oldList = mallBaseModule.GetListRepository(query);
                        if (oldList.Count() >= TenantModel.CreateMiniPrograme.Value)
                        {
                            return ApiResult.Failed("商户可建小程序数：" + TenantModel.CreateMiniPrograme.Value);
                        }
                    }
                }
                bool result = mallBaseModule.AddOrUpdateMallBase(query);
                if (result)
                {
                    return ApiResult.Success("基础信息保存成功");
                }
                else
                {
                    return ApiResult.Failed("基础信息保存失败");
                }

            }
        }

        /// <summary>
        /// 列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetMallBasePage()
        {

            // UserInfo userInfo = UserReidsCache.GetUserLoginInfo(requestParm.uid);
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            RB_MallBase_Extend demodel = JsonConvert.DeserializeObject<RB_MallBase_Extend>(RequestParm.msg.ToString());

            demodel.TenantId = UserInfo.TenantId;

            var list = mallBaseModule.GetPageListRepository(pagelist.pageIndex, pagelist.pageSize, out long count, demodel);

            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = list.Select(x => new
            {
                x.ID,
                x.MallName,
                OrderNum = 0,
                MemberNum = 0,
                IndateStr = x.Indate.HasValue ? x.Indate.Value.ToString("yyyy-MM-dd") : "永久",
            });
            return ApiResult.Success("", pagelist);
        }

        #endregion

        #region 物流设置
        #region 物流规格-物流设置
        /// <summary>
        /// 根据商户号获取物流信息
        /// </summary>
        /// <returns></returns>
        public ApiResult GetLogistics()
        {
            var query = JsonConvert.DeserializeObject<RB_Logistics>(RequestParm.msg.ToString());
            var TenantModel = TenantModule.GetTenantModule(query.TenantId);
            query.TenantId = UserInfo.TenantId;
            var oldLogisticsModel = mallBaseModule.GetLogisticsList(query).FirstOrDefault();
            if (oldLogisticsModel == null)
            {
                oldLogisticsModel = new RB_Logistics();
                oldLogisticsModel.LogisticsType = Common.Enum.MallBase.LogisticsTypeEnum.ExpressBird;
            }
            return ApiResult.Success("", oldLogisticsModel);
        }

        /// <summary>
        /// 保存物流信息
        /// </summary>
        /// <returns></returns>
        public ApiResult AddOrUpdateLogistics()
        {
            var query = JsonConvert.DeserializeObject<RB_Logistics>(RequestParm.msg.ToString());

            if (query == null)
            {
                return ApiResult.Failed("请传入物流基础信息");
            }
            else
            {
                query.TenantId = UserInfo.TenantId;
                bool result = mallBaseModule.AddOrUpdateLogistics(query);
                if (result)
                {
                    return ApiResult.Success("物流设置信息保存成功");
                }
                else
                {
                    return ApiResult.Failed("基物流设置信息保存失败");
                }
            }
        }

        #endregion



        #endregion

    }
}