﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Mall.Common.API;
using Mall.Model.Extend.User;
using Mall.Module.User;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Mall.Common.Plugin;
using Mall.Common.Enum.User;
using Mall.CacheManager.User;
using Newtonsoft.Json.Linq;
using Mall.Common;

namespace Mall.WebApi.Controllers.MallBase
{
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class UserController : BaseController
    {

        private readonly UserModule userModule = new UserModule();

        #region 用户管理
        /// <summary>
        /// 获取用户分页列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetMemberUserPageList()
        {
            var parms = RequestParm;
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(parms.msg.ToString());
            RB_Member_User_Extend demodel = JsonConvert.DeserializeObject<RB_Member_User_Extend>(parms.msg.ToString());

            demodel.TenantId = Convert.ToInt32(parms.uid);
            var list = userModule.GetMemberUserPageList(pagelist.pageIndex, pagelist.pageSize, out long count, demodel);
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = list.Select(x => new
            {
                x.Id,
                x.AliasName,
                x.Balance,
                x.Blacklist,
                x.CardVolumeNum,
                x.ContactWay,
                x.CouponsNum,
                x.Integral,
                x.TotalConsumption,
                x.MemberGrade,
                x.MemberGradeName,
                x.Moblie,
                x.Name,
                x.OpenId,
                x.OrderNum,
                x.Photo,
                x.Remark,
                x.Source,
                SourceName = x.Source.GetEnumName(),
                x.TenantId,
                CreateDate = x.CreateDate.HasValue ? x.CreateDate.Value.ToString("yyyy-MM-dd") : ""
            });
            return ApiResult.Success("", pagelist);
        }

        /// <summary>
        /// 用户信息下载
        /// </summary>
        [HttpPost]
        public FileContentResult GetMemberUserListToExcel()
        {
            var parms = RequestParm;
            RB_Member_User_Extend demodel = JsonConvert.DeserializeObject<RB_Member_User_Extend>(parms.msg.ToString());
            string ExcelName = "用户列表" + DateTime.Now.ToString("yyyyMMddHHmmss") + ".xls";
            List<ExcelDataSource> slist = new List<ExcelDataSource>();
            if (demodel.ExcelEnumIds == null || !demodel.ExcelEnumIds.Any())
            {
                var byteData1 = ExcelTempLateHelper.ToExcelExtend(slist);
                return File(byteData1, "application/octet-stream", ExcelName);
            }
            var Enumlist = EnumHelper.GetEnumList(typeof(UserExportEnum));
            ExcelDataSource header = new ExcelDataSource()
            {
                ExcelRows = new List<ExcelColumn>(30) {
                    new ExcelColumn(value: "序号") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER }
                }
            };
            foreach (var item in demodel.ExcelEnumIds)
            {
                var Name = Enumlist.Where(x => x.Value == item.ToString()).FirstOrDefault().Key ?? "";
                header.ExcelRows.Add(new ExcelColumn(value: Name) { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER });
            }

            slist.Add(header);

            try
            {
                demodel.TenantId = Convert.ToInt32(parms.uid);
                var list = userModule.GetMemberUserList(demodel);
                #region 组装数据
                int Num = 0;
                foreach (var item in list)
                {
                    Num++;
                    ExcelDataSource datarow = new ExcelDataSource()
                    {
                        ExcelRows = new List<ExcelColumn>(30) {
                            new ExcelColumn(value:Num.ToString()){ },
                        }
                    };
                    foreach (var qitem in demodel.ExcelEnumIds)
                    {
                        switch (qitem)
                        {
                            case 1:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.Source.GetEnumName()) { }); break;
                            case 2:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.Id.ToString()) { }); break;
                            case 3:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.OpenId) { }); break;
                            case 4:
                                datarow.ExcelRows.Add(new ExcelColumn(value: (item.AliasName ?? "") != "" ? item.AliasName : item.Name) { }); break;
                            case 5:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.Moblie) { }); break;
                            case 6:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.ContactWay) { }); break;
                            case 7:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.Remark) { }); break;
                            case 8:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.CreateDate.Value.ToString("yyyy-MM-dd HH:mm:ss")) { }); break;
                            case 9:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.MemberGradeName) { }); break;
                            case 10:
                                datarow.ExcelRows.Add(new ExcelColumn(value: (item.OrderNum ?? 0).ToString()) { }); break;
                            case 11:
                                datarow.ExcelRows.Add(new ExcelColumn(value: (item.CouponsNum ?? 0).ToString()) { }); break;
                            case 12:
                                datarow.ExcelRows.Add(new ExcelColumn(value: (item.CardVolumeNum ?? 0).ToString()) { }); break;
                            case 13:
                                datarow.ExcelRows.Add(new ExcelColumn(value: (item.Integral ?? 0).ToString()) { }); break;
                            case 14:
                                datarow.ExcelRows.Add(new ExcelColumn(value: (item.Balance ?? 0).ToString()) { }); break;
                            case 15:
                                datarow.ExcelRows.Add(new ExcelColumn(value: (item.TotalConsumption ?? 0).ToString()) { }); break;
                        }
                    }
                    slist.Add(datarow);
                }
                #endregion

                var byteData = ExcelTempLateHelper.ToExcelExtend(slist);

                return File(byteData, "application/octet-stream", ExcelName);
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, string.Format("GetFileFromWebApi_requestData: {0}", JsonHelper.Serialize(RequestParm)));
                var byteData1 = ExcelTempLateHelper.ToExcelExtend(slist);
                return File(byteData1, "application/octet-stream", ExcelName);
            }

        }

        /// <summary>
        /// 获取用户下载枚举列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetMemberUserExcelEnumList() {
            var list = EnumHelper.GetEnumList(typeof(UserExportEnum));
            return ApiResult.Success("", list.Select(x => new
            {
                Name = x.Key,
                Id = Convert.ToInt32(x.Value)
            }));
        }

        /// <summary>
        /// 获取用户平台枚举列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetMemberUserSourceEnumList()
        {
            var list = EnumHelper.GetEnumList(typeof(UserSourceEnum));
            return ApiResult.Success("", list.Select(x => new
            {
                Name = x.Key,
                Id = Convert.ToInt32(x.Value)
            }));
        }

        /// <summary>
        /// 获取会员等级分页列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetMemberGradePageList() {
            var parms = RequestParm;
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(parms.msg.ToString());
            RB_Member_Grade_Extend demodel = JsonConvert.DeserializeObject<RB_Member_Grade_Extend>(parms.msg.ToString());

            demodel.TenantId = Convert.ToInt32(parms.uid);
            var list = userModule.GetMemberGradePageList(pagelist.pageIndex, pagelist.pageSize, out long count, demodel);
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = list.Select(x => new
            {
                x.Id,
                x.Name,
                x.Grade,
                x.BackgroundImage,
                x.Discount,
                x.Enabled,
                EquityList= x.EquityList.Select(x=>new { 
                    x.Id,
                    x.Content,
                    x.Image,
                    x.Title
                }),
                x.Icon,
                x.IsAutoUpGrade,
                x.IsMemberBuy,
                x.MemberBuyMoney,
                x.MemberSpecification,
                x.TenantId,
                TenantName = UserReidsCache.GetUserLoginInfo(x.TenantId)?.Name ?? "",
                x.UpGradeMoney,
                CreateDate = x.CreateDate.HasValue ? x.CreateDate.Value.ToString("yyyy-MM-dd") : ""
            });
            return ApiResult.Success("", pagelist);
        }

        /// <summary>
        /// 获取会员等级列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetMemberGradeList()
        {
            var parms = RequestParm;
            RB_Member_Grade_Extend demodel = JsonConvert.DeserializeObject<RB_Member_Grade_Extend>(parms.msg.ToString());

            demodel.TenantId = Convert.ToInt32(parms.uid);
            var list = userModule.GetMemberGradeList(demodel);
            return ApiResult.Success("", list.Select(x=>new { 
                x.Id,
                x.Grade,
                x.Name,
                x.Icon,
                x.BackgroundImage
            }));
        }

        /// <summary>
        /// 新增会员等级
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetMemberGradeInfo() {
            var parms = RequestParm;
            RB_Member_Grade_Extend demodel = JsonConvert.DeserializeObject<RB_Member_Grade_Extend>(parms.msg.ToString());
            if (demodel.MallBaseId <= 0) {
                return ApiResult.ParamIsNull("请传递小程序");
            }
            if ((demodel.Grade ?? 0) <= 0) {
                return ApiResult.ParamIsNull("请传递等级");
            }
            if (string.IsNullOrEmpty(demodel.Name)) {
                return ApiResult.ParamIsNull("请输入等级名称");
            }
            if ((demodel.Discount ?? 0) <= 0)
            {
                return ApiResult.ParamIsNull("请输入折扣率");
            }
            if ((demodel.Enabled ?? 0) <= 0) {
                return ApiResult.ParamIsNull("请选择会员状态");
            }
            if (string.IsNullOrEmpty(demodel.Icon)) {
                return ApiResult.ParamIsNull("请选择会员图标");
            }
            if (string.IsNullOrEmpty(demodel.BackgroundImage))
            {
                return ApiResult.ParamIsNull("请选择会员背景图");
            }
            if (demodel.IsAutoUpGrade == 1)
            {
                if ((demodel.UpGradeMoney ?? 0) <= 0)
                {
                    return ApiResult.ParamIsNull("请输入累计完成订单金额");
                }
            }
            else {
                demodel.IsAutoUpGrade = 2;
                demodel.UpGradeMoney = 0;
            }
            if (demodel.IsMemberBuy == 1)
            {
                if ((demodel.MemberBuyMoney ?? 0) <= 0)
                {
                    return ApiResult.ParamIsNull("请输入会员购买价格");
                }
            }
            else {
                demodel.IsMemberBuy = 2;
                demodel.MemberBuyMoney = 0;
            }

            demodel.Icon = Config.GetFilePath(demodel.Icon);
            demodel.BackgroundImage = Config.GetFilePath(demodel.BackgroundImage);
            demodel.CreateDate = DateTime.Now;
            demodel.UpdateDate = DateTime.Now;
            demodel.Status = 0;
            demodel.TenantId = Convert.ToInt32(parms.uid);
            bool flag = userModule.SetMemberGradeInfo(demodel);
            if (flag)
            {
                return ApiResult.Success();
            }
            else {
                return ApiResult.Failed();
            }
        }

        /// <summary>
        /// 删除会员等级
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult DelMemberGradeInfo() {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            int GradeId = parms.GetInt("GradeId", 0);
            if (GradeId <= 0) {
                return ApiResult.Failed("请传递参数");
            }

            bool flag = userModule.DelMemberGradeInfo(GradeId, RequestParm.uid);
            if (flag)
            {
                return ApiResult.Success();
            }
            else {
                return ApiResult.Failed();
            }
        }


        /// <summary>
        /// 获取会用户积分分页列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetMemberIntegralPageList()
        {
            var parms = RequestParm;
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(parms.msg.ToString());
            RB_Member_Integral_Extend demodel = JsonConvert.DeserializeObject<RB_Member_Integral_Extend>(parms.msg.ToString());

            demodel.TenantId = Convert.ToInt32(parms.uid);
            List<RB_Member_Integral_Extend> list = userModule.GetMemberIntegralPageList(pagelist.pageIndex, pagelist.pageSize, out long count, demodel);
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = list.Select(x => new
            {
                x.Id,
                x.Type,
                x.Description,
                x.Image,
                x.Integral,
                x.UserId,
                x.TenantId,
                TenantName = UserReidsCache.GetUserLoginInfo(x.TenantId)?.Name ?? "",
                CreateDate = x.CreateDate.HasValue ? x.CreateDate.Value.ToString("yyyy-MM-dd") : ""
            });
            return ApiResult.Success("", pagelist);
        }

        /// <summary>
        /// 新增积分
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetMemberIntegralInfo() {
            var parms = RequestParm;
            RB_Member_Integral_Extend demodel = JsonConvert.DeserializeObject<RB_Member_Integral_Extend>(parms.msg.ToString());
            if (demodel.MallBaseId <= 0) {
                return ApiResult.ParamIsNull("请传递小程序id");
            }
            if ((demodel.UserId ?? 0) <= 0) {
                return ApiResult.ParamIsNull("请传递用户id");
            }
            if (demodel.Type != 1 && demodel.Type != 2) {
                return ApiResult.ParamIsNull("请选择充值/扣除");
            }
            if ((demodel.Integral ?? 0) <= 0) {
                return ApiResult.ParamIsNull("请输入积分数");
            }

            demodel.Description = demodel.Description ?? "";
            demodel.Image = Config.GetFilePath(demodel.Image);
            demodel.TenantId = Convert.ToInt32(parms.uid);
            demodel.CreateDate = DateTime.Now;
            bool flag = userModule.SetMemberIntegralInfo(demodel);
            if (flag)
            {
                return ApiResult.Success();
            }
            else {
                return ApiResult.Failed();
            }

        }

        /// <summary>
        /// 获取会用户余额分页列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetMemberBalancePageList()
        {
            var parms = RequestParm;
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(parms.msg.ToString());
            RB_Member_Balance_Extend demodel = JsonConvert.DeserializeObject<RB_Member_Balance_Extend>(parms.msg.ToString());

            demodel.TenantId = Convert.ToInt32(parms.uid);
            List<RB_Member_Balance_Extend> list = userModule.GetMemberBalancePageList(pagelist.pageIndex, pagelist.pageSize, out long count, demodel);
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = list.Select(x => new
            {
                x.Id,
                x.Type,
                x.Description,
                x.Image,
                x.Balance,
                x.UserId,
                x.TenantId,
                TenantName = UserReidsCache.GetUserLoginInfo(x.TenantId)?.Name ?? "",
                CreateDate = x.CreateDate.HasValue ? x.CreateDate.Value.ToString("yyyy-MM-dd") : ""
            });
            return ApiResult.Success("", pagelist);
        }

        /// <summary>
        /// 新增余额
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetMemberBalanceInfo()
        {
            var parms = RequestParm;
            RB_Member_Balance_Extend demodel = JsonConvert.DeserializeObject<RB_Member_Balance_Extend>(parms.msg.ToString());
            if (demodel.MallBaseId <= 0)
            {
                return ApiResult.ParamIsNull("请传递小程序id");
            }
            if ((demodel.UserId ?? 0) <= 0)
            {
                return ApiResult.ParamIsNull("请传递用户id");
            }
            if (demodel.Type != 1 && demodel.Type != 2)
            {
                return ApiResult.ParamIsNull("请选择充值/扣除");
            }
            if ((demodel.Balance ?? 0) <= 0)
            {
                return ApiResult.ParamIsNull("请输入金额");
            }

            demodel.Description = demodel.Description ?? "";
            demodel.Image = Config.GetFilePath(demodel.Image);
            demodel.TenantId = Convert.ToInt32(parms.uid);
            demodel.CreateDate = DateTime.Now;
            bool flag = userModule.SetMemberBalanceInfo(demodel);
            if (flag)
            {
                return ApiResult.Success();
            }
            else
            {
                return ApiResult.Failed();
            }

        }
        #endregion
    }
}