﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Common;
using Mall.Common.Plugin;
using Newtonsoft.Json;
using Mall.Common.API;
using Newtonsoft.Json.Linq;
using VT.FW.DB;
using Mall.Repository.Miai;
using Mall.Model.Extend.Miai;
using Mall.Model.Entity.Education;
using Mall.Repository.TradePavilion;
using Mall.Repository.Education;
using Mall.Model.Entity.Miai;

namespace Mall.Module.Miai
{
    /// <summary>
    /// 相亲处理层
    /// </summary>
    public class MiaiModule
    {
        /// <summary>
        /// 帖子版块
        /// </summary>
        private readonly RB_Miai_ForumRepository miai_ForumRepository = new RB_Miai_ForumRepository();
        /// <summary>
        /// 帖子
        /// </summary>
        private readonly RB_Miai_ActivityRepository miai_ActivityRepository = new RB_Miai_ActivityRepository();
        /// <summary>
        /// 帖子报名
        /// </summary>
        private readonly RB_Miai_ActivityEnrollRepository miai_ActivityEnrollRepository = new RB_Miai_ActivityEnrollRepository();
        /// <summary>
        /// 帖子回复
        /// </summary>
        private readonly RB_Miai_ActivityDiscussRepository miai_ActivityDiscussRepository = new RB_Miai_ActivityDiscussRepository();
        /// <summary>
        /// 日志
        /// </summary>
        private readonly RB_Miai_LogRepository miai_LogRepository = new RB_Miai_LogRepository();
        /// <summary>
        /// 相亲约会
        /// </summary>
        private readonly RB_Miai_DatingRepository miai_DatingRepository = new RB_Miai_DatingRepository();
        /// <summary>
        /// 星球活动
        /// </summary>
        private readonly RB_Commerce_ActivityRepository commerce_ActivityRepository = new RB_Commerce_ActivityRepository();
        /// <summary>
        /// 朋友圈动态
        /// </summary>
        private readonly Rb_Education_DynamicRepository education_DynamicRepository = new Rb_Education_DynamicRepository();
        /// <summary>
        /// 通用方法
        /// </summary>
        private readonly MiaiCommonModule miaiCommonModule = new MiaiCommonModule();


        private readonly RB_MiAi_BaseInfoRepository miai_BaseInfoRepository = new RB_MiAi_BaseInfoRepository();


        private readonly RB_MiAi_FollowMemberRepository miai_FollowMemberRepository = new RB_MiAi_FollowMemberRepository();

        /// <summary>
        /// 用户管理
        /// </summary>
        private readonly Repository.User.RB_Member_UserRepository member_UserRepository = new Repository.User.RB_Member_UserRepository();

        /// <summary>
        /// 会员等级
        /// </summary>
        private readonly Repository.User.RB_Member_GradeRepository member_GradeRepository = new Repository.User.RB_Member_GradeRepository();

        /// <summary>
        /// 区域
        /// </summary>
        private readonly Repository.BaseSetUp.Rb_destinationRepository destinationRepository = new Repository.BaseSetUp.Rb_destinationRepository();


        private readonly RB_MiAi_BaseInfoQueryRepository miAiBaseInfoQueryRepository = new RB_MiAi_BaseInfoQueryRepository();

        #region 会员信息
        /// <summary>
        /// 获取用户信息
        /// </summary>
        /// <param name="userId"></param>
        /// <returns></returns>
        public Model.Extend.User.RB_Member_User_Extend GetMemberUserInfo(int userId)
        {
            return member_UserRepository.GetEntity(userId).RefMapperTo<Model.Extend.User.RB_Member_User_Extend>();
        }
        #endregion

        #region 消息通知
        /// <summary>
        /// 获取消息中心
        /// </summary>
        /// <param name="userId"></param>
        /// <param name="tenantId"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public object GetMiaiMessageCenter(int userId, int tenantId, int mallBaseId)
        {
            //获取四种分类数量
            int Num1 = miaiCommonModule.GetMessageNum(new RB_Miai_Message_Extend() { TenantId = tenantId, MallBaseId = mallBaseId, UserId = userId, SelectType = 1 });
            var message1 = miaiCommonModule.GetNewMessageInfo(new RB_Miai_Message_Extend() { TenantId = tenantId, MallBaseId = mallBaseId, UserId = userId, SelectType = 1 });
            int Num2 = miaiCommonModule.GetMessageNum(new RB_Miai_Message_Extend() { TenantId = tenantId, MallBaseId = mallBaseId, UserId = userId, SelectType = 2 });
            var message2 = miaiCommonModule.GetNewMessageInfo(new RB_Miai_Message_Extend() { TenantId = tenantId, MallBaseId = mallBaseId, UserId = userId, SelectType = 2 });
            int Num3 = miaiCommonModule.GetMessageNum(new RB_Miai_Message_Extend() { TenantId = tenantId, MallBaseId = mallBaseId, UserId = userId, SelectType = 3 });
            var message3 = miaiCommonModule.GetNewMessageInfo(new RB_Miai_Message_Extend() { TenantId = tenantId, MallBaseId = mallBaseId, UserId = userId, SelectType = 3 });
            int Num4 = miaiCommonModule.GetMessageNum(new RB_Miai_Message_Extend() { TenantId = tenantId, MallBaseId = mallBaseId, UserId = userId, SelectType = 4 });
            var message4 = miaiCommonModule.GetNewMessageInfo(new RB_Miai_Message_Extend() { TenantId = tenantId, MallBaseId = mallBaseId, UserId = userId, SelectType = 4 });

            return new
            {
                CircleModel = new
                {
                    Num = Num1,
                    Title = "圈子",
                    Description = GetMiaiMessageDescription(message1),
                    Time = message1 != null ? message1.CreateDate.ToString("yyyy-MM-dd HH:mm") : ""
                },
                SystemModel = new
                {
                    Num = Num4,
                    Title = "系统消息",
                    Description = GetMiaiMessageDescription(message4),
                    Time = message4 != null ? message4.CreateDate.ToString("yyyy-MM-dd HH:mm") : ""
                },
                PPPlusModel = new
                {
                    Num = Num2,
                    Title = "拼拼Plus",
                    Description = GetMiaiMessageDescription(message2),
                    Time = message2 != null ? message2.CreateDate.ToString("yyyy-MM-dd HH:mm") : ""
                },
                VisitorModel = new
                {
                    Num = Num3,
                    Title = "访客",
                    Description = GetMiaiMessageDescription(message3),
                    Time = message3 != null ? message3.CreateDate.ToString("yyyy-MM-dd HH:mm") : ""
                }
            };
        }

        /// <summary>
        /// 获取访客数据统计
        /// </summary>
        /// <param name="userId"></param>
        /// <param name="tenantId"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public object GetMiaiMessageVisitorStatistics(int userId, int type, int tenantId, int mallBaseId)
        {
            var model = miaiCommonModule.GetMiaiMessageVisitorStatistics(userId, type, tenantId, mallBaseId);
            return new
            {
                model.TCount,
                model.PeopleNum
            };
        }

        /// <summary>
        /// 获取访客分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Miai_Message_Extend> GetMiaiMessageVisitorPageList(int pageIndex, int pageSize, out long count, RB_Miai_Message_Extend demodel)
        {
            var list = miaiCommonModule.GetPageList(pageIndex, pageSize, out count, demodel);
            if (list.Any())
            {
                string userIds = "";
                if (demodel.VsisitorType == 1)
                {
                    userIds = string.Join(",", list.Select(x => x.CreateBy).Distinct());
                }
                else
                {
                    userIds = string.Join(",", list.Select(x => x.UserId).Distinct());
                }
                var blist = miai_BaseInfoRepository.GetFirstBaseInfoList(new RB_MiAi_BaseInfo_Extend() { TenantId = demodel.TenantId, UserIds = userIds });
                foreach (var item in list)
                {
                    var bmodel = blist.Where(x => x.UserId == (demodel.VsisitorType == 1 ? item.CreateBy : item.UserId)).FirstOrDefault();
                    item.Name = bmodel?.Name ?? "";
                    item.Photo = bmodel?.Photo ?? "";
                    item.Sex = bmodel?.Sex ?? 0;
                }
            }
            return list;
        }

        /// <summary>
        /// 获取消息描述
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public string GetMiaiMessageDescription(RB_Miai_Message_Extend model)
        {
            if (model == null) { return ""; }
            switch (model.Type)
            {
                case Common.Enum.MiAi.MessageTypeEnum.CircleLike:
                    return "有新用户给你点赞";
                case Common.Enum.MiAi.MessageTypeEnum.CircleReply:
                    return "有新消息回复";
                case Common.Enum.MiAi.MessageTypeEnum.Look:
                    return "有新用户查看了你";
                case Common.Enum.MiAi.MessageTypeEnum.SpellComment:
                    return "有新消息评论";
                case Common.Enum.MiAi.MessageTypeEnum.SpellReply:
                    return "有新消息回复";
                case Common.Enum.MiAi.MessageTypeEnum.SpellEnroll:
                    return "有新用户报名";
                case Common.Enum.MiAi.MessageTypeEnum.SpellEnrollCancel:
                    return "有用户取消报名";
                case Common.Enum.MiAi.MessageTypeEnum.ViolationNotice:
                    return "有新违规通知";
                case Common.Enum.MiAi.MessageTypeEnum.ActivityCancel:
                    return "有活动报名被取消";
                case Common.Enum.MiAi.MessageTypeEnum.FollowMember:
                    return "有新用户关注了你";
                default:
                    return "";
            }
        }

        /// <summary>
        /// 获取消息通知
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Miai_Message_Extend> GetMiaiMessagePageList(int pageIndex, int pageSize, out long count, RB_Miai_Message_Extend demodel)
        {
            var list = miaiCommonModule.GetPageList(pageIndex, pageSize, out count, demodel);
            if (list.Any())
            {

                //每种类型 额外返回数据
                #region 拼拼活动
                var activityList = list.Where(x => x.Type == Common.Enum.MiAi.MessageTypeEnum.SpellEnroll || x.Type == Common.Enum.MiAi.MessageTypeEnum.SpellEnrollCancel
                  || x.Type == Common.Enum.MiAi.MessageTypeEnum.SpellComment || x.Type == Common.Enum.MiAi.MessageTypeEnum.SpellReply).ToList();
                List<RB_Miai_Activity_Extend> ActivityList = new List<RB_Miai_Activity_Extend>();
                if (activityList.Any())
                {
                    string ActivityIds = string.Join(",", activityList.Select(x => x.SourceId).Distinct());
                    ActivityList = miai_ActivityRepository.GetList(new RB_Miai_Activity_Extend() { TenantId = demodel.TenantId, ActivityIds = ActivityIds });
                }
                #endregion
                #region 星球活动
                var commerceList = list.Where(x => x.Type == Common.Enum.MiAi.MessageTypeEnum.ActivityCancel).ToList();
                List<Model.Extend.TradePavilion.RB_Commerce_Activity_Extend> CommerceList = new List<Model.Extend.TradePavilion.RB_Commerce_Activity_Extend>();
                if (commerceList.Any())
                {
                    string ActivityIds = string.Join(",", commerceList.Select(x => x.SourceId).Distinct());
                    CommerceList = commerce_ActivityRepository.GetList(new Model.Extend.TradePavilion.RB_Commerce_Activity_Extend() { TenantId = demodel.TenantId, ActivityIds = ActivityIds });
                }
                #endregion
                #region 圈子
                var circleList = list.Where(x => x.Type == Common.Enum.MiAi.MessageTypeEnum.CircleLike || x.Type == Common.Enum.MiAi.MessageTypeEnum.CircleReply).ToList();
                List<Model.Extend.Education.Rb_Education_Dynamic_Extend> CircleList = new List<Model.Extend.Education.Rb_Education_Dynamic_Extend>();
                if (circleList.Any())
                {
                    string CircleIds = string.Join(",", circleList.Select(x => x.SourceId).Distinct());
                    CircleList = education_DynamicRepository.GetMiAiAllDynamicList(new Model.Extend.Education.Rb_Education_Dynamic_Extend() { TenantId = demodel.TenantId, Ids = CircleIds });
                }
                #endregion
                #region 查询创建人
                string UserIds = string.Join(",", list.Select(x => x.CreateBy).Distinct());
                var blist = miai_BaseInfoRepository.GetFirstBaseInfoList(new RB_MiAi_BaseInfo_Extend() { TenantId = demodel.TenantId, UserIds = UserIds });


                var userList = member_UserRepository.GetList(new Model.Extend.User.RB_Member_User_Extend { TenantId = demodel.TenantId, UserIds = UserIds });
                #endregion
                foreach (var item in list)
                {
                    if (item.Type == Common.Enum.MiAi.MessageTypeEnum.SpellEnroll || item.Type == Common.Enum.MiAi.MessageTypeEnum.SpellEnrollCancel
                        || item.Type == Common.Enum.MiAi.MessageTypeEnum.SpellComment || item.Type == Common.Enum.MiAi.MessageTypeEnum.SpellReply)
                    {
                        item.ReplyContent = ActivityList.Where(x => x.Id == item.SourceId).Select(x => new
                        {
                            x.Id,
                            x.ActivityTitle,
                            x.Label,
                            x.UserName,
                            x.Photo,
                            x.Sex,
                            ImageList = !string.IsNullOrEmpty(x.Images) && x.Images != "[]" ? JsonConvert.DeserializeObject<List<string>>(x.Images) : new List<string>()
                        });
                    }
                    if (item.Type == Common.Enum.MiAi.MessageTypeEnum.ActivityCancel)
                    {
                        item.ReplyContent = CommerceList.Where(x => x.Id == item.SourceId).Select(x => new
                        {
                            x.Id,
                            x.ActivityName,
                            x.CoverImg
                        });
                    }
                    if (item.Type == Common.Enum.MiAi.MessageTypeEnum.CircleLike || item.Type == Common.Enum.MiAi.MessageTypeEnum.CircleReply)
                    {
                        item.ReplyContent = CircleList.Where(x => x.Id == item.SourceId).Select(x => new
                        {
                            x.Id,
                            Content = StringHelper.FromUnicodeString(x.Content),
                            x.Files,
                            x.CreateTime,
                            x.CoverPhoto,
                            x.FileType,
                            x.Seconds,
                            x.CreateByName,
                            x.CrearteByPhoto
                        });
                    }

                    var bmodel = blist.Where(x => x.UserId == item.CreateBy).FirstOrDefault();

                    var userModel = userList.Where(x => x.Id == item.CreateBy).FirstOrDefault();
                    item.Name = userModel?.Name ?? "";
                    item.Photo = userModel?.Photo ?? "";
                    item.Sex = bmodel?.Sex ?? 0;
                }
            }
            return list;
        }

        /// <summary>
        /// 删除消息
        /// </summary>
        /// <param name="Id"></param>
        /// <returns></returns>
        public bool DelMiaiMessageInfo(int Id)
        {
            return miaiCommonModule.DelMessage(Id);
        }

        /// <summary>
        /// 批量清除消息
        /// </summary>
        /// <param name="type"></param>
        /// <param name="userInfo"></param>
        /// <returns></returns>
        public bool DelMiaiMessageInfoBatch(string type, AppletUserInfo userInfo)
        {
            return miaiCommonModule.DelMiaiMessageInfoBatch(type, userInfo);
        }

        #endregion

        #region 相亲约会

        /// <summary>
        /// 相亲约会记录分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Miai_Dating_Extend> GetMiaiDatingPageList(int pageIndex, int pageSize, out long count, RB_Miai_Dating_Extend demodel)
        {
            var list = miai_DatingRepository.GetPageList(pageIndex, pageSize, out count, demodel);
            return list;
        }

        /// <summary>
        /// 新增/修改相亲约会记录
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public bool SetMiaiDatingInfo(RB_Miai_Dating_Extend demodel)
        {
            if (demodel.Id > 0)
            {
                Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                    { nameof(RB_Miai_Dating_Extend.ManId),demodel.ManId},
                    { nameof(RB_Miai_Dating_Extend.WoManId),demodel.WoManId},
                    { nameof(RB_Miai_Dating_Extend.Time),demodel.Time},
                    { nameof(RB_Miai_Dating_Extend.Address),demodel.Address},
                    { nameof(RB_Miai_Dating_Extend.Remark),demodel.Remark},
                    { nameof(RB_Miai_Dating_Extend.UpdateDate),demodel.UpdateDate},
                };
                List<WhereHelper> wheres = new List<WhereHelper>() {
                    new WhereHelper(){
                         FiledName=nameof(RB_Miai_Dating_Extend.Id),
                          FiledValue=demodel.Id,
                           OperatorEnum=OperatorEnum.Equal
                    }
                };
                return miai_DatingRepository.Update(keyValues, wheres);
            }
            else
            {
                return miai_DatingRepository.Insert(demodel) > 0;
            }
        }

        /// <summary>
        /// 删除相亲约会记录
        /// </summary>
        /// <param name="datingId"></param>
        /// <returns></returns>
        public bool DelMiaiDatingInfo(int datingId)
        {
            Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                { nameof(RB_Miai_Dating_Extend.Status),1},
                { nameof(RB_Miai_Dating_Extend.UpdateDate),DateTime.Now},
            };
            List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_Miai_Dating_Extend.Id),
                        FiledValue=datingId,
                        OperatorEnum=OperatorEnum.Equal
                }
            };
            return miai_DatingRepository.Update(keyValues, wheres);
        }

        #endregion

        #region 活动版块
        /// <summary>
        /// 获取活动版本分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Miai_Forum_Extend> GetForumPageList(int pageIndex, int pageSize, out long count, RB_Miai_Forum_Extend dmodel)
        {
            return miai_ForumRepository.GetPageList(pageIndex, pageSize, out count, dmodel);
        }

        /// <summary>
        /// 获取活动版块列表
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Miai_Forum_Extend> GetForumList(RB_Miai_Forum_Extend demodel)
        {
            return miai_ForumRepository.GetList(demodel);
        }

        /// <summary>
        /// 保存活动版块
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public bool SetForumInfo(RB_Miai_Forum_Extend demodel)
        {
            if (demodel.Id > 0)
            {
                Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                    { nameof(RB_Miai_Forum_Extend.Name),demodel.Name},
                    { nameof(RB_Miai_Forum_Extend.Icon),demodel.Icon},
                    { nameof(RB_Miai_Forum_Extend.Sort),demodel.Sort},
                    { nameof(RB_Miai_Forum_Extend.IsShow),demodel.IsShow},
                    { nameof(RB_Miai_Forum_Extend.UpdateDate),demodel.UpdateDate},
                };
                List<WhereHelper> wheres = new List<WhereHelper>() {
                    new WhereHelper(){
                         FiledName=nameof(RB_Miai_Forum_Extend.Id),
                          FiledValue=demodel.Id,
                           OperatorEnum=OperatorEnum.Equal
                    }
                };
                bool flag = miai_ForumRepository.Update(keyValues, wheres);
                return flag;
            }
            else
            {
                bool flag = miai_ForumRepository.Insert(demodel) > 0;
                return flag;
            }
        }

        /// <summary>
        /// 设置版块状态
        /// </summary>
        /// <param name="forumId"></param>
        /// <param name="type"></param>
        /// <returns></returns>
        public bool SetForumState(int forumId, int type)
        {
            if (type == 1)
            {
                var model = miai_ForumRepository.GetEntity(forumId);
                if (model == null) { return false; }
                Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                    { nameof(RB_Miai_Forum_Extend.IsShow),model.IsShow==1?2:1},
                    { nameof(RB_Miai_Forum_Extend.UpdateDate),DateTime.Now},
                };
                List<WhereHelper> wheres = new List<WhereHelper>() {
                    new WhereHelper(){
                         FiledName=nameof(RB_Miai_Forum_Extend.Id),
                          FiledValue=forumId,
                           OperatorEnum=OperatorEnum.Equal
                    }
                };
                bool flag = miai_ForumRepository.Update(keyValues, wheres);
                return flag;
            }
            else
            {
                Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                    { nameof(RB_Miai_Forum_Extend.Status),1},
                    { nameof(RB_Miai_Forum_Extend.UpdateDate),DateTime.Now},
                };
                List<WhereHelper> wheres = new List<WhereHelper>() {
                    new WhereHelper(){
                         FiledName=nameof(RB_Miai_Forum_Extend.Id),
                          FiledValue=forumId,
                           OperatorEnum=OperatorEnum.Equal
                    }
                };
                bool flag = miai_ForumRepository.Update(keyValues, wheres);
                return flag;
            }
        }

        /// <summary>
        /// 获取活动分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Miai_Activity_Extend> GetActivityPageList(int pageIndex, int pageSize, out long count, RB_Miai_Activity_Extend demodel)
        {
            var list = miai_ActivityRepository.GetPageList(pageIndex, pageSize, out count, demodel);
            if (list.Any())
            {
                string ActivityIds = string.Join(",", list.Select(x => x.Id));
                //查询活动回复数量
                var rlist = miai_ActivityDiscussRepository.GetActivityReplyNumList(ActivityIds);
                //查询活动报名数量
                var elist = miai_ActivityEnrollRepository.GetActivityEnrollNumList(ActivityIds);
                //查询版本信息
                string ForumIds = string.Join(",", list.Select(x => x.ForumId).Distinct());
                var flist = miai_ForumRepository.GetList(new RB_Miai_Forum_Extend() { ForumIds = ForumIds });
                foreach (var item in list)
                {
                    item.ImageList = new List<string>();
                    if (!string.IsNullOrEmpty(item.Images) && item.Images != "[]")
                    {
                        item.ImageList = JsonConvert.DeserializeObject<List<string>>(item.Images);
                    }
                    item.ReplyNum = rlist.Where(x => x.ActivityId == item.Id).FirstOrDefault()?.ReplyNum ?? 0;
                    item.EnrollNum = elist.Where(x => x.ActivityId == item.Id).FirstOrDefault()?.Number ?? 0;
                    var fmodel = flist.Where(x => x.Id == item.ForumId).FirstOrDefault();
                    item.ForumName = fmodel?.Name ?? "";
                    item.ForumIcon = fmodel?.Icon ?? "";
                }
            }
            return list;
        }

        /// <summary>
        /// 获取活动信息
        /// </summary>
        /// <param name="activityId"></param>
        /// <param name="userInfo"></param>
        /// <returns></returns>
        public object GetActivityInfo(int activityId, AppletUserInfo userInfo)
        {
            var model = miai_ActivityRepository.GetEntity(activityId);
            if (model == null) { return ""; }
            //获取活动报名人数
            int ManENum = miai_ActivityEnrollRepository.GetActivityEnrollNum(activityId, 1);
            int WoManENum = miai_ActivityEnrollRepository.GetActivityEnrollNum(activityId, 1);
            int PeopleNum = ManENum + WoManENum;
            //获取当前用户是否已报名
            bool IsEnroll = false;
            if (userInfo.UserId > 0)
            {
                IsEnroll = miai_ActivityEnrollRepository.GetList(new RB_Miai_ActivityEnroll_Extend() { TenantId = model.TenantId, ActivityId = activityId, UserId = userInfo.UserId }).Any();
            }
            //查询活动回复数量
            var rlist = miai_ActivityDiscussRepository.GetActivityReplyNumList(activityId.ToString());
            var umodel = CacheManager.User.UserReidsCache.GetAppletUserLoginInfo(model.UserId);
            //查询用户性别
            int Sex = miai_BaseInfoRepository.GetBaseInfoList(new RB_MiAi_BaseInfo_Extend() { TenantId = userInfo.TenantId, UserId = model.UserId }).FirstOrDefault()?.Sex ?? 0;
            //查询当前用户是否已关注
            bool IsFocus = false, IsFocus2 = false;
            List<RB_MiAi_FollowMember_Extend> myFollowList = new List<RB_MiAi_FollowMember_Extend>();
            List<RB_MiAi_FollowMember_Extend> otherFollowList = new List<RB_MiAi_FollowMember_Extend>();
            if (userInfo.UserId > 0)
            {
                myFollowList = miai_FollowMemberRepository.GetFollowMemberList(new RB_MiAi_FollowMember_Extend() { TenantId = userInfo.TenantId, UserId = model.UserId, CreateBy = userInfo.UserId });
                IsFocus = myFollowList.Any();
                otherFollowList = miai_FollowMemberRepository.GetFollowMemberList(new RB_MiAi_FollowMember_Extend() { TenantId = userInfo.TenantId, UserId = userInfo.UserId, CreateBy = model.UserId });
                //查询是否已关注我
                IsFocus2 = otherFollowList.Any();
            }
            return new
            {
                model.Id,
                model.ActivityTitle,
                model.Content,
                ImageList = !string.IsNullOrEmpty(model.Images) ? JsonConvert.DeserializeObject<List<string>>(model.Images) : new List<string>() { },
                LabelList = !string.IsNullOrEmpty(model.Label) ? JsonConvert.DeserializeObject<List<string>>(model.Label) : new List<string>() { },
                model.UserId,
                UserName = umodel.Name,
                umodel.Photo,
                Sex,
                model.IsOpenEnroll,
                model.Label,
                StartTime = model.StartTime.ToString("yyyy-MM-dd HH:mm"),
                EndTime = model.EndTime.ToString("yyyy-MM-dd HH:mm"),
                model.ManNum,
                ManENum,
                model.WoManNum,
                WoManENum,
                model.LonLat,
                model.LocationName,
                Deadline = model.IsOpenEnroll == 1 ? model.Deadline.Value.ToString("yyyy-MM-dd HH:mm") : "",
                CreateDate = model.CreateDate.ToString("yyyy-MM-dd HH:mm:ss"),
                PeopleNum,
                IsEnroll,
                IsFocus = IsFocus == true && IsFocus2 == true ? 2 : IsFocus == true ? 1 : 0,
                ReplyNum = rlist.FirstOrDefault()?.ReplyNum ?? 0,
                MyFollowId = (myFollowList != null && myFollowList.Any()) ? myFollowList.FirstOrDefault()?.ID : 0,
                OtherFollowId = (otherFollowList != null && otherFollowList.Any()) ? otherFollowList.FirstOrDefault()?.ID : 0
            };
        }

        /// <summary>
        /// 后台获取活动信息
        /// </summary>
        /// <param name="activityId"></param>
        /// <returns></returns>
        public object GetActivityInfo_V2(int activityId)
        {
            var model = miai_ActivityRepository.GetEntity(activityId);
            if (model == null) { return ""; }
            //获取活动报名人数
            int PeopleNum = miai_ActivityEnrollRepository.GetActivityEnrollNum(activityId);
            //查询活动回复数量
            var rlist = miai_ActivityDiscussRepository.GetActivityReplyNumList(activityId.ToString());
            var umodel = CacheManager.User.UserReidsCache.GetAppletUserLoginInfo(model.UserId);
            return new
            {
                model.Id,
                model.ActivityTitle,
                model.Content,
                ImageList = !string.IsNullOrEmpty(model.Images) ? JsonConvert.DeserializeObject<List<string>>(model.Images) : new List<string>() { },
                model.UserId,
                UserName = umodel.Name,
                umodel.Photo,
                model.IsOpenEnroll,
                model.Label,
                StartTime = model.StartTime.ToString("yyyy-MM-dd HH:mm"),
                EndTime = model.EndTime.ToString("yyyy-MM-dd HH:mm"),
                model.ManNum,
                model.WoManNum,
                model.LonLat,
                model.LocationName,
                Deadline = model.IsOpenEnroll == 1 ? model.Deadline.Value.ToString("yyyy-MM-dd HH:mm") : "",
                CreateDate = model.CreateDate.ToString("yyyy-MM-dd HH:mm:ss"),
                PeopleNum,
                ReplyNum = rlist.FirstOrDefault()?.ReplyNum ?? 0
            };
        }

        /// <summary>
        /// 发帖招募
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public bool SetActivityInfo(RB_Miai_Activity_Extend demodel, out string msg)
        {
            msg = "";
            if (demodel.Id > 0)
            {
                var model = miai_ActivityRepository.GetEntity(demodel.Id);
                if (model == null || model.Status == 1) { msg = "活动不存在"; return false; }
                if (model.UserId != demodel.UserId) { msg = "无法修改活动"; return false; }
                int ManPeopleNum = miai_ActivityEnrollRepository.GetActivityEnrollNum(demodel.Id, 1);
                int WoManPeopleNum = miai_ActivityEnrollRepository.GetActivityEnrollNum(demodel.Id, 2);
                if (demodel.ManNum < ManPeopleNum) { msg = "男已报名" + ManPeopleNum + "人、不能低于此数量"; return false; }
                if (demodel.WoManNum < WoManPeopleNum) { msg = "女已报名" + ManPeopleNum + "人、不能低于此数量"; return false; }
                Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                    { nameof(RB_Miai_Activity_Extend.ActivityTitle),demodel.ActivityTitle},
                    { nameof(RB_Miai_Activity_Extend.Content),demodel.Content},
                    { nameof(RB_Miai_Activity_Extend.Images),demodel.Images},
                    { nameof(RB_Miai_Activity_Extend.IsOpenEnroll),demodel.IsOpenEnroll},
                    { nameof(RB_Miai_Activity_Extend.Deadline),demodel.Deadline},
                    { nameof(RB_Miai_Activity_Extend.Label),demodel.Label},
                    { nameof(RB_Miai_Activity_Extend.StartTime),demodel.StartTime},
                    { nameof(RB_Miai_Activity_Extend.EndTime),demodel.EndTime},
                    { nameof(RB_Miai_Activity_Extend.ManNum),demodel.ManNum},
                    { nameof(RB_Miai_Activity_Extend.WoManNum),demodel.WoManNum},
                    { nameof(RB_Miai_Activity_Extend.LonLat),demodel.LonLat},
                    { nameof(RB_Miai_Activity_Extend.LocationName),demodel.LocationName},
                    { nameof(RB_Miai_Activity_Extend.UpdateDate),demodel.UpdateDate}
                };
                List<WhereHelper> wheres = new List<WhereHelper>() {
                    new WhereHelper(){
                         FiledName=nameof(RB_Miai_Activity_Extend.Id),
                          FiledValue=demodel.Id,
                           OperatorEnum=OperatorEnum.Equal
                    }
                };
                return miai_ActivityRepository.Update(keyValues, wheres);
            }
            else
            {
                return miai_ActivityRepository.Insert(demodel) > 0;
            }
        }

        /// <summary>
        /// 删除招募贴
        /// </summary>
        /// <param name="activityId"></param>
        /// <param name="userInfo"></param>
        /// <returns></returns>
        public string DelActivityInfo(int activityId, AppletUserInfo userInfo)
        {
            var model = miai_ActivityRepository.GetEntity(activityId);
            if (model == null || model.Status == 1) { return "帖子不存在或已被删除"; }
            if (model.UserId != userInfo.UserId) { return "没有权限删除"; }
            Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                { nameof(RB_Miai_Activity_Extend.Status),1},
                { nameof(RB_Miai_Activity_Extend.UpdateDate),DateTime.Now}
            };
            List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_Miai_Activity_Extend.Id),
                        FiledValue=activityId,
                        OperatorEnum=OperatorEnum.Equal
                }
            };
            bool flag = miai_ActivityRepository.Update(keyValues, wheres);
            if (flag)
            {
                miai_LogRepository.Insert(new Model.Entity.Miai.RB_Miai_Log()
                {
                    Id = 0,
                    Type = 1,
                    SourceId = activityId,
                    UserId = userInfo.UserId,
                    Content = "用户自行删除招募贴",
                    EmpId = 0,
                    TenantId = userInfo.TenantId,
                    MallBaseId = userInfo.MallBaseId,
                    CreateDate = DateTime.Now
                });
            }
            return flag ? "" : "出错了，请联系管理员";
        }

        /// <summary>
        /// 后台删除帖子
        /// </summary>
        /// <param name="activityId"></param>
        /// <param name="empId"></param>
        /// <returns></returns>
        public string DelActivityInfo_V2(int activityId, int empId, int TenantId, int MallBaseId)
        {
            Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                { nameof(RB_Miai_Activity_Extend.Status),1},
                { nameof(RB_Miai_Activity_Extend.UpdateDate),DateTime.Now}
            };
            List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_Miai_Activity_Extend.Id),
                        FiledValue=activityId,
                        OperatorEnum=OperatorEnum.Equal
                }
            };
            bool flag = miai_ActivityRepository.Update(keyValues, wheres);
            if (flag)
            {
                miai_LogRepository.Insert(new Model.Entity.Miai.RB_Miai_Log()
                {
                    Id = 0,
                    Type = 1,
                    SourceId = activityId,
                    UserId = 0,
                    Content = "后台删除招募贴",
                    EmpId = empId,
                    TenantId = TenantId,
                    MallBaseId = MallBaseId,
                    CreateDate = DateTime.Now
                });
            }
            return flag ? "" : "出错了，请联系管理员";
        }

        /// <summary>
        /// 获取活动评论分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Miai_ActivityDiscuss_Extend> GetActivityDiscussPageList(int pageIndex, int pageSize, out long count, RB_Miai_ActivityDiscuss_Extend demodel)
        {
            demodel.ParentId = -1;//查询主评论
            var list = miai_ActivityDiscussRepository.GetPageList(pageIndex, pageSize, out count, demodel);
            if (list.Any())
            {
                //查询评论下  前几条回复记录
                List<int> PidsList = list.Select(x => x.Id).ToList();
                var clist = miai_ActivityDiscussRepository.GetActivityDiscussChildList(PidsList, 4);
                //查询评论回复数量
                var rlist = miai_ActivityDiscussRepository.GetDiscussReplyNumList(string.Join(",", PidsList));
                foreach (var item in list)
                {
                    item.ReplyList = clist.Where(x => x.ParentId == item.Id).OrderBy(x => x.Id).ToList();
                    item.ReplyNum = rlist.Where(x => x.ParentId == item.Id).FirstOrDefault()?.ReplyNum ?? 0;
                    item.ImageList = new List<string>();
                    if (!string.IsNullOrEmpty(item.Images) && item.Images != "[]")
                    {
                        item.ImageList = JsonConvert.DeserializeObject<List<string>>(item.Images);
                    }
                    foreach (var qitem in item.ReplyList)
                    {
                        qitem.ImageList = new List<string>();
                        if (!string.IsNullOrEmpty(qitem.Images) && qitem.Images != "[]")
                        {
                            qitem.ImageList = JsonConvert.DeserializeObject<List<string>>(qitem.Images);
                        }
                    }
                }
            }
            return list;
        }



        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Miai_ActivityDiscuss_Extend> GetActivityDiscussList(RB_Miai_ActivityDiscuss_Extend dmodel)
        {
            return miai_ActivityDiscussRepository.GetList(dmodel);
        }

        /// <summary>
        /// 获取评论回复分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Miai_ActivityDiscuss_Extend> GetActivityReplyPageList(int pageIndex, int pageSize, out long count, RB_Miai_ActivityDiscuss_Extend demodel)
        {
            var list = miai_ActivityDiscussRepository.GetPageList(pageIndex, pageSize, out count, demodel);
            foreach (var qitem in list)
            {
                qitem.ImageList = new List<string>();
                if (!string.IsNullOrEmpty(qitem.Images) && qitem.Images != "[]")
                {
                    qitem.ImageList = JsonConvert.DeserializeObject<List<string>>(qitem.Images);
                }
            }
            return list;
        }

        /// <summary>
        /// 设置评论
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public bool SetActivityDiscussInfo(RB_Miai_ActivityDiscuss_Extend demodel)
        {
            if (demodel.Id > 0)
            {
                var model = miai_ActivityDiscussRepository.GetEntity(demodel.Id);
                if (model == null || model.Status == 1) { return false; }
                if (model.UserId != demodel.UserId) { return false; }
                Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                    { nameof(RB_Miai_ActivityDiscuss_Extend.Content),demodel.Content},
                    { nameof(RB_Miai_ActivityDiscuss_Extend.Images),demodel.Images},
                    { nameof(RB_Miai_ActivityDiscuss_Extend.UpdateDate),demodel.UpdateDate}
                };
                List<WhereHelper> wheres = new List<WhereHelper>() {
                    new WhereHelper(){
                         FiledName=nameof(RB_Miai_ActivityDiscuss_Extend.Id),
                          FiledValue=demodel.Id,
                           OperatorEnum=OperatorEnum.Equal
                    }
                };
                return miai_ActivityDiscussRepository.Update(keyValues, wheres);
            }
            else
            {
                bool flag = miai_ActivityDiscussRepository.Insert(demodel) > 0;
                if (flag)
                {
                    var model = miai_ActivityRepository.GetEntity(demodel.ActivityId);
                    if (model != null && model.UserId != demodel.UserId)
                    {
                        if (demodel.ReplyUserId == 0)
                        {
                            //设置消息推送
                            miaiCommonModule.SetMessage(new RB_Miai_Message_Extend()
                            {
                                Id = 0,
                                Type = Common.Enum.MiAi.MessageTypeEnum.SpellComment,
                                UserId = model.UserId,
                                SourceId = demodel.ActivityId,
                                Content = demodel.Content,
                                Status = 0,
                                TenantId = demodel.TenantId,
                                MallBaseId = demodel.MallBaseId,
                                CreateBy = demodel.UserId,
                                CreateDate = DateTime.Now,
                                UpdateDate = DateTime.Now
                            });
                        }
                        else
                        {
                            //设置消息推送
                            miaiCommonModule.SetMessage(new RB_Miai_Message_Extend()
                            {
                                Id = 0,
                                Type = Common.Enum.MiAi.MessageTypeEnum.SpellReply,
                                UserId = model.UserId,
                                SourceId = demodel.ActivityId,
                                Content = demodel.Content,
                                Status = 0,
                                TenantId = demodel.TenantId,
                                MallBaseId = demodel.MallBaseId,
                                CreateBy = demodel.UserId,
                                CreateDate = DateTime.Now,
                                UpdateDate = DateTime.Now
                            });
                            miaiCommonModule.SetMessage(new RB_Miai_Message_Extend()
                            {
                                Id = 0,
                                Type = Common.Enum.MiAi.MessageTypeEnum.SpellReply,
                                UserId = demodel.ReplyUserId,
                                SourceId = demodel.ActivityId,
                                Content = demodel.Content,
                                Status = 0,
                                TenantId = demodel.TenantId,
                                MallBaseId = demodel.MallBaseId,
                                CreateBy = demodel.UserId,
                                CreateDate = DateTime.Now,
                                UpdateDate = DateTime.Now
                            });
                        }
                    }
                }
                return flag;
            }
        }

        /// <summary>
        /// 删除回复
        /// </summary>
        /// <param name="discussId"></param>
        /// <param name="userInfo"></param>
        /// <returns></returns>
        public string DelActivityDiscussInfo(int discussId, AppletUserInfo userInfo)
        {
            var model = miai_ActivityDiscussRepository.GetEntity(discussId);
            if (model == null || model.Status == 1) { return "回复不存在或已被删除"; }
            if (model.UserId != userInfo.UserId) { return "没有权限删除"; }
            Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                { nameof(RB_Miai_ActivityDiscuss_Extend.Status),1},
                { nameof(RB_Miai_ActivityDiscuss_Extend.UpdateDate),DateTime.Now}
            };
            List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_Miai_ActivityDiscuss_Extend.Id),
                        FiledValue=discussId,
                        OperatorEnum=OperatorEnum.Equal
                }
            };
            bool flag = miai_ActivityDiscussRepository.Update(keyValues, wheres);
            if (flag)
            {
                miai_LogRepository.Insert(new Model.Entity.Miai.RB_Miai_Log()
                {
                    Id = 0,
                    Type = 2,
                    SourceId = discussId,
                    UserId = userInfo.UserId,
                    Content = "用户自行删除评论",
                    EmpId = 0,
                    TenantId = userInfo.TenantId,
                    MallBaseId = userInfo.MallBaseId,
                    CreateDate = DateTime.Now
                });
            }
            return flag ? "" : "出错了，请联系管理员";
        }

        /// <summary>
        /// 后台删除回复
        /// </summary>
        /// <param name="discussId"></param>
        /// <param name="empId"></param>
        /// <returns></returns>
        public string DelActivityDiscussInfo_V2(int discussId, int empId, int TenantId, int MallBaseId)
        {
            Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                { nameof(RB_Miai_ActivityDiscuss_Extend.Status),1},
                { nameof(RB_Miai_ActivityDiscuss_Extend.UpdateDate),DateTime.Now}
            };
            List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_Miai_ActivityDiscuss_Extend.Id),
                        FiledValue=discussId,
                        OperatorEnum=OperatorEnum.Equal
                }
            };
            bool flag = miai_ActivityDiscussRepository.Update(keyValues, wheres);
            if (flag)
            {
                miai_LogRepository.Insert(new Model.Entity.Miai.RB_Miai_Log()
                {
                    Id = 0,
                    Type = 2,
                    SourceId = discussId,
                    UserId = 0,
                    Content = "用户自行删除评论",
                    EmpId = empId,
                    TenantId = TenantId,
                    MallBaseId = MallBaseId,
                    CreateDate = DateTime.Now
                });
            }
            return flag ? "" : "出错了，请联系管理员";
        }

        /// <summary>
        /// 获取报名分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Miai_ActivityEnroll_Extend> GetActivityEnrollPageList(int pageIndex, int pageSize, out long count, RB_Miai_ActivityEnroll_Extend demodel, AppletUserInfo userInfo)
        {
            var list = miai_ActivityEnrollRepository.GetPageList(pageIndex, pageSize, out count, demodel);
            if (list.Any())
            {
                string UserIds = string.Join(",", list.Select(x => x.UserId).Distinct());
                //查询当前用户是否已关注
                var flist = miai_FollowMemberRepository.GetFollowMemberList(new RB_MiAi_FollowMember_Extend() { TenantId = userInfo.TenantId, UserIds = UserIds, CreateBy = userInfo.UserId });
                //查询是否已关注我
                var flist2 = miai_FollowMemberRepository.GetFollowMemberList(new RB_MiAi_FollowMember_Extend() { TenantId = userInfo.TenantId, UserId = userInfo.UserId, CreateByIds = UserIds });
                foreach (var item in list)
                {
                    item.IsFocus = flist.Where(x => x.UserId == item.UserId).Any() ? 1 : 0;
                    if (flist2.Where(x => x.CreateBy == item.UserId).Any() && item.IsFocus == 1)
                    {
                        item.IsFocus = 2;
                    }
                    item.MyFollowId = (flist != null && flist.Any()) ? (flist.FirstOrDefault()?.ID ?? 0) : 0;
                    item.OtherFollowId = (flist2 != null && flist2.Any()) ? (flist2.FirstOrDefault()?.ID ?? 0) : 0;
                }
            }
            return list;
        }

        /// <summary>
        /// 获取报名分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Miai_ActivityEnroll_Extend> GetActivityEnrollPageList_V2(int pageIndex, int pageSize, out long count, RB_Miai_ActivityEnroll_Extend demodel)
        {
            return miai_ActivityEnrollRepository.GetPageList(pageIndex, pageSize, out count, demodel);
        }

        /// <summary>
        /// 活动报名
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public string SetActivityEnrollInfo(RB_Miai_ActivityEnroll_Extend demodel)
        {
            var list = miai_ActivityEnrollRepository.GetList(new RB_Miai_ActivityEnroll_Extend() { TenantId = demodel.TenantId, ActivityId = demodel.ActivityId, UserId = demodel.UserId });
            if (list.Any()) { return "已存在报名信息"; }
            var model = miai_ActivityRepository.GetEntity(demodel.ActivityId);
            if (model == null || model.Status == 1) { return "活动不存在"; }
            if (model.IsOpenEnroll != 1) { return "无法报名"; }
            if (model.Deadline <= DateTime.Now)
            {
                return "已过了报名时间，无法报名";
            }
            var bmodel = miai_BaseInfoRepository.GetBaseInfoList(new RB_MiAi_BaseInfo_Extend() { TenantId = demodel.TenantId, UserId = demodel.UserId }).FirstOrDefault();
            if (bmodel == null) { return "资料未认证，无法报名"; }
            if (bmodel.Sex == 1)
            {
                int ManPeopleNum = miai_ActivityEnrollRepository.GetActivityEnrollNum(demodel.Id, 1);
                if (model.ManNum <= ManPeopleNum) { return "已报满，无法报名"; }
            }
            else if (bmodel.Sex == 2)
            {
                int WoManPeopleNum = miai_ActivityEnrollRepository.GetActivityEnrollNum(demodel.Id, 2);
                if (model.WoManNum <= WoManPeopleNum) { return "已报满，无法报名"; }
            }
            else
            {
                return "性别未维护，无法报名";
            }
            bool flag = miai_ActivityEnrollRepository.Insert(demodel) > 0;
            if (flag)
            {
                if (model.UserId != demodel.UserId)
                {
                    //设置消息推送
                    miaiCommonModule.SetMessage(new RB_Miai_Message_Extend()
                    {
                        Id = 0,
                        Type = Common.Enum.MiAi.MessageTypeEnum.SpellEnroll,
                        UserId = model.UserId,
                        SourceId = demodel.ActivityId,
                        Content = "新用户报名拼拼Plus",
                        Status = 0,
                        TenantId = demodel.TenantId,
                        MallBaseId = demodel.MallBaseId,
                        CreateBy = demodel.UserId,
                        CreateDate = DateTime.Now,
                        UpdateDate = DateTime.Now
                    });
                }
            }
            return flag ? "" : "出错了，请联系管理员";
        }

        /// <summary>
        /// 取消报名
        /// </summary>
        /// <param name="enrollId"></param>
        /// <param name="userInfo"></param>
        /// <returns></returns>
        public string CancelActivityEnrollInfo(int enrollId, AppletUserInfo userInfo)
        {
            var model = miai_ActivityEnrollRepository.GetEntity(enrollId);
            if (model == null || model.Status == 1) { return "已取消报名"; }
            if (model.UserId != userInfo.UserId) { return "没有取消权限"; }
            var amodel = miai_ActivityRepository.GetEntity(model.ActivityId);
            if (amodel == null || amodel.Status == 1) { return "帖子已被删除"; }
            if (amodel.IsOpenEnroll != 1) { return "无法取消报名"; }
            if (amodel.Deadline <= DateTime.Now)
            {
                return "已过了报名时间，无法报名";
            }
            Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                { nameof(RB_Miai_ActivityEnroll_Extend.Status),1 },
                { nameof(RB_Miai_ActivityEnroll_Extend.UpdateDate),DateTime.Now },
            };
            List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper(){
                     FiledName=nameof(RB_Miai_ActivityEnroll_Extend.Id),
                      FiledValue=enrollId,
                       OperatorEnum=OperatorEnum.Equal
                }
            };

            bool flag = miai_ActivityEnrollRepository.Update(keyValues, wheres);
            if (flag)
            {
                if (amodel.UserId != model.UserId)
                {
                    //设置消息推送
                    miaiCommonModule.SetMessage(new RB_Miai_Message_Extend()
                    {
                        Id = 0,
                        Type = Common.Enum.MiAi.MessageTypeEnum.SpellEnrollCancel,
                        UserId = amodel.UserId,
                        SourceId = model.ActivityId,
                        Content = "用户取消报名拼拼plus",
                        Status = 0,
                        TenantId = model.TenantId,
                        MallBaseId = model.MallBaseId,
                        CreateBy = model.UserId,
                        CreateDate = DateTime.Now,
                        UpdateDate = DateTime.Now
                    });
                }
            }
            return flag ? "" : "出错了，请联系管理员";
        }

        /// <summary>
        /// 获取招募贴我的报名记录
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Miai_ActivityEnroll_Extend> GetMyEnrollPageList(int pageIndex, int pageSize, out long count, RB_Miai_ActivityEnroll_Extend demodel)
        {
            var list = miai_ActivityEnrollRepository.GetMyEnrollPageList(pageIndex, pageSize, out count, demodel);
            if (list.Any())
            {
                string ActivityIds = string.Join(",", list.Select(x => x.ActivityId).Distinct());
                //查询活动帖子
                var alist = miai_ActivityRepository.GetList(new RB_Miai_Activity_Extend() { TenantId = demodel.TenantId, ActivityIds = ActivityIds }, true);
                //查询活动报名数量
                var elist = miai_ActivityEnrollRepository.GetActivityEnrollNumList(ActivityIds);
                foreach (var item in alist)
                {
                    item.ImageList = new List<string>();
                    if (!string.IsNullOrEmpty(item.Images) && item.Images != "[]")
                    {
                        item.ImageList = JsonConvert.DeserializeObject<List<string>>(item.Images);
                    }
                    item.EnrollNum = elist.Where(x => x.ActivityId == item.Id).FirstOrDefault()?.Number ?? 0;
                }
                foreach (var item in list)
                {
                    item.ActivityModel = alist.Where(x => x.Id == item.ActivityId).FirstOrDefault();
                }
            }
            return list;
        }
        #endregion

        #region 会员基础信息


        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<RB_MiAi_BaseInfo_Extend> GetBaseInfoList(RB_MiAi_BaseInfo_Extend where)
        {
            var list = miai_BaseInfoRepository.GetBaseInfoList(where);
            return list;
        }



        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="where"></param>
        /// <returns></returns>
        public RB_MiAi_BaseInfo_Extend GetBaseInfoModel(RB_MiAi_BaseInfo_Extend where)
        {
            var model = miai_BaseInfoRepository.GetBaseInfoList(where).FirstOrDefault();
            if (model != null && (model.Province > 0 || model.City > 0 || model.District > 0))
            {
                string areaIds = (model.Province ?? 0) + "," + (model.City ?? 0) + "," + (model.District ?? 0);
                var arealist = destinationRepository.GetDictvalueListForIds(areaIds);

                model.PName = (model.Province.HasValue && model.Province.Value > 0) ? (arealist.Where(x => x.ID == model.Province).FirstOrDefault()?.Name ?? "") : "";
                model.CName = (model.City.HasValue && model.City.Value > 0) ? (arealist.Where(x => x.ID == model.City).FirstOrDefault()?.Name ?? "") : "";
                model.DName = (model.District.HasValue && model.District.Value > 0) ? (arealist.Where(x => x.ID == model.District).FirstOrDefault()?.Name ?? "") : "";
            }

            return model;
        }



        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<RB_MiAi_BaseInfo_Extend> GetBaseInfoPageList(int pageIndex, int pageSize, out long rowsCount, RB_MiAi_BaseInfo_Extend where)
        {
            return miai_BaseInfoRepository.GetBaseInfoPageList(pageIndex, pageSize, out rowsCount, where);
        }

        /// <summary>
        /// 新增用户的基础信息
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool SetMiAiBaseInfo(RB_MiAi_BaseInfo_Extend model)
        {
            bool flag = false;
            if (model.Id == 0)
            {
                flag = miai_BaseInfoRepository.Insert(model) > 0;
            }
            else
            {
                Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                        { nameof(RB_MiAi_BaseInfo_Extend.Sex),model.Sex},
                        { nameof(RB_MiAi_BaseInfo_Extend.Weight),model.Weight},
                        { nameof(RB_MiAi_BaseInfo_Extend.Height),model.Height},
                        { nameof(RB_MiAi_BaseInfo_Extend.EducationType),model.EducationType},
                        { nameof(RB_MiAi_BaseInfo_Extend.City),model.City},
                        { nameof(RB_MiAi_BaseInfo_Extend.Province),model.Province},
                        { nameof(RB_MiAi_BaseInfo_Extend.District),model.District},
                        { nameof(RB_MiAi_BaseInfo_Extend.Marriage),model.Marriage},
                        { nameof(RB_MiAi_BaseInfo_Extend.SchoolInfo),model.SchoolInfo},
                        { nameof(RB_MiAi_BaseInfo_Extend.Job),model.Job},
                        { nameof(RB_MiAi_BaseInfo_Extend.WorkUnit),model.WorkUnit},
                        { nameof(RB_MiAi_BaseInfo_Extend.YearMoney),model.YearMoney},
                        { nameof(RB_MiAi_BaseInfo_Extend.HouseInfo),model.HouseInfo},
                        { nameof(RB_MiAi_BaseInfo_Extend.OtherInfo),model.OtherInfo},
                        { nameof(RB_MiAi_BaseInfo_Extend.CarInfo),model.CarInfo},
                        { nameof(RB_MiAi_BaseInfo_Extend.FamilyInfo),model.FamilyInfo},
                        { nameof(RB_MiAi_BaseInfo_Extend.Hobby),model.Hobby},
                        { nameof(RB_MiAi_BaseInfo_Extend.LikeFood),model.LikeFood},
                        { nameof(RB_MiAi_BaseInfo_Extend.LikeBook),model.LikeBook},
                        { nameof(RB_MiAi_BaseInfo_Extend.LikeTV),model.LikeTV},
                        { nameof(RB_MiAi_BaseInfo_Extend.LikeSong),model.LikeSong},
                        { nameof(RB_MiAi_BaseInfo_Extend.IdealLove),model.IdealLove},
                        { nameof(RB_MiAi_BaseInfo_Extend.LoveTalk),model.LoveTalk},
                        { nameof(RB_MiAi_BaseInfo_Extend.SingleReason),model.SingleReason},
                        { nameof(RB_MiAi_BaseInfo_Extend.About),model.About},
                        { nameof(RB_MiAi_BaseInfo_Extend.HopeYou),model.HopeYou},
                        { nameof(RB_MiAi_BaseInfo_Extend.Album),model.Album},
                        { nameof(RB_MiAi_BaseInfo_Extend.Appointment),model.Appointment},
                        { nameof(RB_MiAi_BaseInfo_Extend.AppointmentAddress),model.AppointmentAddress},
                        { nameof(RB_MiAi_BaseInfo_Extend.IDCard),model.IDCard},
                         { nameof(RB_MiAi_BaseInfo_Extend.IDCardBack),model.IDCardBack},
                        { nameof(RB_MiAi_BaseInfo_Extend.IDCardNo),model.IDCardNo},
                        { nameof(RB_MiAi_BaseInfo_Extend.ActivityRegion),model.ActivityRegion}
                    };
                List<WhereHelper> wheres = new List<WhereHelper>() {
                        new WhereHelper(){
                             FiledName=nameof(RB_MiAi_BaseInfo_Extend.Id),
                              FiledValue=model.Id,
                               OperatorEnum=OperatorEnum.Equal
                        }
                    };

                flag = miai_BaseInfoRepository.Update(keyValues, wheres);
            }
            return flag;
        }


        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<RB_MiAi_BaseInfo_Extend> GetFirstBaseInfoPageList(int pageIndex, int pageSize, out long rowsCount, RB_MiAi_BaseInfo_Extend where)
        {
            return miai_BaseInfoRepository.GetFirstBaseInfoPageList(pageIndex, pageSize, out rowsCount, where);
        }

        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<RB_MiAi_BaseInfo_Extend> GetFirstBaseInfoPageList_V2(int pageIndex, int pageSize, out long rowsCount, RB_MiaiMember_Extend where)
        {
            return miai_BaseInfoRepository.GetFirstBaseInfoPageList_V2(pageIndex, pageSize, out rowsCount, where);
        }



        

        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<RB_MiAi_BaseInfo_Extend> GetFirstBaseInfoList(RB_MiAi_BaseInfo_Extend where)
        {
            return miai_BaseInfoRepository.GetFirstBaseInfoList(where);
        }




        /// <summary>
        /// 首页插件匹配分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<RB_MiAi_BaseInfo_Extend> GetMatchingBaseInfoList(RB_MiaiMember_Extend where, int Top)
        {
            return miai_BaseInfoRepository.GetMatchingBaseInfoList(where, Top);
        }
        #endregion

        #region 我的粉丝/我的关注
        /// <summary>
        /// 新增/修改我关注的会员配置
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool AddOrUpdateFollowMember(RB_MiAi_FollowMember model, RB_MiAi_BaseInfo_Extend baseInfo)
        {
            bool flag = false;
            try
            {
                int Id = 0;
                bool isFollowNum = false;
                if (model.ID == 0)
                {
                    Id = miai_FollowMemberRepository.Insert(model);
                    flag = Id > 0;
                    baseInfo.FollowNum += 1;
                    isFollowNum = true;
                }
                else
                {
                    Id = model.ID;
                    Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                        { nameof(RB_Education_FollowTeacher.UpdateDate),System.DateTime.Now},
                        { nameof(RB_Education_FollowTeacher.Status),model.Status}
                    };
                    List<WhereHelper> wheres = new List<WhereHelper>() {
                        new WhereHelper(){
                             FiledName=nameof(RB_MiAi_FollowMember.ID),
                              FiledValue=model.ID,
                               OperatorEnum=OperatorEnum.Equal
                        }
                    };
                    if (model.Status == 1)//取消关注
                    {
                        baseInfo.FollowNum -= 1;
                    }
                    else
                    {
                        baseInfo.FollowNum += 1;
                        isFollowNum = true;
                    }
                    flag = miai_FollowMemberRepository.Update(keyValues, wheres);
                }
                if (flag)
                {

                    Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                        { nameof(RB_MiAi_BaseInfo_Extend.FollowNum),baseInfo.FollowNum}
                    };
                    List<WhereHelper> wheres = new List<WhereHelper>() {
                        new WhereHelper(){
                             FiledName=nameof(RB_MiAi_BaseInfo_Extend.Id),
                              FiledValue=baseInfo.Id,
                               OperatorEnum=OperatorEnum.Equal
                        }
                    };
                    miai_BaseInfoRepository.Update(keyValues, wheres);
                    if (isFollowNum && Id > 0)
                    {
                        //设置消息推送
                        miaiCommonModule.SetMessage(new RB_Miai_Message_Extend()
                        {
                            Id = 0,
                            Type = Common.Enum.MiAi.MessageTypeEnum.FollowMember,
                            UserId = model.UserId,
                            SourceId = Id,
                            Content = "又有新用户偷偷关注你了您",
                            Status = 0,
                            TenantId = model.TenantId,
                            MallBaseId = model.MallBaseId,
                            CreateBy = model.CreateBy,
                            CreateDate = DateTime.Now,
                            UpdateDate = DateTime.Now
                        });
                    }

                }
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "AddOrUpdateFollowMember");
                return false;
            }
            return flag;
        }


        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<RB_MiAi_FollowMember_Extend> GetFollowMemberList(RB_MiAi_FollowMember_Extend where)
        {
            return miai_FollowMemberRepository.GetFollowMemberList(where);
        }

        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<RB_MiAi_FollowMember_Extend> GetFollowMemberPageList(int pageIndex, int pageSize, out long rowsCount, RB_MiAi_FollowMember_Extend where)
        {
            var list = miai_FollowMemberRepository.GetFollowMemberPageList(pageIndex, pageSize, out rowsCount, where);

            if (list != null && list.Any())
            {
                string createByIds = string.Join(",", list.Select(x => x.UserId));
                var fansList = miai_FollowMemberRepository.GetFollowMemberList(new RB_MiAi_FollowMember_Extend { TenantId = where.TenantId, MallBaseId = where.MallBaseId, UserId = where.CreateBy, CreateByIds = createByIds });
                foreach (var item in list)
                {
                    item.IsMutualFollow = fansList.Where(x => x.CreateBy == item.UserId).Count();
                    if (item.IsMutualFollow > 0)
                    {
                        item.MutualFollowId = fansList.Where(x => x.CreateBy == item.UserId).FirstOrDefault().ID;
                    }

                }
            }
            return list;
        }

        /// <summary>
        /// 我的粉丝分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<RB_MiAi_FollowMember_Extend> GetFollowFansPageList(int pageIndex, int pageSize, out long rowsCount, RB_MiAi_FollowMember_Extend where)
        {
            var list = miai_FollowMemberRepository.GetFollowFansPageList(pageIndex, pageSize, out rowsCount, where);
            if (list != null && list.Any())
            {
                string createByIds = string.Join(",", list.Select(x => x.CreateBy));
                var fansList = miai_FollowMemberRepository.GetFollowMemberList(new RB_MiAi_FollowMember_Extend { TenantId = where.TenantId, MallBaseId = where.MallBaseId, CreateBy = where.UserId, UserIds = createByIds });
                foreach (var item in list)
                {
                    item.IsMutualFollow = fansList.Where(x => x.UserId == item.CreateBy).Count();
                    if (item.IsMutualFollow > 0)
                    {
                        item.MutualFollowId = fansList.Where(x => x.UserId == item.CreateBy).FirstOrDefault().ID;
                    }
                }
            }
            return list;
        }



        #endregion


        #region 会员信息

        /// <summary>
        /// 获取用户分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<Model.Extend.User.RB_Member_MiaiUser_Extend> GetMemberUserPageList(int pageIndex, int pageSize, out long count, Model.Extend.User.RB_Member_MiaiUser_Extend dmodel)
        {
            var list = member_UserRepository.GetMiAiPageList(pageIndex, pageSize, out count, dmodel);
            if (list.Any())
            {
                List<Model.Extend.User.RB_Member_Grade_Extend> gradeList = new List<Model.Extend.User.RB_Member_Grade_Extend>();
                if (list.Where(x => x.MemberGrade > 0).Any())
                {
                    var gradeIds = string.Join(",", list.Where(x => x.MemberGrade > 0).Select(x => x.MemberGrade ?? 0));
                    gradeList = member_GradeRepository.GetList(new Model.Extend.User.RB_Member_Grade_Extend() { GradeIds = gradeIds, TenantId = dmodel.TenantId, MallBaseId = dmodel.MallBaseId });
                }
                foreach (var item in list)
                {
                    if (item.MemberGrade > 0)
                    {
                        item.MemberGradeName = gradeList.Where(x => x.Id == item.MemberGrade).FirstOrDefault()?.Name ?? "";
                    }
                    else
                    {
                        item.MemberGradeName = "普通会员";
                    }
                }
            }
            return list;
        }




        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<Model.Extend.User.RB_Member_MiaiUser_Extend> GetMiAiList(Model.Extend.User.RB_Member_MiaiUser_Extend dmodel)
        {
            var list = member_UserRepository.GetMiAiList( dmodel);
            if (list.Any())
            {
                List<Model.Extend.User.RB_Member_Grade_Extend> gradeList = new List<Model.Extend.User.RB_Member_Grade_Extend>();
                if (list.Where(x => x.MemberGrade > 0).Any())
                {
                    var gradeIds = string.Join(",", list.Where(x => x.MemberGrade > 0).Select(x => x.MemberGrade ?? 0));
                    gradeList = member_GradeRepository.GetList(new Model.Extend.User.RB_Member_Grade_Extend() { GradeIds = gradeIds, TenantId = dmodel.TenantId, MallBaseId = dmodel.MallBaseId });
                }
                foreach (var item in list)
                {
                    if (item.MemberGrade > 0)
                    {
                        item.MemberGradeName = gradeList.Where(x => x.Id == item.MemberGrade).FirstOrDefault()?.Name ?? "";
                    }
                    else
                    {
                        item.MemberGradeName = "普通会员";
                    }
                }
            }
            return list;
        }


        /// <summary>
        /// 后台修改用户信息
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public bool SetMemberUserInfoForHT(Model.Extend.User.RB_Member_User_Extend demodel)
        {
            Dictionary<string, object> files = new Dictionary<string, object>() {
                { nameof(Model.Entity.User.RB_Member_User.MemberGrade),demodel.MemberGrade},
                { nameof(Model.Entity.User.RB_Member_User.SuperiorId),demodel.SuperiorId},
                { nameof(Model.Entity.User.RB_Member_User.ContactWay),demodel.ContactWay},
                { nameof(Model.Entity.User.RB_Member_User.Remark),demodel.Remark},
                { nameof(Model.Entity.User.RB_Member_User.AliasName),demodel.AliasName},
                { nameof(Model.Entity.User.RB_Member_User.UpdateDate),demodel.UpdateDate},
                { nameof(Model.Entity.User.RB_Member_User.PostId),demodel.PostId},
                { nameof(Model.Entity.User.RB_Member_User.Blacklist),demodel.Blacklist},
            };
            List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper(){
                    FiledName=nameof(Model.Entity.User.RB_Member_User.Id),
                    FiledValue=demodel.Id,
                    OperatorEnum=OperatorEnum.Equal
                }
            };
            bool flag = member_UserRepository.Update(files, wheres);
            if (flag)
            {
                //清除黑名单缓存
                var userInfo = new AppletUserInfo
                {
                    MallBaseId = demodel.MallBaseId,
                    UserId = demodel.Id,
                    TenantId = demodel.TenantId,
                    Name = demodel.Name,
                    SuperiorId = demodel.SuperiorId ?? 0,
                    Blacklist = demodel.Blacklist
                };
                CacheManager.User.UserReidsCache.AppletUserInfoSet(CacheKey.UserModuleCacheKeyConfig.Applet_Blacklist_Info + demodel.Id, userInfo, Config.JwtExpirTime);
            }
            return flag;
        }

        #endregion


        #region 会员基础查询信息
        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<RB_MiAi_BaseInfoQuery> GetBaseInfoQueryList(RB_MiAi_BaseInfoQuery where)
        {
            return miAiBaseInfoQueryRepository.GetBaseInfoQueryList(where);
        }


        /// <summary>
        /// 新增/修改会员基础信息查询条件信息
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool SetMiAiBaseInfoQuery(RB_MiAi_BaseInfoQuery model)
        {


            if (model.Id == 0)
            {
                return miAiBaseInfoQueryRepository.Insert(model) > 0;
            }
            else
            {

                Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                    { nameof(RB_MiAi_BaseInfoQuery.Age),model.Age},
                    { nameof(RB_MiAi_BaseInfoQuery.EndAge),model.EndAge},
                    { nameof(RB_MiAi_BaseInfoQuery.Weight),model.Weight},
                    { nameof(RB_MiAi_BaseInfoQuery.EndWeight),model.EndWeight},
                    { nameof(RB_MiAi_BaseInfoQuery.Height),model.Height},
                    { nameof(RB_MiAi_BaseInfoQuery.EndHeight),model.EndHeight},
                    { nameof(RB_MiAi_BaseInfoQuery.YearMoney),model.YearMoney},
                    { nameof(RB_MiAi_BaseInfoQuery.EndYearMoney),model.EndYearMoney},
                    { nameof(RB_MiAi_BaseInfoQuery.EducationType),model.EducationType},
                    { nameof(RB_MiAi_BaseInfoQuery.CarInfo),model.CarInfo},
                    { nameof(RB_MiAi_BaseInfoQuery.Marriage),model.Marriage},
                    { nameof(RB_MiAi_BaseInfoQuery.HouseInfo),model.HouseInfo},
                };
                List<WhereHelper> wheres = new List<WhereHelper>() {
                    new WhereHelper(){
                         FiledName=nameof(RB_MiAi_BaseInfoQuery.Id),
                          FiledValue=model.Id,
                           OperatorEnum=OperatorEnum.Equal
                    }
                };
                return miAiBaseInfoQueryRepository.Update(keyValues, wheres);
            }
        }

        #endregion
    }
}
