﻿using Mall.Model.Entity.Education;
using Mall.Model.Extend.Education;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.Education
{
    /// <summary>
    /// 资讯评论仓储层
    /// </summary>
    public class RB_Education_ArticleCommentRepository : BaseRepository<RB_Education_ArticleComment>
    {

        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_Education_ArticleComment); } }
        /// <summary>
        /// 获取分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Education_ArticleComment_Extend> GetPageList(int pageIndex, int pageSize, out long count, RB_Education_ArticleComment_Extend dmodel)
        {
            string where = $" 1=1 and c.{nameof(RB_Education_ArticleComment.Status)}=0 ";
            if (dmodel.TenantId > 0)
            {
                where += $@" and c.{nameof(RB_Education_ArticleComment.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and c.{nameof(RB_Education_ArticleComment.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.ID > 0)
            {
                where += $@" and c.{nameof(RB_Education_ArticleComment.ID)}={dmodel.ID}";
            }
            if (dmodel.UserId > 0)
            {
                where += $@" and c.{nameof(RB_Education_ArticleComment.UserId)}={dmodel.UserId}";
            }
            if (dmodel.CommentGrade > 0)
            {
                where += $@" and c.{nameof(RB_Education_ArticleComment.CommentGrade)}={(int)dmodel.CommentGrade}";
            }
            if (dmodel.ArticleId > 0)
            {
                where += $@" and c.{nameof(RB_Education_ArticleComment.ArticleId)}={dmodel.ArticleId}";
            }
            if (dmodel.PlatformSource > 0)
            {
                where += $@" and c.{nameof(RB_Education_ArticleComment.PlatformSource)}={(int)dmodel.PlatformSource}";
            }
            if (!string.IsNullOrEmpty(dmodel.UserName))
            {
                where += $@" and c.{nameof(RB_Education_ArticleComment.UserName)} like '%{dmodel.UserName}%'";
            }
            if (!string.IsNullOrEmpty(dmodel.ArticleName))
            {
                where += $@" and g.{nameof(RB_Education_Article.Name)} like '%{dmodel.ArticleName}%'";
            }
            if (!string.IsNullOrEmpty(dmodel.Content))
            {
                where += $@" and c.{nameof(RB_Education_ArticleComment.Content)} like '%{dmodel.Content}%'";
            }
            if (!string.IsNullOrEmpty(dmodel.StartTime))
            {
                where += $@" and g.{nameof(RB_Education_ArticleComment.CreateDate)} >='{dmodel.StartTime}'";
            }
            if (!string.IsNullOrEmpty(dmodel.EndTime))
            {
                where += $@" and g.{nameof(RB_Education_ArticleComment.CreateDate)} <='{dmodel.EndTime + " 23:59:59"}'";
            }
            string sql = $@"SELECT c.*,g.Name as ArticleName FROM {TableName} c
left join rb_education_article g on c.ArticleId = g.Id
where {where} order by c.Id desc";
            return GetPage<RB_Education_ArticleComment_Extend>(pageIndex, pageSize, out count, sql).ToList();
        }
    }
}
