﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Common.Enum;
using Mall.Model.Entity.TradePavilion;
using Mall.Model.Extend.TradePavilion;
using VT.FW.DB.Dapper;

namespace Mall.Repository.TradePavilion
{
    /// <summary>
    /// 品牌信息仓储层
    /// </summary>
    public class RB_CompanyBrandRepository:BaseRepository<RB_CompanyBrand>
    {
        /// <summary>
        /// 获取品牌信息分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_CompanyBrand_Extend> GetBrandPageListRepository(int pageIndex, int pageSize, out long rowsCount, RB_CompanyBrand_Extend query)
        {
            rowsCount = 0;
            DynamicParameters parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT * 
FROM RB_CompanyBrand
WHERE 1=1
");
            builder.AppendFormat(" AND {0}={1} ", nameof(RB_CompanyBrand_Extend.Status), (int)DateStateEnum.Normal);
            if (query == null)
            {
                return new List<RB_CompanyBrand_Extend>();
            }
            else
            {
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_CompanyBrand_Extend.TenantId), query.TenantId);
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_CompanyBrand_Extend.MallBaseId), query.MallBaseId);
                }
                if (!string.IsNullOrEmpty(query.BrandName))
                {
                    builder.AppendFormat(" AND {0} LIKE @Name ", nameof(RB_CompanyBrand_Extend.BrandName));
                    parameters.Add("Name", "%" + query.BrandName.Trim() + "%");
                }
            }
            return GetPage<RB_CompanyBrand_Extend>(pageIndex, pageSize, out rowsCount, builder.ToString(), parameters).ToList();
        }

        /// <summary>
        /// 根据查询条件获取品牌信息实体
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public RB_CompanyBrand_Extend GetBrandRepository(RB_CompanyBrand_Extend query)
        {
            DynamicParameters parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT * 
FROM RB_CompanyBrand
WHERE 1=1
");
            builder.AppendFormat(" AND {0}={1} ", nameof(RB_CompanyBrand_Extend.Status), (int)DateStateEnum.Normal);
            if (query == null)
            {
                return new RB_CompanyBrand_Extend();
            }
            else
            {
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_CompanyBrand_Extend.TenantId), query.TenantId);
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_CompanyBrand_Extend.MallBaseId), query.MallBaseId);
                }
                if (!string.IsNullOrEmpty(query.BrandName))
                {
                    builder.AppendFormat(" AND {0} LIKE @Name ", nameof(RB_CompanyBrand_Extend.BrandName));
                    parameters.Add("Name", "%" + query.BrandName.Trim() + "%");
                }
                if (query.CompanyId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_CompanyBrand_Extend.CompanyId), query.CompanyId);
                }
                if (!string.IsNullOrWhiteSpace(query.CompanyIds))
                {
                    builder.AppendFormat(" AND {0} in({1})", nameof(RB_CompanyBrand_Extend.CompanyId), query.CompanyIds);
                }
            }
            return Get<RB_CompanyBrand_Extend>(builder.ToString(), parameters).FirstOrDefault();
        }


        /// <summary>
        /// 根据查询条件获取品牌信息
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_CompanyBrand_Extend> GetBrandList(RB_CompanyBrand_Extend query)
        {
            DynamicParameters parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT * 
FROM RB_CompanyBrand
WHERE 1=1
");
            builder.AppendFormat(" AND {0}={1} ", nameof(RB_CompanyBrand_Extend.Status), (int)DateStateEnum.Normal);
            if (query == null)
            {
                return new List<RB_CompanyBrand_Extend>();
            }
            else
            {
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_CompanyBrand_Extend.TenantId), query.TenantId);
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_CompanyBrand_Extend.MallBaseId), query.MallBaseId);
                }
                if (!string.IsNullOrEmpty(query.BrandName))
                {
                    builder.AppendFormat(" AND {0} LIKE @Name ", nameof(RB_CompanyBrand_Extend.BrandName));
                    parameters.Add("Name", "%" + query.BrandName.Trim() + "%");
                }
                if (query.CompanyId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_CompanyBrand_Extend.CompanyId), query.CompanyId);
                }
                if (!string.IsNullOrWhiteSpace(query.CompanyIds))
                {
                    builder.AppendFormat(" AND {0} in({1})", nameof(RB_CompanyBrand_Extend.CompanyId), query.CompanyIds);
                }
            }
            return Get<RB_CompanyBrand_Extend>(builder.ToString(), parameters).ToList();
        }
    }
}
