﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.User;
using Mall.Model.Extend.User;
using System.Linq;
using VT.FW.DB.Dapper;

namespace Mall.Repository.User
{
    /// <summary>
    /// 插件表仓储层
    /// </summary>
    public class RB_PlugInRepository:BaseRepository<RB_PlugIn>
    {
        /// <summary>
        /// 根据查询条件获取插件列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_PlugIn_Extend> GetListRepository(RB_PlugIn_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append(@" 
SELECT A.* 
FROM RB_PlugIn AS A
WHERE 1=1 AND A.Status=0 ");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(@" AND A.PlugId IN(SELECT PlugId FROM rb_tenant_plug WHERE TenantId={0}) ", query.TenantId);
                }
            }
            return Get<RB_PlugIn_Extend>(builder.ToString()).ToList();
        }

        /// <summary>
        /// 根据查询条件获取插件分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_PlugIn_Extend> GetPlugInPageRepository(int pageIndex,int pageSize,out long rowsCount, RB_PlugIn_Extend query)
        {
            var parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.Append(" SELECT * FROM RB_PlugIn WHERE 1=1  ");
            if (query != null)
            {
                if (query.Status > -1)
                {
                    builder.AppendFormat(@" AND {0}={1} ", nameof(RB_PlugIn_Extend.Status), query.Status);
                }
                if (!string.IsNullOrEmpty(query.Name))
                {
                    builder.AppendFormat(@" AND {0} LIKE @Name ", nameof(RB_PlugIn_Extend.Name), query.Status);
                    parameters.Add("Name", "%" + query.Name.Trim() + "%");
                }
                if (query.PlugType > 0)
                {
                    builder.AppendFormat(@" AND {0}={1} ", nameof(RB_PlugIn_Extend.PlugType), query.PlugType);
                }
                if (query.PlugId > 0)
                {
                    builder.AppendFormat(@" AND {0}={1} ", nameof(RB_PlugIn_Extend.PlugId), query.PlugId);
                }
            }
            return GetPage<RB_PlugIn_Extend>(pageIndex,pageSize,out rowsCount,builder.ToString(),parameters).ToList();
        }
    }
}
