﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Mall.Common.API;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Mvc;
using Mall.Model.Extend.User;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using JWT;
using Mall.Common;
using JWT.Algorithms;
using JWT.Serializers;
using Mall.Common.Enum;
using Mall.CacheManager.User;
using Mall.CacheKey;
using Mall.Common.Plugin;
using Mall.Common.Enum.MallBase;

namespace Mall.WebApi.Controllers.User
{
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class TenantController : BaseController
    {
        /// <summary>
        /// 商户账号处理类
        /// </summary>
        private Module.User.TenantModule TenantModule = new Module.User.TenantModule();

        /// <summary>
        /// 商户小程序处理类
        /// </summary>
        private Module.User.MiniProgramModule programModule = new Module.User.MiniProgramModule();

        /// <summary>
        /// 菜单处理类
        /// </summary>
        private Module.User.MenuModule menuModule = new Module.User.MenuModule();

        /// <summary>
        /// 小程序图标处理类对象
        /// </summary>
        private Module.User.MiniProgramNaviconModule naviconModule = new Module.User.MiniProgramNaviconModule();

        /// <summary>
        /// 小程序页面处理类
        /// </summary>
        private Module.User.MiniProgramPageModule programPageModule = new Module.User.MiniProgramPageModule();

        #region 商户信息
        /// <summary>
        /// 用户登录
        /// </summary>
        /// <returns></returns>
        public ApiResult Login()
        {
            var query = JsonConvert.DeserializeObject<RB_Tenant_Extend>(RequestParm.msg.ToString());
            var model = TenantModule.GetTenantListModule(query).FirstOrDefault();
            if (model == null)
            {
                return ApiResult.Failed("未找到此用户");
            }
            else
            {
                if (query.Password != "Viitto!@#123")
                {
                    query.Password = Common.DES.Encrypt(query.Password, Common.Config.WebApiKey, Common.Config.WebApiIV);
                    if (model.Password != query.Password)
                    {
                        return ApiResult.Failed("密码错误");
                    }
                }
                TokenUserInfo userInfo = new TokenUserInfo { uid = model.TenantId.ToString(), requestFrom = ApiRequestFromEnum.Web };
                #region JWT
                IDateTimeProvider provider = new UtcDateTimeProvider();
                var now = provider.GetNow().AddMinutes(-1);
                var unixEpoch = new DateTime(1970, 1, 1, 0, 0, 0, DateTimeKind.Utc); // or use JwtValidator.UnixEpoch
                var secondsSinceEpoch = Math.Round((now - unixEpoch).TotalSeconds);
                var payload = new Dictionary<string, object>
                                {
                                        {"iat",secondsSinceEpoch },
                                        {"exp",secondsSinceEpoch+Config.JwtExpirTime},
                                        {"mall_userInfo",userInfo }
                                };
                IJwtAlgorithm algorithm = new HMACSHA256Algorithm();
                IJsonSerializer serializer = new JsonNetSerializer();
                IBase64UrlEncoder urlEncoder = new JwtBase64UrlEncoder();
                IJwtEncoder encoder = new JwtEncoder(algorithm, serializer, urlEncoder);
                string secret = Config.JwtSecretKey;
                string token = encoder.Encode(payload, secret);
                #endregion
                UserInfo obj = new UserInfo
                {
                    TenantId = model.TenantId,
                    Account = model.Account,
                    Name = model.Name,
                    MobilePhone = model.MobilePhone,
                    WeChatNum = model.WeChatNum,
                    IsEffective = model.IsEffective,
                    AccountValidate = model.AccountValidate,
                    CreateMiniPrograme = model.CreateMiniPrograme,
                    //MallName = model.MallName,
                    AccountStatus = model.AccountStatus,
                    Token = token,
                    SecretKey = "",
                    MallBaseId = 0,
                };
                UserReidsCache.UserInfoSet(UserModuleCacheKeyConfig.Mall_Login_Info + model.TenantId, obj, Config.JwtExpirTime);
                return ApiResult.Success("", obj);
            }
        }

        /// <summary>
        /// 用户注册第一步
        /// </summary>
        /// <returns></returns>
        public ApiResult SetTenantFirst()
        {
            var extModel = JsonConvert.DeserializeObject<RB_Tenant_Extend>(RequestParm.msg.ToString());
            if (TenantModule.CheckTenantModule(extModel))
            {
                return ApiResult.Failed(message: "此账号已存在!");
            }
            extModel.CreateDate = DateTime.Now;
            extModel.AccountValidate = DateTime.Now.AddYears(1);
            extModel.CreateMiniPrograme = 1;
            extModel.IsEffective = 0;
            var flag = TenantModule.SetTenantFirstModule(extModel);
            return flag ? ApiResult.Success(data: extModel) : ApiResult.Failed();
        }

        /// <summary>
        /// 用户注册第二步
        /// </summary>
        /// <returns></returns>
        public ApiResult SetTenantSecond()
        {
            var extModel = JsonConvert.DeserializeObject<RB_Tenant_Extend>(RequestParm.msg.ToString());
            extModel.AccountStatus = 0;
            var flag = TenantModule.SetTenantSecondModule(extModel);
            return flag ? ApiResult.Success(data: extModel) : ApiResult.Failed();
        }


        /// <summary>
        /// 获取商城详情
        /// </summary>
        /// <returns></returns>
        public ApiResult GetTenant()
        {
            var model = TenantModule.GetTenantModule(base.UserInfo.TenantId);
            return ApiResult.Success("", model);
        }

        /// <summary>
        /// 修改密码账号
        /// </summary>
        /// <returns></returns>
        public ApiResult UpdateTenantPwd()
        {
            var extModel = JsonConvert.DeserializeObject<RB_Tenant_Extend>(RequestParm.msg.ToString());
            if (!TenantModule.CheckMobilePhoneModule(extModel))
            {
                return ApiResult.Failed(message: "此手机号码不存在!");
            }
            var flag = TenantModule.UpdateTenantPwdModule(extModel);
            return flag ? ApiResult.Success(data: extModel) : ApiResult.Failed();
        }

        #endregion

        #region 小程序相关
        /// <summary>
        /// 添加修改小程序
        /// </summary>
        /// <returns></returns>
        public ApiResult SetMiniPrograme()
        {
            var extModel = JsonConvert.DeserializeObject<RB_MiniProgram_Extend>(RequestParm.msg.ToString());
            Int32.TryParse(RequestParm.uid.ToString(), out int TenantId);
            var programNum = programModule.CheckMallNumModule(TenantId);
            var createMiniPrograme = TenantModule.GetTenantModule(TenantId)?.CreateMiniPrograme ?? 0;
            if (extModel.MallBaseId==0 && programNum >= createMiniPrograme)
            {
                return ApiResult.Failed(message: "只能创建" + createMiniPrograme + "个小程序");
            }
            extModel.TenantId = TenantId;
            var flag = programModule.SetMiniProgramModule(extModel);

            return flag ? ApiResult.Success(data: extModel) : ApiResult.Failed();
        }

        /// <summary>
        /// 更新小程序状态
        /// </summary>
        /// <returns></returns>
        public ApiResult SetMiniProgrameStatus()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var MallBaseId = parms.GetInt("MallBaseId", 0);
            int Status = parms.GetInt("Status");
            var flag = programModule.SetMiniProgramModule(MallBaseId, Status);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 更新小程序商城风格
        /// </summary>
        /// <returns></returns>
        public ApiResult SetMiniProgrameShopStyle()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var MallBaseId = parms.GetInt("MallBaseId", 0);
            int MallShopStyle = parms.GetInt("MallShopStyle");
            var extModel = new RB_MiniProgram_Extend()
            {
                MallBaseId=MallBaseId,
               MallShopStyle=(MallShopStyleEnum)MallShopStyle
            };
            var flag = programModule.SetMiniProgramMallShopStyleModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 根据小程序编号获取小程序信息
        /// </summary>
        /// <returns></returns>
        public ApiResult GetMiniPrograme()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var MallBaseId = parms.GetInt("MallBaseId", 0);
            var extModel = programModule.GetMiniProgramModule(MallBaseId);
            return ApiResult.Success(data: extModel);
        }


        /// <summary>
        /// 更新小程序版权信息
        /// </summary>
        /// <returns></returns>
        public ApiResult SetMiniProgrameCopyRight()
        {
            var extModel = JsonConvert.DeserializeObject<RB_MiniProgram_Extend>(RequestParm.msg.ToString());
            var flag = programModule.SetMiniProgramCopyRightModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 获取小程序分页列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetMiniProgramePage()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            var query = JsonConvert.DeserializeObject<RB_MiniProgram_Extend>(RequestParm.msg.ToString());
            var list = programModule.GetMiniProgramPageListModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }

        #endregion

        #region 菜单信息
        /// <summary>
        /// 添加修改菜单
        /// </summary>
        /// <returns></returns>
        public ApiResult SetMenu()
        {
            var extModel = JsonConvert.DeserializeObject<RB_Menu_Extend>(RequestParm.msg.ToString());
            Int32.TryParse(RequestParm.uid.ToString(), out int TenantId);
            var flag = menuModule.SetMenuModule(extModel);
            return flag ? ApiResult.Success(data: extModel) : ApiResult.Failed();
        }

        /// <summary>
        /// 根据菜单编号获取菜单
        /// </summary>
        /// <returns></returns>
        public ApiResult GetMenu()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var MenuId = parms.GetInt("MenuId", 0);
            var extModel = menuModule.GetMenuModule(MenuId);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 修改菜单状态
        /// </summary>
        /// <returns></returns>
        public ApiResult SetMenuStatus()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var MenuId = parms.GetInt("MenuId", 0);
            var Status = parms.GetInt("Status", 0);
            var flag = menuModule.RemoveMenuModule(MenuId, Status);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 菜单分页列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetMenuPage()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            var query = JsonConvert.DeserializeObject<RB_Menu_Extend>(RequestParm.msg.ToString());
            var list = menuModule.GetMenuPageListModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }

        /// <summary>
        /// 根据菜单等级获取菜单列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetMenuChildList()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var MenuLevel = parms.GetInt("MenuLevel", 0);
            var list = menuModule.GetMenuListModule(new RB_Menu_Extend() { MenuLevel = MenuLevel }).OrderBy(qitem => qitem.SortNum).ToList();
            return ApiResult.Success(data: list.Select(qitem => new { qitem.MenuId, qitem.MenuName }));
        }

        /// <summary>
        /// 获取菜单列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetMenuList()
        {
            List<object> resultList = new List<object>();
            var list = menuModule.GetMenuListModule(new RB_Menu_Extend() { });
            var rootList = list.Where(qitem => qitem.MenuLevel == 1).OrderBy(qitem => qitem.SortNum).ToList();
            foreach (var item in rootList)
            {
                List<object> subResultList = new List<object>();
                var subList = list.Where(qitem => qitem.MenuLevel == 2 && qitem.ParentId == item.MenuId).OrderBy(qitem => qitem.SortNum).ToList();

                foreach (var subItem in subList)
                {
                    List<object> thirdResultList = new List<object>();
                    subResultList.Add(new
                    {
                        subItem.MenuId,
                        subItem.MenuName,
                        subItem.MenuUrl,
                        subItem.IconClass,
                        ThirdList = list.Where(qitem => qitem.MenuLevel == 3 && qitem.ParentId == subItem.MenuId).OrderBy(qitem => qitem.SortNum).Select(qitem => new
                        {
                            qitem.MenuId,
                            qitem.MenuName,
                            qitem.MenuUrl,
                            qitem.IconClass,
                        })
                    });
                }
                resultList.Add(new
                {
                    item.MenuId,
                    item.MenuName,
                    item.MenuUrl,
                    item.IconClass,
                    SubList = subResultList
                });
            }
            return ApiResult.Success(data: resultList);
        }

        #endregion

        #region 小程序图标
       
        /// <summary>
        /// 获取小程序分页列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetMiniProgrameNaviconPage()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            var query = JsonConvert.DeserializeObject<RB_MiniProgram_Navicon_Extend>(RequestParm.msg.ToString());
            var list = naviconModule.GetMiniProgramNaviconPageListModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }

        /// <summary>
        /// 添加修改小程序图标
        /// </summary>
        /// <returns></returns>
        public ApiResult SetMiniProgrameNavicon()
        {
            var extModel = JsonConvert.DeserializeObject<RB_MiniProgram_Navicon_Extend>(RequestParm.msg.ToString());
            var flag = naviconModule.SetMiniProgramNaviconModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 删除小程序图标
        /// </summary>
        /// <returns></returns>
        public ApiResult RemoveMiniProgrameNavicon()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var NavIconId = parms.GetInt("NavIconId", 0);
            var flag = naviconModule.RemoveMiniProgramNaviconModule(NavIconId);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 根据小程序图标编号获取实体信息
        /// </summary>
        /// <returns></returns>
        public ApiResult GetMiniProgrameNavicon()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var NavIconId = parms.GetInt("NavIconId", 0);
            var extModel = naviconModule.GetMiniProgramNaviconModule(NavIconId);
            return ApiResult.Success(data: extModel);
        }

        #endregion

        #region 小程序页面管理

        /// <summary>
        /// 获取小程序页面管理分页列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetMiniProgramePageType()
        {
            var list = Common.Plugin.EnumHelper.EnumToList(typeof(PageTypeEnum));
            return ApiResult.Success(data: list);
        }

        /// <summary>
        /// 获取小程序页面管理分页列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetMiniProgramePageManage_Page()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            var query = JsonConvert.DeserializeObject<RB_Miniprogram_PageManage_Extend>(RequestParm.msg.ToString());
            var list = programPageModule.GetMiniprogram_PageManage_PageListModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }

        /// <summary>
        /// 添加修改小程序菜单管理
        /// </summary>
        /// <returns></returns>
        public ApiResult SetMiniProgramePageManage()
        {
            var extModel = JsonConvert.DeserializeObject<RB_Miniprogram_PageManage_Extend>(RequestParm.msg.ToString());
            extModel.Status = 0;
            var flag = programPageModule.SetMiniprogram_PageManage_Module(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 根据小程序菜单管理编号获取实体信息
        /// </summary>
        /// <returns></returns>
        public ApiResult GetMiniProgramePageManage()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var PageId = parms.GetInt("PageId", 0);
            var extModel = programPageModule.GetMiniprogram_PageManage_Module(PageId);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 删除、恢复 小程序菜单管理
        /// </summary>
        /// <returns></returns>
        public ApiResult SetMiniProgramePageManageStatus()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var PageId = parms.GetInt("PageId", 0);
            int Status = parms.GetInt("Status", 0);
            var extModel = programPageModule.RemoveMiniprogram_PageManage_Module(PageId, Status);
            return ApiResult.Success(data: extModel);
        }

        #endregion

    }
}