﻿using Mall.Common.Enum;
using Mall.Model.Entity.TradePavilion;
using Mall.Model.Extend.TradePavilion;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VT.FW.DB.Dapper;

namespace Mall.Repository.TradePavilion
{
    /// <summary>
    /// 联系人仓储层
    /// </summary>
    public class RB_ContractRepository : BaseRepository<RB_Contract>
    {
        /// <summary>
        /// 获取联系分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Contract_Extend> GetContractPageListRepository(int pageIndex, int pageSize, out long rowsCount, RB_Contract_Extend query)
        {
            rowsCount = 0;
            DynamicParameters parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT * 
FROM RB_Contract
WHERE 1=1
");
            builder.AppendFormat(" AND {0}={1} ", nameof(RB_Contract_Extend.Status), (int)DateStateEnum.Normal);
            if (query == null)
            {
                return new List<RB_Contract_Extend>();
            }
            else
            {
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Contract_Extend.TenantId), query.TenantId);
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Contract_Extend.MallBaseId), query.MallBaseId);
                }
                if (!string.IsNullOrEmpty(query.Name))
                {
                    builder.AppendFormat(" AND {0} LIKE @Name ", nameof(RB_Contract_Extend.Name));
                    parameters.Add("Name", "%" + query.Name.Trim() + "%");
                }
            }
            return GetPage<RB_Contract_Extend>(pageIndex, pageSize, out rowsCount, builder.ToString(), parameters).ToList();
        }
    }
}