﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Dnc.Api.Throttle;
using Mall.Common.API;
using Mall.Common.Plugin;
using Mall.Model.Extend.User;
using Mall.Module.User;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;

namespace Mall.WebApi.Controllers.User
{
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class MemberUserController : BaseController
    {
        private MemberUserModule MemberUserModule = new MemberUserModule();


        [AllowAnonymous] [RateValve(Policy = Policy.Ip, Limit = 10, Duration = 60)]
        /// <summary>
        /// 用户登录
        /// </summary>
        /// <returns></returns>
        [RateValve(Policy = Policy.Ip, Limit = 10, Duration = 60)]
        public ApiResult SetMemberPhoto()
        {
            var extModel = JsonConvert.DeserializeObject<RB_Member_User_Extend>(RequestParm.msg.ToString());
            if (extModel.Name != "微信用户")
            {
                var flag = MemberUserModule.SetMemberUserNameAndPhoto(extModel);
                return flag ? ApiResult.Success() : ApiResult.Failed();
            }
            else
            {
                return ApiResult.Failed("获取用户信息失败");
            }

        }

        /// <summary>
        /// 更改用户的手机号码 add by:W 2020-10-28
        /// </summary>
        /// <returns></returns>
        public ApiResult SetMemberUserPhoneNum()
        {
            var extModel = JsonConvert.DeserializeObject<RB_Member_User_Extend>(RequestParm.msg.ToString());
            var flag = MemberUserModule.SetMemberUserPhoneNum(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        #region 小程序管理端-消息提醒

        /// <summary>
        /// 获取管理端消息分页列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetAdminMessageNoticePageList() {
            var parms = base.RequestParm;
            var pmodel = JsonHelper.DeserializeObject<ResultPageModel>(parms.msg.ToString());
            RB_Message_Notice_Extend demodel = JsonHelper.DeserializeObject<RB_Message_Notice_Extend>(parms.msg.ToString());
            if (demodel.Type <= 0) {
                return ApiResult.ParamIsNull("请选择查询类型");
            }
            demodel.TenantId = Convert.ToInt32(parms.uid);
            demodel.MallBaseId = parms.MallBaseId;

            var list = MemberUserModule.GetAdminMessageNoticePageList(pmodel.pageIndex, pmodel.pageSize, out long count, demodel);
            pmodel.count = Convert.ToInt32(count);
            pmodel.pageData = list.Select(x => new
            {
                x.Id,
                x.SourceId,
                x.OrderNo,
                x.Type,
                x.IsLook,
                x.UserId,
                x.UserName,
                CreateDate = x.CreateDate.ToString("yyyy-MM-dd HH:mm"),
                x.GoodsName,
                x.GoodsCoverImage,
                x.OrderTypeName
            });
            return ApiResult.Success("", pmodel);
        }

        /// <summary>
        /// 获取管理端消息通知数量
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetAdminMessageNoticeNum() {
            var parms = base.RequestParm;
            int TenantId = Convert.ToInt32(parms.uid);
            int MallBaseId = parms.MallBaseId;

            var Rmsg = MemberUserModule.GetAdminMessageNoticeNum(TenantId, MallBaseId);
            return ApiResult.Success("", Rmsg);
        }

        /// <summary>
        /// 设置管理端消息查看
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetAdminMessageLook() {
            var parms = base.RequestParm;
            RB_Message_Notice_Extend demodel = JsonHelper.DeserializeObject<RB_Message_Notice_Extend>(parms.msg.ToString());
            demodel.TenantId = Convert.ToInt32(parms.uid);
            demodel.MallBaseId = parms.MallBaseId;

            string msg = MemberUserModule.SetAdminMessageLook(demodel);
            if (msg == "")
            {
                return ApiResult.Success();
            }
            else {
                return ApiResult.Failed(msg);
            }
        }

        #endregion
    }
}