﻿using Mall.Model.Entity.GuideCar;
using Mall.Model.Extend.GuideCar;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.GuideCar
{
    public class RB_GuideCar_GuideRepository : BaseRepository<RB_GuideCar_Guide>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_GuideCar_Guide); } }


        /// <summary>
        /// 表名称
        /// </summary>
        public string SiteTableName { get { return nameof(RB_GuideCar_Site); } }
        /// <summary>
        /// 导游列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_GuideCar_Guide_Extend> GetPageListRepository(int pageIndex, int pageSize, out long rowCount, RB_GuideCar_Guide_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT a.*,b.SiteName FROM {TableName} as a LEFT JOIN {SiteTableName} as b on a.SiteId=b.ID WHERE  a.{nameof(RB_GuideCar_Guide_Extend.Status)}=0");
            if (query != null)
            {
                // where += $@" and {nameof(RB_Customer_InfoCreate.CustomerId)}={dmodel.CustomerId}";
                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_GuideCar_Guide_Extend.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_GuideCar_Guide_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (!string.IsNullOrWhiteSpace(query.Name))
                {
                    builder.Append($" AND a.{nameof(RB_GuideCar_Guide_Extend.Name)} like '%{query.Name}%'");
                }
                if (query.ID > 0)
                {
                    builder.Append($" AND a.{nameof(RB_GuideCar_Guide_Extend.ID)}={query.ID}");
                }
                if (query.IsEnable > -1)
                {
                    builder.Append($" AND a.{nameof(RB_GuideCar_Guide_Extend.IsEnable)}={query.IsEnable}");
                }
                if (query.StartWorkYears.HasValue&& query.StartWorkYears > 0)
                {
                    builder.Append($" AND a.{nameof(RB_GuideCar_Guide_Extend.WorkYears)}>={query.StartWorkYears}");
                }
                if (query.EndWorkYears.HasValue && query.EndWorkYears > 0)
                {
                    builder.Append($" AND a.{nameof(RB_GuideCar_Guide_Extend.WorkYears)}<={query.EndWorkYears}");
                }

                if (query.StartScore.HasValue && query.StartScore > 0)
                {
                    builder.Append($" AND a.{nameof(RB_GuideCar_Guide_Extend.Score)}>={query.StartScore}");
                }
                if (query.EndScore.HasValue && query.EndScore > 0)
                {
                    builder.Append($" AND a.{nameof(RB_GuideCar_Guide_Extend.Score)}<={query.EndScore}");
                }
                if (query.IsEnable > -1)
                {
                    builder.Append($" AND a.{nameof(RB_GuideCar_Guide_Extend.IsEnable)}={query.IsEnable}");
                }
                if (!string.IsNullOrEmpty(query.StartTime))
                {
                    builder.Append($" and a.{nameof(RB_GuideCar_Guide_Extend.CreateDate)} >='{query.StartTime}'");
                }
                if (!string.IsNullOrEmpty(query.EndTime))
                {
                    builder.Append($"  and a.{nameof(RB_GuideCar_Guide_Extend.CreateDate)} <='{query.EndTime} 23:59:59'");
                }
            }
            return GetPage<RB_GuideCar_Guide_Extend>(pageIndex, pageSize, out rowCount, builder.ToString()).ToList();
        }


        /// <summary>
        ///导游列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_GuideCar_Guide_Extend> GetGuideCarGuideList(RB_GuideCar_Guide_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT a.*,b.SiteName FROM {TableName} as a LEFT JOIN {SiteTableName} as b on a.SiteId=b.ID WHERE  a.{nameof(RB_GuideCar_Guide_Extend.Status)}=0");
            if (query != null)
            {
                // where += $@" and {nameof(RB_Customer_InfoCreate.CustomerId)}={dmodel.CustomerId}";
                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_GuideCar_Guide_Extend.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_GuideCar_Guide_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (!string.IsNullOrWhiteSpace(query.Name))
                {
                    builder.Append($" AND a.{nameof(RB_GuideCar_Guide_Extend.Name)} like '%{query.Name}%'");
                }
                if (query.ID > 0)
                {
                    builder.Append($" AND a.{nameof(RB_GuideCar_Guide_Extend.ID)}={query.ID}");
                }
                if (!string.IsNullOrEmpty(query.GuideIds)) 
                {
                    builder.Append($" AND a.{nameof(RB_GuideCar_Guide_Extend.ID)} in({query.GuideIds})");
                }
                if (query.IsEnable > -1)
                {
                    builder.Append($" AND a.{nameof(RB_GuideCar_Guide_Extend.IsEnable)}={query.IsEnable}");
                }
                if (query.StartWorkYears.HasValue && query.StartWorkYears > 0)
                {
                    builder.Append($" AND a.{nameof(RB_GuideCar_Guide_Extend.WorkYears)}>={query.StartWorkYears}");
                }
                if (query.EndWorkYears.HasValue && query.EndWorkYears > 0)
                {
                    builder.Append($" AND a.{nameof(RB_GuideCar_Guide_Extend.WorkYears)}<={query.EndWorkYears}");
                }

                if (query.StartScore.HasValue && query.StartScore > 0)
                {
                    builder.Append($" AND a.{nameof(RB_GuideCar_Guide_Extend.Score)}>={query.StartScore}");
                }
                if (query.EndScore.HasValue && query.EndScore > 0)
                {
                    builder.Append($" AND a.{nameof(RB_GuideCar_Guide_Extend.Score)}<={query.EndScore}");
                }
                if (!string.IsNullOrEmpty(query.StartTime))
                {
                    builder.Append($" and a.{nameof(RB_GuideCar_Guide_Extend.CreateDate)} >='{query.StartTime}'");
                }
                if (!string.IsNullOrEmpty(query.EndTime))
                {
                    builder.Append($"  and a.{nameof(RB_GuideCar_Guide_Extend.CreateDate)} <='{query.EndTime} 23:59:59'");
                }
            }
            return Get<RB_GuideCar_Guide_Extend>(builder.ToString()).ToList();
        }
    }
}
