﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading.Tasks;

namespace Mall.Common.Plugin
{
    /// <summary>
    /// html工具类
    /// </summary>
    public static class HtmlHelper
    {
        /// <summary>
        /// 从html中提取纯文本和Img标签
        /// </summary>
        /// <param name="strHtml"></param>
        /// <returns></returns>
        public static string StripImg(string strHtml)
        {
            Regex regex = new Regex("<(?!img).+?>", RegexOptions.IgnoreCase);
            string strOutput = regex.Replace(strHtml, "");
            return strOutput;
        }
        /// <summary>
        /// 从html中提取纯文本
        /// </summary>
        /// <param name="strHtml"></param>
        /// <returns></returns>
        public static string StripHT(string strHtml)
        {
            Regex regex = new Regex("<.+?>", RegexOptions.IgnoreCase);
            string strOutput = regex.Replace(strHtml, "");//替换掉"<"和">"之间的内容
            strOutput = strOutput.Replace("<", "");
            strOutput = strOutput.Replace(">", "");
            strOutput = strOutput.Replace("&nbsp;", "");
            return strOutput;
        }

        /// <summary> 
        /// 取得HTML中所有图片的 URL。 
        /// </summary> 
        /// <param name="sHtmlText">HTML代码</param> 
        /// <returns>图片的URL列表</returns> 
        public static string[] GetHtmlImageUrlList(string sHtmlText)
        {
            // 定义正则表达式用来匹配 img 标签 
            Regex regImg = new Regex(@"<img\b[^<>]*?\bsrc[\s\t\r\n]*=[\s\t\r\n]*[""']?[\s\t\r\n]*(?<imgUrl>[^\s\t\r\n""'<>]*)[^<>]*?[\s\t\r\n]*>", RegexOptions.IgnoreCase);

            // 搜索匹配的字符串 
            MatchCollection matches = regImg.Matches(sHtmlText);
            int i = 0;
            string[] sUrlList = new string[matches.Count];

            // 取得匹配项列表 
            foreach (Match match in matches)
                sUrlList[i++] = match.Groups["imgUrl"].Value;
            return sUrlList;
        }

        /// <summary>  
        /// 获取Img标签  
        /// </summary>  
        /// <param name="htmlText">截获到的html代码</param>  
        /// <returns></returns>  
        public static List<string> GetPadImg(string htmlText)
        {
            List<string> list = new List<string>();
            Regex regImg = new Regex("<img(.*?)>", RegexOptions.IgnoreCase);
            MatchCollection mc = regImg.Matches(htmlText);
            foreach (Match m in mc)
            {
                list.Add(m.Value); //获取Img标签  
            }
            return list;
        }


        /// <summary>  
        /// 获取Img标签信息
        /// </summary>  
        /// <param name="img"></param>  
        /// <param name="url"></param>  
        /// <param name="width"></param>  
        /// <param name="height"></param>  
        /// <returns></returns>  
        public static void GetPadImgInfo(string img, out string url, out int width, out int height)
        {
            Regex regImg = new Regex(@"<img\b[^<>]*?\bsrc[\s\t\r\n]*=[\s\t\r\n]*[""']?[\s\t\r\n]*(?<imgUrl>[^\s\t\r\n""'<>]*)[^<>]*?[\s\t\r\n]*>", RegexOptions.IgnoreCase);
            // 搜索匹配的字符串 
            MatchCollection matches = regImg.Matches(img);
            if (matches.Count > 0)
            {
                url = matches[0].Groups["imgUrl"].Value.ToString();
            }
            else
            {
                url = "";
            }
            Regex regWidth = new Regex(@"width:(?<width>\d+)px", RegexOptions.IgnoreCase);
            MatchCollection mcWidth = regWidth.Matches(img);
            if (mcWidth.Count > 0)
            {
                width = Convert.ToInt32(mcWidth[0].Groups["width"].Value.ToString());
            }
            else
            {
                width = 0;
            }
            Regex regHeight = new Regex(@"height:(?<height>\d+)px", RegexOptions.IgnoreCase);
            MatchCollection mcHeight = regHeight.Matches(img);
            if (mcHeight.Count > 0)
            {
                height = Convert.ToInt32(mcHeight[0].Groups["height"].Value.ToString());
            }
            else
            {
                height = 0;
            }
        }

        /// <summary>  
        /// 获取Img地址信息
        /// </summary>  
        /// <param name="imgPath"></param>  
        /// <param name="url"></param>  
        /// <param name="width"></param>  
        /// <param name="height"></param>  
        /// <returns></returns>  
        public static void GetImgInfo(string imgPath, out string url, out int width, out int height)
        {
            url = imgPath.Split('?')[0];
            Regex regWidth = new Regex(@"width=(?<width>\d+)", RegexOptions.IgnoreCase);
            MatchCollection mcWidth = regWidth.Matches(imgPath);
            if (mcWidth.Count > 0)
            {
                width = Convert.ToInt32(mcWidth[0].Groups["width"].Value.ToString());
            }
            else
            {
                width = 0;
            }
            Regex regHeight = new Regex(@"height=(?<height>\d+)", RegexOptions.IgnoreCase);
            MatchCollection mcHeight = regHeight.Matches(imgPath);
            if (mcHeight.Count > 0)
            {
                height = Convert.ToInt32(mcHeight[0].Groups["height"].Value.ToString());
            }
            else
            {
                height = 0;
            }
        }

        /// <summary>  
        /// 获取Url中图片参数
        /// </summary>  
        /// <returns></returns>  
        public static void GetImgParm(string imgUrl,  out int width, out int height)
        {

            Regex regWidth = new Regex(@"width=(?<width>\d+)", RegexOptions.IgnoreCase);
            MatchCollection mcWidth = regWidth.Matches(imgUrl);
            if (mcWidth.Count > 0)
            {
                width = Convert.ToInt32(mcWidth[0].Groups["width"].Value.ToString());
            }
            else
            {
                width = 300;
            }
            Regex regHeight = new Regex(@"height=(?<height>\d+)", RegexOptions.IgnoreCase);
            MatchCollection mcHeight = regHeight.Matches(imgUrl);
            if (mcHeight.Count > 0)
            {
                height = Convert.ToInt32(mcHeight[0].Groups["height"].Value.ToString());
            }
            else
            {
                height = 300;
            }
        }
    }
}
