﻿using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using QRCoder;
using System;
using System.Collections;
using System.Collections.Generic;
using System.Data;
using System.Drawing;
using System.IO;
using System.Linq;
using BarcodeLib;

namespace Mall.Common.Plugin
{
    /// <summary>
    /// 二维码和条形码
    /// </summary>
    public static class QRCodeHelper
    {

        /// <summary>  
        /// 批量生成二维码图片  
        /// </summary>  
        public static bool CreateQRCode(string path, int imgSize,string logoPath, string savePath, System.Drawing.Imaging.ImageFormat imageFormat)
        {
            try
            {
                //生成图片  
                Bitmap image = GetPTQRCode(path, imgSize);
                //保存图片  
                SaveImg(savePath, image, imageFormat);
                return true;
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "Create_CodeImages");
                return false;
            }
        }


        /// <summary>  
        /// 保存图片  
        /// </summary>  
        /// <param name="strPath">保存路径</param>  
        /// <param name="imgData">图片</param>  
        /// <param name="image">图片格式</param>  
        public static void SaveImg(string strPath, Bitmap imgData, System.Drawing.Imaging.ImageFormat image)
        {
            string DirectoryPath = Path.GetDirectoryName(strPath);
            //保存图片到目录  
            if (!Directory.Exists(DirectoryPath))
            {
                //当前目录不存在，则创建  
                Directory.CreateDirectory(DirectoryPath);
            }
            //文件名称  
            imgData.Save(strPath, image);
        }

        #region 普通二维码
        /// <summary>
        /// 
        /// </summary>
        /// <param name="url">存储内容</param>
        /// <param name="pixel">像素大小</param>
        /// <returns></returns>
        public static Bitmap GetPTQRCode(string url, int pixel)
        {
            QRCodeGenerator generator = new QRCodeGenerator();
            QRCodeData codeData = generator.CreateQrCode(url, QRCodeGenerator.ECCLevel.M, true);
            QRCoder.QRCode qrcode = new QRCoder.QRCode(codeData);
            Bitmap qrImage = qrcode.GetGraphic(pixel, Color.Black, Color.White, true);
            return qrImage;
        }
        #endregion

        #region 带logo的二维码
        /// <summary>
        /// 
        /// </summary>
        /// <param name="url">存储内容</param>
        /// <param name="pixel">像素大小</param>
        /// <returns></returns>
        public static Bitmap GetLogoQRCode(string url, string logoPath, int pixel)
        {
            QRCodeGenerator generator = new QRCodeGenerator();
            QRCodeData codeData = generator.CreateQrCode(url, QRCodeGenerator.ECCLevel.M, true);
            QRCoder.QRCode qrcode = new QRCoder.QRCode(codeData);
            Bitmap icon = new Bitmap(logoPath);
            Bitmap qrImage = qrcode.GetGraphic(pixel, Color.Black, Color.White, icon, 10, 3, true);
            #region 参数介绍
            //GetGraphic方法参数介绍
            //pixelsPerModule //生成二维码图片的像素大小 ，我这里设置的是5
            //darkColor       //暗色   一般设置为Color.Black 黑色
            //lightColor      //亮色   一般设置为Color.White  白色
            //icon             //二维码 水印图标 例如：Bitmap icon = new Bitmap(context.Server.MapPath("~/images/zs.png")); 默认为NULL ，加上这个二维码中间会显示一个图标
            //iconSizePercent  //水印图标的大小比例 ，可根据自己的喜好设置
            //iconBorderWidth  // 水印图标的边框
            //drawQuietZones   //静止区，位于二维码某一边的空白边界,用来阻止读者获取与正在浏览的二维码无关的信息 即是否绘画二维码的空白边框区域 默认为true
            #endregion
            return qrImage;
        }
        #endregion


        #region 条形码生成

        public static void CreateTQRCode(string message, string path, System.Drawing.Imaging.ImageFormat imageFormat, int width = 500, int height = 100)
        {
            Barcode b = new Barcode();
            Image img = b.Encode(TYPE.CODE128, message, Color.Black, Color.White, width, height);
            MemoryStream stream = new MemoryStream();
            img.Save(stream, imageFormat);
            Bitmap imgData = (Bitmap)(img);
            string DirectoryPath = Path.GetDirectoryName(path);
            //保存图片到目录  
            if (!Directory.Exists(DirectoryPath))
            {
                //当前目录不存在，则创建  
                Directory.CreateDirectory(DirectoryPath);
            }
            //文件名称  
            imgData.Save(path, imageFormat);
        }

        #endregion
    }
}
