﻿using System;
using System.Collections.Generic;
using System.Text;
using VT.FW.DB;

namespace Mall.Model.Entity.AppletWeChat
{
    /// <summary>
    /// 直播海报配置实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Live_Config
    {
		/// <summary>
		/// 主键Id
		/// </summary>
		public int Id { get; set; }

		/// <summary>
		/// 海报背景图
		/// </summary>
		public string LiveBgImg { get; set; }

		/// <summary>
		/// 二维码大小
		/// </summary>
		public int? LiveQrCodeSize { get; set; }

		/// <summary>
		/// 二维码上间距
		/// </summary>
		public int? LiveQrCodePaddingTop { get; set; }

		/// <summary>
		/// 二维码左间距
		/// </summary>
		public int? LiveQrCodePaddingLeft { get; set; }

		/// <summary>
		/// 二维码形状(0-圆形，1-方形)
		/// </summary>
		public int? LiveQrCodeType { get; set; }

		/// <summary>
		/// 商户Id
		/// </summary>
		public int? TenantId { get; set; }

		/// <summary>
		/// 小程序id
		/// </summary>
		public int? MallBaseId { get; set; }

		/// <summary>
		/// 创建时间
		/// </summary>
		public DateTime? CreateDate { get; set; }
	}
}
