﻿using VT.FW.DB;
using Mall.Common.Enum.User;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.Product
{
    /// <summary>
    /// 商品分类表实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Product_Category
    {

        /// <summary>
        /// Id
        /// </summary>        
        public int Id
        {
            get;
            set;
        }
        /// <summary>
        /// 分类名称
        /// </summary>        
        public string Name
        {
            get;
            set;
        }
        /// <summary>
        /// 层级
        /// </summary>        
        public int? Tier
        {
            get;
            set;
        }
        /// <summary>
        /// 父级id
        /// </summary>        
        public int? ParentId
        {
            get;
            set;
        }
        /// <summary>
        /// 根节点id
        /// </summary>        
        public int? RootId
        {
            get;
            set;
        }
        /// <summary>
        /// 排序
        /// </summary>        
        public int? Sort
        {
            get;
            set;
        }
        /// <summary>
        /// 分类图标
        /// </summary>        
        public int? Icon
        {
            get;
            set;
        }
        /// <summary>
        /// 分类大图
        /// </summary>        
        public int? BigIcon
        {
            get;
            set;
        }
        /// <summary>
        /// 分类广告图
        /// </summary>        
        public int? AdvertisingImage
        {
            get;
            set;
        }
        /// <summary>
        /// 分类广告链接
        /// </summary>        
        public string AdvertisingAddress
        {
            get;
            set;
        }
        /// <summary>
        /// 启用  1是  2否
        /// </summary>        
        public int? Enabled
        {
            get;
            set;
        }
        /// <summary>
        /// 是否显示  1是  2否
        /// </summary>        
        public int? IsShow
        {
            get;
            set;
        }
        /// <summary>
        /// 删除
        /// </summary>        
        public int? Status
        {
            get;
            set;
        }
        /// <summary>
        /// 商户号
        /// </summary>        
        public int TenantId
        {
            get;
            set;
        }
        /// <summary>
        /// 小程序id
        /// </summary>        
        public int MallBaseId
        {
            get;
            set;
        }
        /// <summary>
        /// CreateDate
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }
        /// <summary>
        /// UpdateDate
        /// </summary>        
        public DateTime? UpdateDate
        {
            get;
            set;
        }
        /// <summary>
        /// 是否对外分享  1是  2否
        /// </summary>
        public int? IsForeignShare { get; set; }
    }
}
