﻿using Mall.Model.Entity.User;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.User
{
    public class RB_SmallShops_CustomRepository : BaseRepository<RB_SmallShops_Custom>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_SmallShops_Custom); } }
        /// <summary>
        /// 微信自定义分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_SmallShops_Custom> GetSmallShopsCustomPageList(int pageIndex, int pageSize, out long rowCount, RB_SmallShops_Custom query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM {TableName} WHERE  {nameof(RB_SmallShops_Custom.Status)}=0");
            if (query != null)
            {
                // where += $@" and {nameof(RB_Customer_InfoCreate.CustomerId)}={dmodel.CustomerId}";
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_SmallShops_Custom.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_SmallShops_Custom.MallBaseId)}={query.MallBaseId}");
                }

            }
            return GetPage<RB_SmallShops_Custom>(pageIndex, pageSize, out rowCount, builder.ToString()).ToList();
        }


        /// <summary>
        /// 微信自定义列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_SmallShops_Custom> GetSmallShopsCustomList(RB_SmallShops_Custom query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM {TableName} WHERE {nameof(RB_SmallShops_Custom.Status)}=0 ");
            if (query != null)
            {
                if (query.Id > 0)
                {
                    builder.Append($" AND {nameof(RB_SmallShops_Custom.Id)}={query.Id}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_SmallShops_Custom.TenantId)}={query.TenantId}");
                }
                if (query.MallBaseId > 0)
                {
                    builder.Append($" AND {nameof(RB_SmallShops_Custom.MallBaseId)}={query.MallBaseId}");
                }

            }
            return Get<RB_SmallShops_Custom>(builder.ToString()).ToList();
        }
    }
}
