﻿using VT.FW.DB;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Mall.Model.Entity.Customer
{
    /// <summary>
    /// 客户积分明细
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "CustomerConnection")]
    public class RB_Customer_Integral
    {
        /// <summary>
        /// Id
        /// </summary>
        public int Id { get; set; }

        /// <summary>
        /// 客户Id
        /// </summary>
        public int CustomerId { get; set; }

        /// <summary>
        /// 客户类型  1同行  2直客
        /// </summary>
        public int CustomerType { get; set; }

        /// <summary>
        /// 订单ID
        /// </summary>
        public int OrderId { get; set; }

        /// <summary>
        /// 来源类型  1团队订单  2电商订单
        /// </summary>
        public int OrderType { get; set; }

        /// <summary>
        /// 变更金额（正负数 表示 增加 减少）
        /// </summary>
        public decimal IntegralNum { get; set; }

        /// <summary>
        /// 描述
        /// </summary>
        public string Description { get; set; }

        /// <summary>
        /// 集团ID
        /// </summary>
        public int GroupId { get; set; }

        /// <summary>
        /// 订单积分生成时间
        /// </summary>
        public DateTime CreateTime { get; set; }

        /// <summary>
        /// 归属团
        /// </summary>
        public int TCID { get; set; }

        /// <summary>
        /// 是否抵用  1是
        /// </summary>
        public int IsDeduction { get; set; }

        /// <summary>
        /// 同业员工ID
        /// </summary>
        public int CustomerChildrenId { get; set; }

        /// <summary>
        /// 总返佣金额
        /// </summary>
        public decimal MallCommission { get; set; }
    }
}
