﻿using Mall.Common;
using Mall.Model.Extend.Product;
using Mall.Model.Extend.TradePavilion;
using Microsoft.AspNetCore.Mvc;
using NPOI.HPSF;
using System;
using System.Collections.Generic;
using System.Data;
using System.Text;

namespace Mall.DataHelper.Import
{
    /// <summary>
    /// 品牌导入帮助类
    /// </summary>
    public class BrandHelper
    {
        /// <summary>
        /// 导入模板
        /// </summary>
        /// <param name="fileName"></param>
        /// <returns></returns>
        public static List<RB_Brand_Enterprise_Extend> ImportYBBrandData(string fileName,string tempFilePath)
        {
            //图片所在的列
            List<int> imgColList = new List<int>();
            imgColList.Add(1);
            imgColList.Add(2);
            List<RB_Brand_Enterprise_Extend> list = new List<RB_Brand_Enterprise_Extend>();
            Mall.Common.Plugin.ImportExcelNPOIHelper importExcelNPOIHelper = new Common.Plugin.ImportExcelNPOIHelper(tempFilePath);
            DataTable dt = importExcelNPOIHelper.ExcelToDataTable(fileName, 0, 0, true, imgColList: imgColList);
            if (dt != null && dt.Rows.Count > 0)
            {
                foreach (DataRow dr in dt.Rows)
                {
                    list.Add(DataRowToModel(dr));
                }
            }
            return list;
        }

        /// <summary>
        /// DataRow转实体
        /// </summary>
        /// <param name="dr"></param>
        /// <returns></returns>
        public static RB_Brand_Enterprise_Extend DataRowToModel(DataRow dr)
        {
            RB_Brand_Enterprise_Extend model = new RB_Brand_Enterprise_Extend()
            {
                BrandName = "",
                Logo = "",
                Banner = "",
                VideoUrl = "",
                CategoryName = "",
                Introduce = "",
                ShopNum = 0,
                AreaRequirement = 0,
                CustomerType = "",
                BrandType = "",
                Cooperation = "",
                PropertyDemand = "",
                Complementary = "",
                ContactName = "",
                ContactPhone = "",
            };
            if (dr != null)
            {
                if (dr.Table.Columns.Contains("品牌名称") && !string.IsNullOrEmpty(dr["品牌名称"].ToString().Trim()))
                {
                    model.BrandName = dr["品牌名称"].ToString();
                }
                if (dr.Table.Columns.Contains("Logo") && !string.IsNullOrEmpty(dr["Logo"].ToString().Trim()))
                {
                    model.Logo = dr["Logo"].ToString();
                }
                if (dr.Table.Columns.Contains("介绍图") && !string.IsNullOrEmpty(dr["介绍图"].ToString().Trim()))
                {
                    model.Banner = dr["介绍图"].ToString();
                }
                if (dr.Table.Columns.Contains("品牌视频地址") && !string.IsNullOrEmpty(dr["品牌视频地址"].ToString().Trim()))
                {
                    model.VideoUrl = dr["品牌视频地址"].ToString();
                }

                if (dr.Table.Columns.Contains("品牌分类") && !string.IsNullOrEmpty(dr["品牌分类"].ToString().Trim()))
                {
                    model.CategoryName = dr["品牌分类"].ToString();
                }
                if (dr.Table.Columns.Contains("品牌简介") && !string.IsNullOrEmpty(dr["品牌简介"].ToString().Trim()))
                {
                    model.Introduce = dr["品牌简介"].ToString();
                }
                if (dr.Table.Columns.Contains("店铺数量") && !string.IsNullOrEmpty(dr["店铺数量"].ToString().Trim()))
                {
                    Int32.TryParse(dr["店铺数量"].ToString(), out int ShopNum);
                    model.ShopNum = ShopNum;
                }
                if (dr.Table.Columns.Contains("需求面积(㎡)") && !string.IsNullOrEmpty(dr["需求面积(㎡)"].ToString().Trim()))
                {
                    decimal.TryParse(dr["需求面积(㎡)"].ToString(), out decimal AreaRequirement);
                    model.AreaRequirement = AreaRequirement;
                }
                if (dr.Table.Columns.Contains("客群定位") && !string.IsNullOrEmpty(dr["客群定位"].ToString().Trim()))
                {
                    model.CustomerType = dr["客群定位"].ToString();
                }
                if (dr.Table.Columns.Contains("品牌定位") && !string.IsNullOrEmpty(dr["品牌定位"].ToString().Trim()))
                {
                    model.BrandType = dr["品牌定位"].ToString();
                }
                if (dr.Table.Columns.Contains("合作条件") && !string.IsNullOrEmpty(dr["合作条件"].ToString().Trim()))
                {
                    model.Cooperation = dr["合作条件"].ToString();
                }
                if (dr.Table.Columns.Contains("物业需求") && !string.IsNullOrEmpty(dr["物业需求"].ToString().Trim()))
                {
                    model.PropertyDemand = dr["物业需求"].ToString();
                }
                if (dr.Table.Columns.Contains("配套需求") && !string.IsNullOrEmpty(dr["配套需求"].ToString().Trim()))
                {
                    model.Complementary = dr["配套需求"].ToString();
                }
                if (dr.Table.Columns.Contains("联系人") && !string.IsNullOrEmpty(dr["联系人"].ToString().Trim()))
                {
                    model.ContactName = dr["联系人"].ToString();
                }
                if (dr.Table.Columns.Contains("联系电话") && !string.IsNullOrEmpty(dr["联系电话"].ToString().Trim()))
                {
                    model.ContactPhone = dr["联系电话"].ToString();
                }
            }
            return model;
        }
    }

    /// <summary>
    /// 载体导入帮助类
    /// </summary>
    public class CarrierHelper
    {
        /// <summary>
        /// 载体导入
        /// </summary>
        /// <param name="fileName"></param>
        /// <param name="tempFilePath"></param>
        /// <returns></returns>
        public static List<RB_Building_Carrier_Extend> ImportYBCarrierData(string fileName, string tempFilePath)
        {
            //图片所在的列
            List<int> imgColList = new List<int>();
            imgColList.Add(1);
            List<RB_Building_Carrier_Extend> list = new List<RB_Building_Carrier_Extend>();
            Mall.Common.Plugin.ImportExcelNPOIHelper importExcelNPOIHelper = new Common.Plugin.ImportExcelNPOIHelper(tempFilePath);
            DataTable dt = importExcelNPOIHelper.ExcelToDataTable(fileName, 0, 0, true, imgColList: imgColList);
            if (dt != null && dt.Rows.Count > 0)
            {
                foreach (DataRow dr in dt.Rows)
                {
                    list.Add(DataRowToModel(dr));
                }
            }
            return list;
        }

        /// <summary>
        /// DataRow转实体
        /// </summary>
        /// <param name="dr"></param>
        /// <returns></returns>
        public static RB_Building_Carrier_Extend DataRowToModel(DataRow dr)
        {
            RB_Building_Carrier_Extend model = new RB_Building_Carrier_Extend()
            {
                CategoryName = "",
                Logo = "",
                Address = "",
                LatAndLon = "",
                OpeningStatus = 0,
                CarrierSize = 0,
                LayersNum = "",
                CarNum = 0,
                BuiltUpArea = 0,
                AreaRequirement = 0,
                VisitorsFlowrate = "",
                SupportingFacilities = "",
                ManagementCompany = "",
                Developers = "",
                Ascription = "",
                CarrierPlan = "",
                BrandDemand = "",
                Location = "",
                ContactName = "",
                ContactPhone = ""
            };
            if (dr != null)
            {
                if (dr.Table.Columns.Contains("项目名称") && !string.IsNullOrEmpty(dr["项目名称"].ToString().Trim()))
                {
                    model.CarrierName = dr["项目名称"].ToString();
                }
                if (dr.Table.Columns.Contains("介绍图") && !string.IsNullOrEmpty(dr["介绍图"].ToString().Trim()))
                {
                    model.Logo = dr["介绍图"].ToString();
                }
                if (dr.Table.Columns.Contains("项目位置") && !string.IsNullOrEmpty(dr["项目位置"].ToString().Trim()))
                {
                    model.Address = dr["项目位置"].ToString();
                }
                if (dr.Table.Columns.Contains("开业状态") && !string.IsNullOrEmpty(dr["开业状态"].ToString().Trim()))
                {
                    string str = dr["开业状态"].ToString().Trim();
                    model.OpeningStatus = str == "已开业" ? 1 : 0;
                }
                if (dr.Table.Columns.Contains("商业体量") && !string.IsNullOrEmpty(dr["商业体量"].ToString().Trim()))
                {
                    string CarrierSizeStr = dr["商业体量"].ToString().Replace("㎡", "").Trim();
                    decimal.TryParse(CarrierSizeStr, out decimal CarrierSize);
                    model.CarrierSize = CarrierSize;
                }
                if (dr.Table.Columns.Contains("商业层数") && !string.IsNullOrEmpty(dr["商业层数"].ToString().Trim()))
                {
                    model.LayersNum = dr["商业层数"].ToString();
                }
                if (dr.Table.Columns.Contains("车位数量") && !string.IsNullOrEmpty(dr["车位数量"].ToString().Trim()))
                {
                    string CarNumStr = dr["车位数量"].ToString().Replace("个", "").Trim();
                    int.TryParse(CarNumStr, out int CarNum);
                    model.CarNum = CarNum;
                }
                if (dr.Table.Columns.Contains("经营面积") && !string.IsNullOrEmpty(dr["经营面积"].ToString().Trim()))
                {
                    string BuiltUpAreaStr = dr["经营面积"].ToString().Replace("㎡", "").Trim();
                    decimal.TryParse(BuiltUpAreaStr, out decimal BuiltUpArea);
                    model.BuiltUpArea = BuiltUpArea;
                }
                if (dr.Table.Columns.Contains("可租面积") && !string.IsNullOrEmpty(dr["可租面积"].ToString().Trim()))
                {
                    string AreaRequirementStr = dr["可租面积"].ToString().Replace("㎡", "").Trim();
                    decimal.TryParse(AreaRequirementStr, out decimal AreaRequirement);
                    model.AreaRequirement = AreaRequirement;
                }

                if (dr.Table.Columns.Contains("开业时间") && !string.IsNullOrEmpty(dr["开业时间"].ToString().Trim()))
                {
                    string OpenTimeStr = Common.ConvertHelper.FormatDate(dr["开业时间"].ToString().Trim());
                    if (!string.IsNullOrEmpty(OpenTimeStr))
                    {
                        model.OpenTime = Convert.ToDateTime(OpenTimeStr);
                    }
        
                }
                if (dr.Table.Columns.Contains("人流量参数") && !string.IsNullOrEmpty(dr["人流量参数"].ToString().Trim()))
                {
                    model.VisitorsFlowrate = dr["人流量参数"].ToString();
                }
                if (dr.Table.Columns.Contains("水电气及配套") && !string.IsNullOrEmpty(dr["水电气及配套"].ToString().Trim()))
                {
                    model.SupportingFacilities = dr["水电气及配套"].ToString();
                }
                if (dr.Table.Columns.Contains("管理公司及管理费") && !string.IsNullOrEmpty(dr["管理公司及管理费"].ToString().Trim()))
                {
                    model.ManagementCompany = dr["管理公司及管理费"].ToString();
                }
                if (dr.Table.Columns.Contains("开发商") && !string.IsNullOrEmpty(dr["开发商"].ToString().Trim()))
                {
                    model.Developers = dr["开发商"].ToString();
                }
                if (dr.Table.Columns.Contains("物业构成") && !string.IsNullOrEmpty(dr["物业构成"].ToString().Trim()))
                {
                    model.CategoryName = dr["物业构成"].ToString();
                }
                if (dr.Table.Columns.Contains("资产权属") && !string.IsNullOrEmpty(dr["资产权属"].ToString().Trim()))
                {
                    model.Ascription = dr["资产权属"].ToString();
                }
                if (dr.Table.Columns.Contains("业态规划") && !string.IsNullOrEmpty(dr["业态规划"].ToString().Trim()))
                {
                    model.CarrierPlan = dr["业态规划"].ToString();
                }
                if (dr.Table.Columns.Contains("目标招商业态及品牌需求") && !string.IsNullOrEmpty(dr["目标招商业态及品牌需求"].ToString().Trim()))
                {
                    model.BrandDemand = dr["目标招商业态及品牌需求"].ToString();
                }
                if (dr.Table.Columns.Contains("项目发展及定位") && !string.IsNullOrEmpty(dr["项目发展及定位"].ToString().Trim()))
                {
                    model.Location = dr["项目发展及定位"].ToString();
                }
                if (dr.Table.Columns.Contains("联系人") && !string.IsNullOrEmpty(dr["联系人"].ToString().Trim()))
                {
                    model.ContactName = dr["联系人"].ToString();
                }
                if (dr.Table.Columns.Contains("联系电话") && !string.IsNullOrEmpty(dr["联系电话"].ToString().Trim()))
                {
                    model.ContactPhone = dr["联系电话"].ToString();
                }
            }
            return model;
        }
    }

    /// <summary>
    /// 楼宇帮助类
    /// </summary>
    public class BuildingHelper
    {
        /// <summary>
        /// 楼宇导入
        /// </summary>
        /// <param name="fileName"></param>
        /// <param name="tempFilePath"></param>
        /// <returns></returns>
        public static List<RB_Building_Extend> ImportYBuildingData(string fileName, string tempFilePath)
        {
            //图片所在的列
            List<int> imgColList = new List<int>();
            imgColList.Add(1);
            List<RB_Building_Extend> list = new List<RB_Building_Extend>();
            Mall.Common.Plugin.ImportExcelNPOIHelper importExcelNPOIHelper = new Common.Plugin.ImportExcelNPOIHelper(tempFilePath);
            DataTable dt = importExcelNPOIHelper.ExcelToDataTable(fileName, 0, 0, true, imgColList: imgColList);
            if (dt != null && dt.Rows.Count > 0)
            {
                foreach (DataRow dr in dt.Rows)
                {
                    list.Add(DataRowToModel(dr));
                }
            }
            return list;
        }

        /// <summary>
        /// DataRow转实体
        /// </summary>
        /// <param name="dr"></param>
        /// <returns></returns>
        public static RB_Building_Extend DataRowToModel(DataRow dr)
        {
            RB_Building_Extend model = new RB_Building_Extend()
            {
                BuildId = 0,
                Name = "",
                Banner = "",
                Address = "",
                LatAndLon = "",
                OperationTime = "",
                CategoryName = "",
                Areas = "",
                BuildingNum = "",
                FloorNum = "",
                ElevatorNum = "",
                FloorHeight = 0,
                Developers = "",
                PropertyComp = "",
                SaleOrSelf = "",
                IsAllOperate = 0,
                ConstructionTime = "",
                PropertyFee = 0,
                RentFee = 0,
                IndustryDirection = "",
                BrandDemand = "",
                Other = "",
                ContactName = "",
                ContactPhone = "",
                QIds = "",
                BannerList = new List<string>()
            };
            if (dr != null)
            {
                if (dr.Table.Columns.Contains("楼宇名称") && !string.IsNullOrEmpty(dr["楼宇名称"].ToString().Trim()))
                {
                    model.Name = dr["楼宇名称"].ToString();
                }
                if (dr.Table.Columns.Contains("楼宇图片") && !string.IsNullOrEmpty(dr["楼宇图片"].ToString().Trim()))
                {
                    model.Banner = dr["楼宇图片"].ToString();
                }
                if (dr.Table.Columns.Contains("楼宇位置") && !string.IsNullOrEmpty(dr["楼宇位置"].ToString().Trim()))
                {
                    model.Address = dr["楼宇位置"].ToString();
                }
                if (dr.Table.Columns.Contains("投运时间") && !string.IsNullOrEmpty(dr["投运时间"].ToString().Trim()))
                {
                    model.OperationTime = dr["投运时间"].ToString();
                }
                if (dr.Table.Columns.Contains("楼宇等级") && !string.IsNullOrEmpty(dr["楼宇等级"].ToString().Trim()))
                {
                    model.CategoryName = dr["楼宇等级"].ToString();
                }
                if (dr.Table.Columns.Contains("楼宇建筑面积（㎡）") && !string.IsNullOrEmpty(dr["楼宇建筑面积（㎡）"].ToString().Trim()))
                {
                    model.Areas = dr["楼宇建筑面积（㎡）"].ToString();
                }
                if (dr.Table.Columns.Contains("楼栋数量") && !string.IsNullOrEmpty(dr["楼栋数量"].ToString().Trim()))
                {
                    model.BuildingNum = dr["楼栋数量"].ToString();
                }
                if (dr.Table.Columns.Contains("楼层数") && !string.IsNullOrEmpty(dr["楼层数"].ToString().Trim()))
                {
                    model.FloorNum = dr["楼层数"].ToString();
                }
                if (dr.Table.Columns.Contains("电梯数") && !string.IsNullOrEmpty(dr["电梯数"].ToString().Trim()))
                {
                    model.ElevatorNum = dr["电梯数"].ToString();
                }
               
                if (dr.Table.Columns.Contains("层高（米）") && !string.IsNullOrEmpty(dr["层高（米）"].ToString().Trim()))
                {
                    string FloorHeightStr = dr["层高（米）"].ToString().Replace("㎡", "").Trim();
                    decimal.TryParse(FloorHeightStr, out decimal FloorHeight);
                    model.FloorHeight = FloorHeight;
                }

                if (dr.Table.Columns.Contains("开发商") && !string.IsNullOrEmpty(dr["开发商"].ToString().Trim()))
                {
                    model.Developers = dr["开发商"].ToString();
                }

                if (dr.Table.Columns.Contains("物业公司") && !string.IsNullOrEmpty(dr["物业公司"].ToString().Trim()))
                {
                    model.PropertyComp = dr["物业公司"].ToString();
                }

                if (dr.Table.Columns.Contains("销售/自持比例") && !string.IsNullOrEmpty(dr["销售/自持比例"].ToString().Trim()))
                {
                    model.SaleOrSelf = dr["销售/自持比例"].ToString();
                }

                if (dr.Table.Columns.Contains("是否统一运营") && !string.IsNullOrEmpty(dr["是否统一运营"].ToString().Trim()))
                {
                    string IsAllOperateStr = dr["是否统一运营"].ToString().Trim();
                    model.IsAllOperate = IsAllOperateStr == "是" ? 1 : 0;
                }
                if (dr.Table.Columns.Contains("建设时间") && !string.IsNullOrEmpty(dr["建设时间"].ToString().Trim()))
                {
                    model.ConstructionTime = dr["建设时间"].ToString().Trim();
                }
                if (dr.Table.Columns.Contains("物业费（元/㎡/月）") && !string.IsNullOrEmpty(dr["物业费（元/㎡/月）"].ToString().Trim()))
                {
                    string PropertyFeeStr = dr["物业费（元/㎡/月）"].ToString().Trim();
                    decimal.TryParse(PropertyFeeStr, out decimal PropertyFee);
                    model.PropertyFee = PropertyFee;
                }
                if (dr.Table.Columns.Contains("月租金(元/㎡/月)") && !string.IsNullOrEmpty(dr["月租金(元/㎡/月)"].ToString().Trim()))
                {
                    string rentFeeStr = dr["月租金(元/㎡/月)"].ToString().Trim();
                    decimal.TryParse(rentFeeStr, out decimal RentFee);
                    model.RentFee = RentFee;
                }

                if (dr.Table.Columns.Contains("拟主导产业方向") && !string.IsNullOrEmpty(dr["拟主导产业方向"].ToString().Trim()))
                {
                    model.IndustryDirection = dr["拟主导产业方向"].ToString();
                }
                if (dr.Table.Columns.Contains("目标企业招引需求") && !string.IsNullOrEmpty(dr["目标企业招引需求"].ToString().Trim()))
                {
                    model.BrandDemand = dr["目标企业招引需求"].ToString();
                }
                if (dr.Table.Columns.Contains("其它需求") && !string.IsNullOrEmpty(dr["其它需求"].ToString().Trim()))
                {
                    model.Other = dr["其它需求"].ToString();
                }
                if (dr.Table.Columns.Contains("名字") && !string.IsNullOrEmpty(dr["名字"].ToString().Trim()))
                {
                    model.ContactName = dr["名字"].ToString();
                }
                if (dr.Table.Columns.Contains("电话") && !string.IsNullOrEmpty(dr["电话"].ToString().Trim()))
                {
                    model.ContactPhone = dr["电话"].ToString();
                }
            }
            return model;
        }
    }


    /// <summary>
    /// 企业服务
    /// </summary>
    public class EnterpriseServiceHelper
    {
        /// <summary>
        /// 企业服务导入
        /// </summary>
        /// <param name="fileName"></param>
        /// <param name="tempFilePath"></param>
        /// <returns></returns>
        public static List<RB_EnterpriseServices_Extend> ImportYBEnterpriseData(string fileName, string tempFilePath)
        {
            //图片所在的列
            List<int> imgColList = new List<int>();
            imgColList.Add(1);
            List<RB_EnterpriseServices_Extend> list = new List<RB_EnterpriseServices_Extend>();
            Mall.Common.Plugin.ImportExcelNPOIHelper importExcelNPOIHelper = new Common.Plugin.ImportExcelNPOIHelper(tempFilePath);
            DataTable dt = importExcelNPOIHelper.ExcelToDataTable(fileName, 0, 0, true, imgColList: imgColList);
            if (dt != null && dt.Rows.Count > 0)
            {
                foreach (DataRow dr in dt.Rows)
                {
                    list.Add(DataRowToModel(dr));
                }
            }
            return list;
        }

        /// <summary>
        /// DataRow转实体
        /// </summary>
        /// <param name="dr"></param>
        /// <returns></returns>
        public static RB_EnterpriseServices_Extend DataRowToModel(DataRow dr)
        {
            RB_EnterpriseServices_Extend model = new RB_EnterpriseServices_Extend()
            {
                Name = "",
                Banner = "",
                Introduction = "",
                DevIntention = "",
                ETypeName = "",
                Address = "",
                LatAndLon = "",
                OperationTime = "",
                CategoryName = "",
                Renovation = "",
                Payment = "",
                HandoverDate = "",
                IntentionalFloor = "",
                ElevatorNum = "",
                PropertyFee = 0,
                RentFee = 0,
                ContactName = "",
                ContactPhone = "",
            };
            if (dr != null)
            {
                if (dr.Table.Columns.Contains("企业名称") && !string.IsNullOrEmpty(dr["企业名称"].ToString().Trim()))
                {
                    model.Name = dr["企业名称"].ToString();
                }
                if (dr.Table.Columns.Contains("企业logo") && !string.IsNullOrEmpty(dr["企业logo"].ToString().Trim()))
                {
                    model.Banner = dr["企业logo"].ToString();
                }
                if (dr.Table.Columns.Contains("企业简介") && !string.IsNullOrEmpty(dr["企业简介"].ToString().Trim()))
                {
                    model.Introduction = dr["企业简介"].ToString();
                }
                if (dr.Table.Columns.Contains("企业发展意向") && !string.IsNullOrEmpty(dr["企业发展意向"].ToString().Trim()))
                {
                    model.DevIntention = dr["企业发展意向"].ToString();
                }
                if (dr.Table.Columns.Contains("企业类别") && !string.IsNullOrEmpty(dr["企业类别"].ToString().Trim()))
                {
                    model.ETypeName = dr["企业类别"].ToString();
                }
                if (dr.Table.Columns.Contains("楼宇位置") && !string.IsNullOrEmpty(dr["楼宇位置"].ToString().Trim()))
                {
                    model.Address = dr["楼宇位置"].ToString();
                }
                if (dr.Table.Columns.Contains("投运时间") && !string.IsNullOrEmpty(dr["投运时间"].ToString().Trim()))
                {
                    model.OperationTime = dr["投运时间"].ToString();
                }
                if (dr.Table.Columns.Contains("楼宇等级") && !string.IsNullOrEmpty(dr["楼宇等级"].ToString().Trim()))
                {
                    model.CategoryName = dr["楼宇等级"].ToString();
                }

                if (dr.Table.Columns.Contains("楼宇装修") && !string.IsNullOrEmpty(dr["楼宇装修"].ToString().Trim()))
                {
                    model.Renovation = dr["楼宇装修"].ToString();
                }
                if (dr.Table.Columns.Contains("支付方式") && !string.IsNullOrEmpty(dr["支付方式"].ToString().Trim()))
                {
                    model.Payment = dr["支付方式"].ToString();
                }
                if (dr.Table.Columns.Contains("交房日期") && !string.IsNullOrEmpty(dr["交房日期"].ToString().Trim()))
                {
                    model.HandoverDate = dr["交房日期"].ToString();
                }
                if (dr.Table.Columns.Contains("意向楼层") && !string.IsNullOrEmpty(dr["意向楼层"].ToString().Trim()))
                {
                    model.IntentionalFloor = dr["意向楼层"].ToString();
                }
                if (dr.Table.Columns.Contains("电梯数量") && !string.IsNullOrEmpty(dr["电梯数量"].ToString().Trim()))
                {
                    model.ElevatorNum = dr["电梯数量"].ToString();
                }

                if (dr.Table.Columns.Contains("物业费（元/㎡/月）") && !string.IsNullOrEmpty(dr["物业费（元/㎡/月）"].ToString().Trim()))
                {
                    string PropertyFeeStr = dr["物业费（元/㎡/月）"].ToString().Trim();
                    decimal.TryParse(PropertyFeeStr, out decimal PropertyFee);
                    model.PropertyFee = PropertyFee;
                }
                if (dr.Table.Columns.Contains("月租金(元/㎡/月)") && !string.IsNullOrEmpty(dr["月租金(元/㎡/月)"].ToString().Trim()))
                {
                    string rentFeeStr = dr["月租金(元/㎡/月)"].ToString().Trim();
                    decimal.TryParse(rentFeeStr, out decimal RentFee);
                    model.RentFee = RentFee;
                }
                if (dr.Table.Columns.Contains("联系人") && !string.IsNullOrEmpty(dr["联系人"].ToString().Trim()))
                {
                    model.ContactName = dr["联系人"].ToString();
                }
                if (dr.Table.Columns.Contains("联系电话") && !string.IsNullOrEmpty(dr["联系电话"].ToString().Trim()))
                {
                    model.ContactPhone = dr["联系电话"].ToString();
                }
            }
            return model;
        }
    }
}
